/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectSourceVersionMarshaller {
    private static final MarshallingInfo<String> SOURCEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> SOURCEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceVersion").isBinary(false).build();
    private static final ProjectSourceVersionMarshaller INSTANCE = new ProjectSourceVersionMarshaller();

    private ProjectSourceVersionMarshaller() {
    }

    public static ProjectSourceVersionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectSourceVersion projectSourceVersion, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projectSourceVersion, (String)"projectSourceVersion");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projectSourceVersion.sourceIdentifier(), SOURCEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)projectSourceVersion.sourceVersion(), SOURCEVERSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

