/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.transform.SourceAuthUnmarshaller;

public class ProjectSourceUnmarshaller
implements Unmarshaller<ProjectSource, JsonUnmarshallerContext> {
    private static final ProjectSourceUnmarshaller INSTANCE = new ProjectSourceUnmarshaller();

    public ProjectSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        ProjectSource.Builder projectSourceBuilder = ProjectSource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("type", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.location((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("gitCloneDepth", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.gitCloneDepth((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("buildspec", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.buildspec((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("auth", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.auth(SourceAuthUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("reportBuildStatus", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.reportBuildStatus((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("insecureSsl", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.insecureSsl((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("sourceIdentifier", targetDepth)) {
                    context.nextToken();
                    projectSourceBuilder.sourceIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ProjectSource)projectSourceBuilder.build();
    }

    public static ProjectSourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

