/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.services.codebuild.transform.ProjectSourceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProjectSource
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectSource> {
    private final String type;
    private final String location;
    private final Integer gitCloneDepth;
    private final String buildspec;
    private final SourceAuth auth;
    private final Boolean reportBuildStatus;
    private final Boolean insecureSsl;
    private final String sourceIdentifier;

    private ProjectSource(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.gitCloneDepth = builder.gitCloneDepth;
        this.buildspec = builder.buildspec;
        this.auth = builder.auth;
        this.reportBuildStatus = builder.reportBuildStatus;
        this.insecureSsl = builder.insecureSsl;
        this.sourceIdentifier = builder.sourceIdentifier;
    }

    public SourceType type() {
        return SourceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public Integer gitCloneDepth() {
        return this.gitCloneDepth;
    }

    public String buildspec() {
        return this.buildspec;
    }

    public SourceAuth auth() {
        return this.auth;
    }

    public Boolean reportBuildStatus() {
        return this.reportBuildStatus;
    }

    public Boolean insecureSsl() {
        return this.insecureSsl;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitCloneDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildspec());
        hashCode = 31 * hashCode + Objects.hashCode(this.auth());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportBuildStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.insecureSsl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSource)) {
            return false;
        }
        ProjectSource other = (ProjectSource)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.gitCloneDepth(), other.gitCloneDepth()) && Objects.equals(this.buildspec(), other.buildspec()) && Objects.equals(this.auth(), other.auth()) && Objects.equals(this.reportBuildStatus(), other.reportBuildStatus()) && Objects.equals(this.insecureSsl(), other.insecureSsl()) && Objects.equals(this.sourceIdentifier(), other.sourceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"ProjectSource").add("Type", (Object)this.typeAsString()).add("Location", (Object)this.location()).add("GitCloneDepth", (Object)this.gitCloneDepth()).add("Buildspec", (Object)this.buildspec()).add("Auth", (Object)this.auth()).add("ReportBuildStatus", (Object)this.reportBuildStatus()).add("InsecureSsl", (Object)this.insecureSsl()).add("SourceIdentifier", (Object)this.sourceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "gitCloneDepth": {
                return Optional.ofNullable(clazz.cast(this.gitCloneDepth()));
            }
            case "buildspec": {
                return Optional.ofNullable(clazz.cast(this.buildspec()));
            }
            case "auth": {
                return Optional.ofNullable(clazz.cast(this.auth()));
            }
            case "reportBuildStatus": {
                return Optional.ofNullable(clazz.cast(this.reportBuildStatus()));
            }
            case "insecureSsl": {
                return Optional.ofNullable(clazz.cast(this.insecureSsl()));
            }
            case "sourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private Integer gitCloneDepth;
        private String buildspec;
        private SourceAuth auth;
        private Boolean reportBuildStatus;
        private Boolean insecureSsl;
        private String sourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSource model) {
            this.type(model.type);
            this.location(model.location);
            this.gitCloneDepth(model.gitCloneDepth);
            this.buildspec(model.buildspec);
            this.auth(model.auth);
            this.reportBuildStatus(model.reportBuildStatus);
            this.insecureSsl(model.insecureSsl);
            this.sourceIdentifier(model.sourceIdentifier);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Integer getGitCloneDepth() {
            return this.gitCloneDepth;
        }

        @Override
        public final Builder gitCloneDepth(Integer gitCloneDepth) {
            this.gitCloneDepth = gitCloneDepth;
            return this;
        }

        public final void setGitCloneDepth(Integer gitCloneDepth) {
            this.gitCloneDepth = gitCloneDepth;
        }

        public final String getBuildspec() {
            return this.buildspec;
        }

        @Override
        public final Builder buildspec(String buildspec) {
            this.buildspec = buildspec;
            return this;
        }

        public final void setBuildspec(String buildspec) {
            this.buildspec = buildspec;
        }

        public final SourceAuth.Builder getAuth() {
            return this.auth != null ? this.auth.toBuilder() : null;
        }

        @Override
        public final Builder auth(SourceAuth auth) {
            this.auth = auth;
            return this;
        }

        public final void setAuth(SourceAuth.BuilderImpl auth) {
            this.auth = auth != null ? auth.build() : null;
        }

        public final Boolean getReportBuildStatus() {
            return this.reportBuildStatus;
        }

        @Override
        public final Builder reportBuildStatus(Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
            return this;
        }

        public final void setReportBuildStatus(Boolean reportBuildStatus) {
            this.reportBuildStatus = reportBuildStatus;
        }

        public final Boolean getInsecureSsl() {
            return this.insecureSsl;
        }

        @Override
        public final Builder insecureSsl(Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
            return this;
        }

        public final void setInsecureSsl(Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public ProjectSource build() {
            return new ProjectSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectSource> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder location(String var1);

        public Builder gitCloneDepth(Integer var1);

        public Builder buildspec(String var1);

        public Builder auth(SourceAuth var1);

        default public Builder auth(Consumer<SourceAuth.Builder> auth) {
            return this.auth((SourceAuth)((SourceAuth.Builder)SourceAuth.builder().applyMutation(auth)).build());
        }

        public Builder reportBuildStatus(Boolean var1);

        public Builder insecureSsl(Boolean var1);

        public Builder sourceIdentifier(String var1);
    }
}

