/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectBadge;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.Tag;
import software.amazon.awssdk.services.codebuild.model.TagListCopier;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.services.codebuild.model.Webhook;
import software.amazon.awssdk.services.codebuild.transform.ProjectMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Project
implements StructuredPojo,
ToCopyableBuilder<Builder, Project> {
    private final String name;
    private final String arn;
    private final String description;
    private final ProjectSource source;
    private final List<ProjectSource> secondarySources;
    private final ProjectArtifacts artifacts;
    private final List<ProjectArtifacts> secondaryArtifacts;
    private final ProjectCache cache;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final Integer timeoutInMinutes;
    private final String encryptionKey;
    private final List<Tag> tags;
    private final Instant created;
    private final Instant lastModified;
    private final Webhook webhook;
    private final VpcConfig vpcConfig;
    private final ProjectBadge badge;

    private Project(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.description = builder.description;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
        this.created = builder.created;
        this.lastModified = builder.lastModified;
        this.webhook = builder.webhook;
        this.vpcConfig = builder.vpcConfig;
        this.badge = builder.badge;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String description() {
        return this.description;
    }

    public ProjectSource source() {
        return this.source;
    }

    public List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public ProjectArtifacts artifacts() {
        return this.artifacts;
    }

    public List<ProjectArtifacts> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public ProjectCache cache() {
        return this.cache;
    }

    public ProjectEnvironment environment() {
        return this.environment;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public String encryptionKey() {
        return this.encryptionKey;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Instant created() {
        return this.created;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Webhook webhook() {
        return this.webhook;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public ProjectBadge badge() {
        return this.badge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondarySources());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.cache());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.created());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.webhook());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.badge());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project other = (Project)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.secondarySources(), other.secondarySources()) && Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(this.cache(), other.cache()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.created(), other.created()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.webhook(), other.webhook()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.badge(), other.badge());
    }

    public String toString() {
        return ToString.builder((String)"Project").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("SecondarySources", this.secondarySources()).add("Artifacts", (Object)this.artifacts()).add("SecondaryArtifacts", this.secondaryArtifacts()).add("Cache", (Object)this.cache()).add("Environment", (Object)this.environment()).add("ServiceRole", (Object)this.serviceRole()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("EncryptionKey", (Object)this.encryptionKey()).add("Tags", this.tags()).add("Created", (Object)this.created()).add("LastModified", (Object)this.lastModified()).add("Webhook", (Object)this.webhook()).add("VpcConfig", (Object)this.vpcConfig()).add("Badge", (Object)this.badge()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
            case "cache": {
                return Optional.ofNullable(clazz.cast(this.cache()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "created": {
                return Optional.ofNullable(clazz.cast(this.created()));
            }
            case "lastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "webhook": {
                return Optional.ofNullable(clazz.cast(this.webhook()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "badge": {
                return Optional.ofNullable(clazz.cast(this.badge()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String description;
        private ProjectSource source;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private ProjectArtifacts artifacts;
        private List<ProjectArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ProjectCache cache;
        private ProjectEnvironment environment;
        private String serviceRole;
        private Integer timeoutInMinutes;
        private String encryptionKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant created;
        private Instant lastModified;
        private Webhook webhook;
        private VpcConfig vpcConfig;
        private ProjectBadge badge;

        private BuilderImpl() {
        }

        private BuilderImpl(Project model) {
            this.name(model.name);
            this.arn(model.arn);
            this.description(model.description);
            this.source(model.source);
            this.secondarySources(model.secondarySources);
            this.artifacts(model.artifacts);
            this.secondaryArtifacts(model.secondaryArtifacts);
            this.cache(model.cache);
            this.environment(model.environment);
            this.serviceRole(model.serviceRole);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.encryptionKey(model.encryptionKey);
            this.tags(model.tags);
            this.created(model.created);
            this.lastModified(model.lastModified);
            this.webhook(model.webhook);
            this.vpcConfig(model.vpcConfig);
            this.badge(model.badge);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final Collection<ProjectSource.Builder> getSecondarySources() {
            return this.secondarySources != null ? (Collection)this.secondarySources.stream().map(ProjectSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        public final ProjectArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        @Override
        public final Builder artifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(ProjectArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        public final Collection<ProjectArtifacts.Builder> getSecondaryArtifacts() {
            return this.secondaryArtifacts != null ? (Collection)this.secondaryArtifacts.stream().map(ProjectArtifacts::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(ProjectArtifacts ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecondaryArtifacts(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        public final ProjectCache.Builder getCache() {
            return this.cache != null ? this.cache.toBuilder() : null;
        }

        @Override
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getCreated() {
            return this.created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Webhook.Builder getWebhook() {
            return this.webhook != null ? this.webhook.toBuilder() : null;
        }

        @Override
        public final Builder webhook(Webhook webhook) {
            this.webhook = webhook;
            return this;
        }

        public final void setWebhook(Webhook.BuilderImpl webhook) {
            this.webhook = webhook != null ? webhook.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final ProjectBadge.Builder getBadge() {
            return this.badge != null ? this.badge.toBuilder() : null;
        }

        @Override
        public final Builder badge(ProjectBadge badge) {
            this.badge = badge;
            return this;
        }

        public final void setBadge(ProjectBadge.BuilderImpl badge) {
            this.badge = badge != null ? badge.build() : null;
        }

        public Project build() {
            return new Project(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Project> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder artifacts(ProjectArtifacts var1);

        default public Builder artifacts(Consumer<ProjectArtifacts.Builder> artifacts) {
            return this.artifacts((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder secondaryArtifacts(Collection<ProjectArtifacts> var1);

        public Builder secondaryArtifacts(ProjectArtifacts ... var1);

        public Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder> ... var1);

        public Builder cache(ProjectCache var1);

        default public Builder cache(Consumer<ProjectCache.Builder> cache) {
            return this.cache((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cache)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder serviceRole(String var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder encryptionKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder created(Instant var1);

        public Builder lastModified(Instant var1);

        public Builder webhook(Webhook var1);

        default public Builder webhook(Consumer<Webhook.Builder> webhook) {
            return this.webhook((Webhook)((Webhook.Builder)Webhook.builder().applyMutation(webhook)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder badge(ProjectBadge var1);

        default public Builder badge(Consumer<ProjectBadge.Builder> badge) {
            return this.badge((ProjectBadge)((ProjectBadge.Builder)ProjectBadge.builder().applyMutation(badge)).build());
        }
    }
}

