/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.ImageVersionsCopier;
import software.amazon.awssdk.services.codebuild.transform.EnvironmentImageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentImage
implements StructuredPojo,
ToCopyableBuilder<Builder, EnvironmentImage> {
    private final String name;
    private final String description;
    private final List<String> versions;

    private EnvironmentImage(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.versions = builder.versions;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<String> versions() {
        return this.versions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentImage)) {
            return false;
        }
        EnvironmentImage other = (EnvironmentImage)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.versions(), other.versions());
    }

    public String toString() {
        return ToString.builder((String)"EnvironmentImage").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Versions", this.versions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentImageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> versions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentImage model) {
            this.name(model.name);
            this.description(model.description);
            this.versions(model.versions);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getVersions() {
            return this.versions;
        }

        @Override
        public final Builder versions(Collection<String> versions) {
            this.versions = ImageVersionsCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(String ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        public final void setVersions(Collection<String> versions) {
            this.versions = ImageVersionsCopier.copy(versions);
        }

        public EnvironmentImage build() {
            return new EnvironmentImage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnvironmentImage> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder versions(Collection<String> var1);

        public Builder versions(String ... var1);
    }
}

