/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectEnvironmentMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").isBinary(false).build();
    private static final MarshallingInfo<String> COMPUTETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeType").isBinary(false).build();
    private static final MarshallingInfo<List> ENVIRONMENTVARIABLES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("environmentVariables").isBinary(false).build();
    private static final MarshallingInfo<Boolean> PRIVILEGEDMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("privilegedMode").isBinary(false).build();
    private static final ProjectEnvironmentMarshaller INSTANCE = new ProjectEnvironmentMarshaller();

    private ProjectEnvironmentMarshaller() {
    }

    public static ProjectEnvironmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProjectEnvironment projectEnvironment, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projectEnvironment, (String)"projectEnvironment");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projectEnvironment.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)projectEnvironment.image(), IMAGE_BINDING);
            protocolMarshaller.marshall((Object)projectEnvironment.computeTypeAsString(), COMPUTETYPE_BINDING);
            protocolMarshaller.marshall(projectEnvironment.environmentVariables(), ENVIRONMENTVARIABLES_BINDING);
            protocolMarshaller.marshall((Object)projectEnvironment.privilegedMode(), PRIVILEGEDMODE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

