/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.SourceAuthType;
import software.amazon.awssdk.services.codebuild.transform.SourceAuthMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceAuth
implements StructuredPojo,
ToCopyableBuilder<Builder, SourceAuth> {
    private final String type;
    private final String resource;

    private SourceAuth(BuilderImpl builder) {
        this.type = builder.type;
        this.resource = builder.resource;
    }

    public SourceAuthType type() {
        return SourceAuthType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAuth)) {
            return false;
        }
        SourceAuth other = (SourceAuth)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.resource(), other.resource());
    }

    public String toString() {
        return ToString.builder((String)"SourceAuth").add("Type", (Object)this.typeAsString()).add("Resource", (Object)this.resource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SourceAuthMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAuth model) {
            this.type(model.type);
            this.resource(model.resource);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceAuthType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public SourceAuth build() {
            return new SourceAuth(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SourceAuth> {
        public Builder type(String var1);

        public Builder type(SourceAuthType var1);

        public Builder resource(String var1);
    }
}

