/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildResponse;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatform;
import software.amazon.awssdk.services.codebuild.model.EnvironmentPlatformsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCuratedEnvironmentImagesResponse
extends CodeBuildResponse
implements ToCopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
    private final List<EnvironmentPlatform> platforms;

    private ListCuratedEnvironmentImagesResponse(BuilderImpl builder) {
        super(builder);
        this.platforms = builder.platforms;
    }

    public List<EnvironmentPlatform> platforms() {
        return this.platforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.platforms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCuratedEnvironmentImagesResponse)) {
            return false;
        }
        ListCuratedEnvironmentImagesResponse other = (ListCuratedEnvironmentImagesResponse)((Object)obj);
        return Objects.equals(this.platforms(), other.platforms());
    }

    public String toString() {
        return ToString.builder((String)"ListCuratedEnvironmentImagesResponse").add("Platforms", this.platforms()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platforms": {
                return Optional.ofNullable(clazz.cast(this.platforms()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeBuildResponse.BuilderImpl
    implements Builder {
        private List<EnvironmentPlatform> platforms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCuratedEnvironmentImagesResponse model) {
            super(model);
            this.platforms(model.platforms);
        }

        public final Collection<EnvironmentPlatform.Builder> getPlatforms() {
            return this.platforms != null ? (Collection)this.platforms.stream().map(EnvironmentPlatform::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder platforms(Collection<EnvironmentPlatform> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(EnvironmentPlatform ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(Consumer<EnvironmentPlatform.Builder> ... platforms) {
            this.platforms(Stream.of(platforms).map(c -> (EnvironmentPlatform)((EnvironmentPlatform.Builder)EnvironmentPlatform.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPlatforms(Collection<EnvironmentPlatform.BuilderImpl> platforms) {
            this.platforms = EnvironmentPlatformsCopier.copyFromBuilder(platforms);
        }

        @Override
        public ListCuratedEnvironmentImagesResponse build() {
            return new ListCuratedEnvironmentImagesResponse(this);
        }
    }

    public static interface Builder
    extends CodeBuildResponse.Builder,
    CopyableBuilder<Builder, ListCuratedEnvironmentImagesResponse> {
        public Builder platforms(Collection<EnvironmentPlatform> var1);

        public Builder platforms(EnvironmentPlatform ... var1);

        public Builder platforms(Consumer<EnvironmentPlatform.Builder> ... var1);
    }
}

