/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.BuildArtifacts;
import software.amazon.awssdk.services.codebuild.model.BuildPhase;
import software.amazon.awssdk.services.codebuild.model.BuildPhasesCopier;
import software.amazon.awssdk.services.codebuild.model.LogsLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.StatusType;
import software.amazon.awssdk.services.codebuild.transform.BuildMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Build
implements StructuredPojo,
ToCopyableBuilder<Builder, Build> {
    private final String id;
    private final String arn;
    private final Instant startTime;
    private final Instant endTime;
    private final String currentPhase;
    private final String buildStatus;
    private final String sourceVersion;
    private final String projectName;
    private final List<BuildPhase> phases;
    private final ProjectSource source;
    private final BuildArtifacts artifacts;
    private final ProjectEnvironment environment;
    private final LogsLocation logs;
    private final Integer timeoutInMinutes;
    private final Boolean buildComplete;
    private final String initiator;

    private Build(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.currentPhase = builder.currentPhase;
        this.buildStatus = builder.buildStatus;
        this.sourceVersion = builder.sourceVersion;
        this.projectName = builder.projectName;
        this.phases = builder.phases;
        this.source = builder.source;
        this.artifacts = builder.artifacts;
        this.environment = builder.environment;
        this.logs = builder.logs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.buildComplete = builder.buildComplete;
        this.initiator = builder.initiator;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String currentPhase() {
        return this.currentPhase;
    }

    public StatusType buildStatus() {
        return StatusType.fromValue(this.buildStatus);
    }

    public String buildStatusAsString() {
        return this.buildStatus;
    }

    public String sourceVersion() {
        return this.sourceVersion;
    }

    public String projectName() {
        return this.projectName;
    }

    public List<BuildPhase> phases() {
        return this.phases;
    }

    public ProjectSource source() {
        return this.source;
    }

    public BuildArtifacts artifacts() {
        return this.artifacts;
    }

    public ProjectEnvironment environment() {
        return this.environment;
    }

    public LogsLocation logs() {
        return this.logs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public Boolean buildComplete() {
        return this.buildComplete;
    }

    public String initiator() {
        return this.initiator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPhase());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.phases());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildComplete());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Build)) {
            return false;
        }
        Build other = (Build)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.currentPhase(), other.currentPhase()) && Objects.equals(this.buildStatusAsString(), other.buildStatusAsString()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && Objects.equals(this.projectName(), other.projectName()) && Objects.equals(this.phases(), other.phases()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.buildComplete(), other.buildComplete()) && Objects.equals(this.initiator(), other.initiator());
    }

    public String toString() {
        return ToString.builder((String)"Build").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CurrentPhase", (Object)this.currentPhase()).add("BuildStatus", (Object)this.buildStatusAsString()).add("SourceVersion", (Object)this.sourceVersion()).add("ProjectName", (Object)this.projectName()).add("Phases", this.phases()).add("Source", (Object)this.source()).add("Artifacts", (Object)this.artifacts()).add("Environment", (Object)this.environment()).add("Logs", (Object)this.logs()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("BuildComplete", (Object)this.buildComplete()).add("Initiator", (Object)this.initiator()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "currentPhase": {
                return Optional.ofNullable(clazz.cast(this.currentPhase()));
            }
            case "buildStatus": {
                return Optional.ofNullable(clazz.cast(this.buildStatusAsString()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "projectName": {
                return Optional.ofNullable(clazz.cast(this.projectName()));
            }
            case "phases": {
                return Optional.ofNullable(clazz.cast(this.phases()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "buildComplete": {
                return Optional.ofNullable(clazz.cast(this.buildComplete()));
            }
            case "initiator": {
                return Optional.ofNullable(clazz.cast(this.initiator()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BuildMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private Instant startTime;
        private Instant endTime;
        private String currentPhase;
        private String buildStatus;
        private String sourceVersion;
        private String projectName;
        private List<BuildPhase> phases = DefaultSdkAutoConstructList.getInstance();
        private ProjectSource source;
        private BuildArtifacts artifacts;
        private ProjectEnvironment environment;
        private LogsLocation logs;
        private Integer timeoutInMinutes;
        private Boolean buildComplete;
        private String initiator;

        private BuilderImpl() {
        }

        private BuilderImpl(Build model) {
            this.id(model.id);
            this.arn(model.arn);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.currentPhase(model.currentPhase);
            this.buildStatus(model.buildStatus);
            this.sourceVersion(model.sourceVersion);
            this.projectName(model.projectName);
            this.phases(model.phases);
            this.source(model.source);
            this.artifacts(model.artifacts);
            this.environment(model.environment);
            this.logs(model.logs);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.buildComplete(model.buildComplete);
            this.initiator(model.initiator);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getCurrentPhase() {
            return this.currentPhase;
        }

        @Override
        public final Builder currentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
            return this;
        }

        public final void setCurrentPhase(String currentPhase) {
            this.currentPhase = currentPhase;
        }

        public final String getBuildStatus() {
            return this.buildStatus;
        }

        @Override
        public final Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            return this;
        }

        @Override
        public final Builder buildStatus(StatusType buildStatus) {
            this.buildStatus(buildStatus.toString());
            return this;
        }

        public final void setBuildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        public final String getProjectName() {
            return this.projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final Collection<BuildPhase.Builder> getPhases() {
            return this.phases != null ? (Collection)this.phases.stream().map(BuildPhase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder phases(Collection<BuildPhase> phases) {
            this.phases = BuildPhasesCopier.copy(phases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(BuildPhase ... phases) {
            this.phases(Arrays.asList(phases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phases(Consumer<BuildPhase.Builder> ... phases) {
            this.phases(Stream.of(phases).map(c -> (BuildPhase)((BuildPhase.Builder)BuildPhase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhases(Collection<BuildPhase.BuilderImpl> phases) {
            this.phases = BuildPhasesCopier.copyFromBuilder(phases);
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final BuildArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        @Override
        public final Builder artifacts(BuildArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final void setArtifacts(BuildArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final LogsLocation.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        @Override
        public final Builder logs(LogsLocation logs) {
            this.logs = logs;
            return this;
        }

        public final void setLogs(LogsLocation.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Boolean getBuildComplete() {
            return this.buildComplete;
        }

        @Override
        public final Builder buildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
            return this;
        }

        public final void setBuildComplete(Boolean buildComplete) {
            this.buildComplete = buildComplete;
        }

        public final String getInitiator() {
            return this.initiator;
        }

        @Override
        public final Builder initiator(String initiator) {
            this.initiator = initiator;
            return this;
        }

        public final void setInitiator(String initiator) {
            this.initiator = initiator;
        }

        public Build build() {
            return new Build(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Build> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder currentPhase(String var1);

        public Builder buildStatus(String var1);

        public Builder buildStatus(StatusType var1);

        public Builder sourceVersion(String var1);

        public Builder projectName(String var1);

        public Builder phases(Collection<BuildPhase> var1);

        public Builder phases(BuildPhase ... var1);

        public Builder phases(Consumer<BuildPhase.Builder> ... var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder artifacts(BuildArtifacts var1);

        default public Builder artifacts(Consumer<BuildArtifacts.Builder> artifacts) {
            return this.artifacts((BuildArtifacts)((BuildArtifacts.Builder)BuildArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder logs(LogsLocation var1);

        default public Builder logs(Consumer<LogsLocation.Builder> logs) {
            return this.logs((LogsLocation)((LogsLocation.Builder)LogsLocation.builder().applyMutation(logs)).build());
        }

        public Builder timeoutInMinutes(Integer var1);

        public Builder buildComplete(Boolean var1);

        public Builder initiator(String var1);
    }
}

