/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceAuthType {
    OAUTH("OAUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SourceAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SourceAuthType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceAuthType> knownValues() {
        return Stream.of(SourceAuthType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

