/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.codebuild.model.SourceAuth;
import software.amazon.awssdk.services.codebuild.model.SourceType;
import software.amazon.awssdk.services.codebuild.transform.ProjectSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProjectSource
implements StructuredPojo,
ToCopyableBuilder<Builder, ProjectSource> {
    private final String type;
    private final String location;
    private final String buildspec;
    private final SourceAuth auth;

    private ProjectSource(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.buildspec = builder.buildspec;
        this.auth = builder.auth;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public String buildspec() {
        return this.buildspec;
    }

    public SourceAuth auth() {
        return this.auth;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.location() == null ? 0 : this.location().hashCode());
        hashCode = 31 * hashCode + (this.buildspec() == null ? 0 : this.buildspec().hashCode());
        hashCode = 31 * hashCode + (this.auth() == null ? 0 : this.auth().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectSource)) {
            return false;
        }
        ProjectSource other = (ProjectSource)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.location() == null ^ this.location() == null) {
            return false;
        }
        if (other.location() != null && !other.location().equals(this.location())) {
            return false;
        }
        if (other.buildspec() == null ^ this.buildspec() == null) {
            return false;
        }
        if (other.buildspec() != null && !other.buildspec().equals(this.buildspec())) {
            return false;
        }
        if (other.auth() == null ^ this.auth() == null) {
            return false;
        }
        return other.auth() == null || other.auth().equals(this.auth());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.location() != null) {
            sb.append("Location: ").append(this.location()).append(",");
        }
        if (this.buildspec() != null) {
            sb.append("Buildspec: ").append(this.buildspec()).append(",");
        }
        if (this.auth() != null) {
            sb.append("Auth: ").append(this.auth()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProjectSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private String location;
        private String buildspec;
        private SourceAuth auth;

        private BuilderImpl() {
        }

        private BuilderImpl(ProjectSource model) {
            this.setType(model.type);
            this.setLocation(model.location);
            this.setBuildspec(model.buildspec);
            this.setAuth(model.auth);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(SourceType type) {
            this.type(type.toString());
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBuildspec() {
            return this.buildspec;
        }

        @Override
        public final Builder buildspec(String buildspec) {
            this.buildspec = buildspec;
            return this;
        }

        public final void setBuildspec(String buildspec) {
            this.buildspec = buildspec;
        }

        public final SourceAuth getAuth() {
            return this.auth;
        }

        @Override
        public final Builder auth(SourceAuth auth) {
            this.auth = auth;
            return this;
        }

        public final void setAuth(SourceAuth auth) {
            this.auth = auth;
        }

        public ProjectSource build() {
            return new ProjectSource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProjectSource> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder location(String var1);

        public Builder buildspec(String var1);

        public Builder auth(SourceAuth var1);
    }
}

