/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.AssociatedPackage;
import software.amazon.awssdk.services.codeartifact.model.AssociatedPackageListCopier;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedPackagesResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListAssociatedPackagesResponse> {
    private static final SdkField<List<AssociatedPackage>> PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("packages").getter(ListAssociatedPackagesResponse.getter(ListAssociatedPackagesResponse::packages)).setter(ListAssociatedPackagesResponse.setter(Builder::packages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedPackage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedPackagesResponse.getter(ListAssociatedPackagesResponse::nextToken)).setter(ListAssociatedPackagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("packages", PACKAGES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AssociatedPackage> packages;
    private final String nextToken;

    private ListAssociatedPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.packages = builder.packages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPackages() {
        return this.packages != null && !(this.packages instanceof SdkAutoConstructList);
    }

    public final List<AssociatedPackage> packages() {
        return this.packages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackages() ? this.packages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedPackagesResponse)) {
            return false;
        }
        ListAssociatedPackagesResponse other = (ListAssociatedPackagesResponse)((Object)obj);
        return this.hasPackages() == other.hasPackages() && Objects.equals(this.packages(), other.packages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedPackagesResponse").add("Packages", this.hasPackages() ? this.packages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packages": {
                return Optional.ofNullable(clazz.cast(this.packages()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedPackagesResponse, T> g) {
        return obj -> g.apply((ListAssociatedPackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private List<AssociatedPackage> packages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedPackagesResponse model) {
            super(model);
            this.packages(model.packages);
            this.nextToken(model.nextToken);
        }

        public final List<AssociatedPackage.Builder> getPackages() {
            List<AssociatedPackage.Builder> result = AssociatedPackageListCopier.copyToBuilder(this.packages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackages(Collection<AssociatedPackage.BuilderImpl> packages) {
            this.packages = AssociatedPackageListCopier.copyFromBuilder(packages);
        }

        @Override
        public final Builder packages(Collection<AssociatedPackage> packages) {
            this.packages = AssociatedPackageListCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(AssociatedPackage ... packages) {
            this.packages(Arrays.asList(packages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(Consumer<AssociatedPackage.Builder> ... packages) {
            this.packages(Stream.of(packages).map(c -> (AssociatedPackage)((AssociatedPackage.Builder)AssociatedPackage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedPackagesResponse build() {
            return new ListAssociatedPackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedPackagesResponse> {
        public Builder packages(Collection<AssociatedPackage> var1);

        public Builder packages(AssociatedPackage ... var1);

        public Builder packages(Consumer<AssociatedPackage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

