/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupAssociationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedPackage> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(AssociatedPackage.getter(AssociatedPackage::formatAsString)).setter(AssociatedPackage.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(AssociatedPackage.getter(AssociatedPackage::namespace)).setter(AssociatedPackage.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(AssociatedPackage.getter(AssociatedPackage::packageValue)).setter(AssociatedPackage.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final SdkField<String> ASSOCIATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationType").getter(AssociatedPackage.getter(AssociatedPackage::associationTypeAsString)).setter(AssociatedPackage.setter(Builder::associationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, ASSOCIATION_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final String associationType;

    private AssociatedPackage(BuilderImpl builder) {
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.associationType = builder.associationType;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final PackageGroupAssociationType associationType() {
        return PackageGroupAssociationType.fromValue(this.associationType);
    }

    public final String associationTypeAsString() {
        return this.associationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedPackage)) {
            return false;
        }
        AssociatedPackage other = (AssociatedPackage)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.associationTypeAsString(), other.associationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedPackage").add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("AssociationType", (Object)this.associationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "associationType": {
                return Optional.ofNullable(clazz.cast(this.associationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedPackage, T> g) {
        return obj -> g.apply((AssociatedPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private String namespace;
        private String packageValue;
        private String associationType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedPackage model) {
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.associationType(model.associationType);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getAssociationType() {
            return this.associationType;
        }

        public final void setAssociationType(String associationType) {
            this.associationType = associationType;
        }

        @Override
        public final Builder associationType(String associationType) {
            this.associationType = associationType;
            return this;
        }

        @Override
        public final Builder associationType(PackageGroupAssociationType associationType) {
            this.associationType(associationType == null ? null : associationType.toString());
            return this;
        }

        public AssociatedPackage build() {
            return new AssociatedPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedPackage> {
        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder associationType(String var1);

        public Builder associationType(PackageGroupAssociationType var1);
    }
}

