/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupOriginRestrictionMode;
import software.amazon.awssdk.services.codeartifact.model.PackageGroupReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageGroupOriginRestriction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageGroupOriginRestriction> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(PackageGroupOriginRestriction.getter(PackageGroupOriginRestriction::modeAsString)).setter(PackageGroupOriginRestriction.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<String> EFFECTIVE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("effectiveMode").getter(PackageGroupOriginRestriction.getter(PackageGroupOriginRestriction::effectiveModeAsString)).setter(PackageGroupOriginRestriction.setter(Builder::effectiveMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveMode").build()}).build();
    private static final SdkField<PackageGroupReference> INHERITED_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inheritedFrom").getter(PackageGroupOriginRestriction.getter(PackageGroupOriginRestriction::inheritedFrom)).setter(PackageGroupOriginRestriction.setter(Builder::inheritedFrom)).constructor(PackageGroupReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inheritedFrom").build()}).build();
    private static final SdkField<Long> REPOSITORIES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("repositoriesCount").getter(PackageGroupOriginRestriction.getter(PackageGroupOriginRestriction::repositoriesCount)).setter(PackageGroupOriginRestriction.setter(Builder::repositoriesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoriesCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, EFFECTIVE_MODE_FIELD, INHERITED_FROM_FIELD, REPOSITORIES_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final String effectiveMode;
    private final PackageGroupReference inheritedFrom;
    private final Long repositoriesCount;

    private PackageGroupOriginRestriction(BuilderImpl builder) {
        this.mode = builder.mode;
        this.effectiveMode = builder.effectiveMode;
        this.inheritedFrom = builder.inheritedFrom;
        this.repositoriesCount = builder.repositoriesCount;
    }

    public final PackageGroupOriginRestrictionMode mode() {
        return PackageGroupOriginRestrictionMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final PackageGroupOriginRestrictionMode effectiveMode() {
        return PackageGroupOriginRestrictionMode.fromValue(this.effectiveMode);
    }

    public final String effectiveModeAsString() {
        return this.effectiveMode;
    }

    public final PackageGroupReference inheritedFrom() {
        return this.inheritedFrom;
    }

    public final Long repositoriesCount() {
        return this.repositoriesCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inheritedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoriesCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageGroupOriginRestriction)) {
            return false;
        }
        PackageGroupOriginRestriction other = (PackageGroupOriginRestriction)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.effectiveModeAsString(), other.effectiveModeAsString()) && Objects.equals(this.inheritedFrom(), other.inheritedFrom()) && Objects.equals(this.repositoriesCount(), other.repositoriesCount());
    }

    public final String toString() {
        return ToString.builder((String)"PackageGroupOriginRestriction").add("Mode", (Object)this.modeAsString()).add("EffectiveMode", (Object)this.effectiveModeAsString()).add("InheritedFrom", (Object)this.inheritedFrom()).add("RepositoriesCount", (Object)this.repositoriesCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "effectiveMode": {
                return Optional.ofNullable(clazz.cast(this.effectiveModeAsString()));
            }
            case "inheritedFrom": {
                return Optional.ofNullable(clazz.cast(this.inheritedFrom()));
            }
            case "repositoriesCount": {
                return Optional.ofNullable(clazz.cast(this.repositoriesCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageGroupOriginRestriction, T> g) {
        return obj -> g.apply((PackageGroupOriginRestriction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private String effectiveMode;
        private PackageGroupReference inheritedFrom;
        private Long repositoriesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageGroupOriginRestriction model) {
            this.mode(model.mode);
            this.effectiveMode(model.effectiveMode);
            this.inheritedFrom(model.inheritedFrom);
            this.repositoriesCount(model.repositoriesCount);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(PackageGroupOriginRestrictionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getEffectiveMode() {
            return this.effectiveMode;
        }

        public final void setEffectiveMode(String effectiveMode) {
            this.effectiveMode = effectiveMode;
        }

        @Override
        public final Builder effectiveMode(String effectiveMode) {
            this.effectiveMode = effectiveMode;
            return this;
        }

        @Override
        public final Builder effectiveMode(PackageGroupOriginRestrictionMode effectiveMode) {
            this.effectiveMode(effectiveMode == null ? null : effectiveMode.toString());
            return this;
        }

        public final PackageGroupReference.Builder getInheritedFrom() {
            return this.inheritedFrom != null ? this.inheritedFrom.toBuilder() : null;
        }

        public final void setInheritedFrom(PackageGroupReference.BuilderImpl inheritedFrom) {
            this.inheritedFrom = inheritedFrom != null ? inheritedFrom.build() : null;
        }

        @Override
        public final Builder inheritedFrom(PackageGroupReference inheritedFrom) {
            this.inheritedFrom = inheritedFrom;
            return this;
        }

        public final Long getRepositoriesCount() {
            return this.repositoriesCount;
        }

        public final void setRepositoriesCount(Long repositoriesCount) {
            this.repositoriesCount = repositoriesCount;
        }

        @Override
        public final Builder repositoriesCount(Long repositoriesCount) {
            this.repositoriesCount = repositoriesCount;
            return this;
        }

        public PackageGroupOriginRestriction build() {
            return new PackageGroupOriginRestriction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageGroupOriginRestriction> {
        public Builder mode(String var1);

        public Builder mode(PackageGroupOriginRestrictionMode var1);

        public Builder effectiveMode(String var1);

        public Builder effectiveMode(PackageGroupOriginRestrictionMode var1);

        public Builder inheritedFrom(PackageGroupReference var1);

        default public Builder inheritedFrom(Consumer<PackageGroupReference.Builder> inheritedFrom) {
            return this.inheritedFrom((PackageGroupReference)((PackageGroupReference.Builder)PackageGroupReference.builder().applyMutation(inheritedFrom)).build());
        }

        public Builder repositoriesCount(Long var1);
    }
}

