/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PackageDependency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PackageDependency> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(PackageDependency.getter(PackageDependency::namespace)).setter(PackageDependency.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(PackageDependency.getter(PackageDependency::packageValue)).setter(PackageDependency.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final SdkField<String> DEPENDENCY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dependencyType").getter(PackageDependency.getter(PackageDependency::dependencyType)).setter(PackageDependency.setter(Builder::dependencyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencyType").build()}).build();
    private static final SdkField<String> VERSION_REQUIREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionRequirement").getter(PackageDependency.getter(PackageDependency::versionRequirement)).setter(PackageDependency.setter(Builder::versionRequirement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRequirement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, PACKAGE_FIELD, DEPENDENCY_TYPE_FIELD, VERSION_REQUIREMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String namespace;
    private final String packageValue;
    private final String dependencyType;
    private final String versionRequirement;

    private PackageDependency(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.dependencyType = builder.dependencyType;
        this.versionRequirement = builder.versionRequirement;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final String dependencyType() {
        return this.dependencyType;
    }

    public final String versionRequirement() {
        return this.versionRequirement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.dependencyType());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionRequirement());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDependency)) {
            return false;
        }
        PackageDependency other = (PackageDependency)obj;
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.dependencyType(), other.dependencyType()) && Objects.equals(this.versionRequirement(), other.versionRequirement());
    }

    public final String toString() {
        return ToString.builder((String)"PackageDependency").add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("DependencyType", (Object)this.dependencyType()).add("VersionRequirement", (Object)this.versionRequirement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "dependencyType": {
                return Optional.ofNullable(clazz.cast(this.dependencyType()));
            }
            case "versionRequirement": {
                return Optional.ofNullable(clazz.cast(this.versionRequirement()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PackageDependency, T> g) {
        return obj -> g.apply((PackageDependency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String packageValue;
        private String dependencyType;
        private String versionRequirement;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDependency model) {
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.dependencyType(model.dependencyType);
            this.versionRequirement(model.versionRequirement);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        @Transient
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getDependencyType() {
            return this.dependencyType;
        }

        public final void setDependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
        }

        @Override
        @Transient
        public final Builder dependencyType(String dependencyType) {
            this.dependencyType = dependencyType;
            return this;
        }

        public final String getVersionRequirement() {
            return this.versionRequirement;
        }

        public final void setVersionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
        }

        @Override
        @Transient
        public final Builder versionRequirement(String versionRequirement) {
            this.versionRequirement = versionRequirement;
            return this;
        }

        public PackageDependency build() {
            return new PackageDependency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PackageDependency> {
        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder dependencyType(String var1);

        public Builder versionRequirement(String var1);
    }
}

