/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.AssetSummary;
import software.amazon.awssdk.services.codeartifact.model.AssetSummaryListCopier;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackageVersionAssetsResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListPackageVersionAssetsResponse> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::formatAsString)).setter(ListPackageVersionAssetsResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::namespace)).setter(ListPackageVersionAssetsResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::packageValue)).setter(ListPackageVersionAssetsResponse.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::version)).setter(ListPackageVersionAssetsResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> VERSION_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionRevision").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::versionRevision)).setter(ListPackageVersionAssetsResponse.setter(Builder::versionRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionRevision").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::nextToken)).setter(ListPackageVersionAssetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AssetSummary>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assets").getter(ListPackageVersionAssetsResponse.getter(ListPackageVersionAssetsResponse::assets)).setter(ListPackageVersionAssetsResponse.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSION_FIELD, VERSION_REVISION_FIELD, NEXT_TOKEN_FIELD, ASSETS_FIELD));
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final String version;
    private final String versionRevision;
    private final String nextToken;
    private final List<AssetSummary> assets;

    private ListPackageVersionAssetsResponse(BuilderImpl builder) {
        super(builder);
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.version = builder.version;
        this.versionRevision = builder.versionRevision;
        this.nextToken = builder.nextToken;
        this.assets = builder.assets;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final String version() {
        return this.version;
    }

    public final String versionRevision() {
        return this.versionRevision;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public final List<AssetSummary> assets() {
        return this.assets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionAssetsResponse)) {
            return false;
        }
        ListPackageVersionAssetsResponse other = (ListPackageVersionAssetsResponse)((Object)obj);
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.versionRevision(), other.versionRevision()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets());
    }

    public final String toString() {
        return ToString.builder((String)"ListPackageVersionAssetsResponse").add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("Version", (Object)this.version()).add("VersionRevision", (Object)this.versionRevision()).add("NextToken", (Object)this.nextToken()).add("Assets", this.hasAssets() ? this.assets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "versionRevision": {
                return Optional.ofNullable(clazz.cast(this.versionRevision()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionAssetsResponse, T> g) {
        return obj -> g.apply((ListPackageVersionAssetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private String format;
        private String namespace;
        private String packageValue;
        private String version;
        private String versionRevision;
        private String nextToken;
        private List<AssetSummary> assets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionAssetsResponse model) {
            super(model);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.version(model.version);
            this.versionRevision(model.versionRevision);
            this.nextToken(model.nextToken);
            this.assets(model.assets);
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        @Transient
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        @Transient
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        @Override
        @Transient
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getVersionRevision() {
            return this.versionRevision;
        }

        public final void setVersionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
        }

        @Override
        @Transient
        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = versionRevision;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AssetSummary.Builder> getAssets() {
            List<AssetSummary.Builder> result = AssetSummaryListCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<AssetSummary.BuilderImpl> assets) {
            this.assets = AssetSummaryListCopier.copyFromBuilder(assets);
        }

        @Override
        @Transient
        public final Builder assets(Collection<AssetSummary> assets) {
            this.assets = AssetSummaryListCopier.copy(assets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assets(AssetSummary ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder assets(Consumer<AssetSummary.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (AssetSummary)((AssetSummary.Builder)AssetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPackageVersionAssetsResponse build() {
            return new ListPackageVersionAssetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackageVersionAssetsResponse> {
        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder version(String var1);

        public Builder versionRevision(String var1);

        public Builder nextToken(String var1);

        public Builder assets(Collection<AssetSummary> var1);

        public Builder assets(AssetSummary ... var1);

        public Builder assets(Consumer<AssetSummary.Builder> ... var1);
    }
}

