/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackageVersionResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, DescribePackageVersionResponse> {
    private static final SdkField<PackageVersionDescription> PACKAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("packageVersion").getter(DescribePackageVersionResponse.getter(DescribePackageVersionResponse::packageVersion)).setter(DescribePackageVersionResponse.setter(Builder::packageVersion)).constructor(PackageVersionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_FIELD));
    private final PackageVersionDescription packageVersion;

    private DescribePackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageVersion = builder.packageVersion;
    }

    public final PackageVersionDescription packageVersion() {
        return this.packageVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackageVersionResponse)) {
            return false;
        }
        DescribePackageVersionResponse other = (DescribePackageVersionResponse)((Object)obj);
        return Objects.equals(this.packageVersion(), other.packageVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePackageVersionResponse").add("PackageVersion", (Object)this.packageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageVersion": {
                return Optional.ofNullable(clazz.cast(this.packageVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePackageVersionResponse, T> g) {
        return obj -> g.apply((DescribePackageVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private PackageVersionDescription packageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackageVersionResponse model) {
            super(model);
            this.packageVersion(model.packageVersion);
        }

        public final PackageVersionDescription.Builder getPackageVersion() {
            return this.packageVersion != null ? this.packageVersion.toBuilder() : null;
        }

        public final void setPackageVersion(PackageVersionDescription.BuilderImpl packageVersion) {
            this.packageVersion = packageVersion != null ? packageVersion.build() : null;
        }

        @Override
        @Transient
        public final Builder packageVersion(PackageVersionDescription packageVersion) {
            this.packageVersion = packageVersion;
            return this;
        }

        @Override
        public DescribePackageVersionResponse build() {
            return new DescribePackageVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackageVersionResponse> {
        public Builder packageVersion(PackageVersionDescription var1);

        default public Builder packageVersion(Consumer<PackageVersionDescription.Builder> packageVersion) {
            return this.packageVersion((PackageVersionDescription)((PackageVersionDescription.Builder)PackageVersionDescription.builder().applyMutation(packageVersion)).build());
        }
    }
}

