/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PackageVersionErrorCode {
    ALREADY_EXISTS("ALREADY_EXISTS"),
    MISMATCHED_REVISION("MISMATCHED_REVISION"),
    MISMATCHED_STATUS("MISMATCHED_STATUS"),
    NOT_ALLOWED("NOT_ALLOWED"),
    NOT_FOUND("NOT_FOUND"),
    SKIPPED("SKIPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PackageVersionErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PackageVersionErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionErrorCode> knownValues() {
        return Stream.of(PackageVersionErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

