/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PackageVersionStatus {
    PUBLISHED("Published"),
    UNFINISHED("Unfinished"),
    UNLISTED("Unlisted"),
    ARCHIVED("Archived"),
    DISPOSED("Disposed"),
    DELETED("Deleted"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PackageVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PackageVersionStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionStatus> knownValues() {
        return Stream.of(PackageVersionStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

