/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeartifact.model.DomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DomainDescription.getter(DomainDescription::name)).setter(DomainDescription.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(DomainDescription.getter(DomainDescription::owner)).setter(DomainDescription.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DomainDescription.getter(DomainDescription::arn)).setter(DomainDescription.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DomainDescription.getter(DomainDescription::statusAsString)).setter(DomainDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdTime").getter(DomainDescription.getter(DomainDescription::createdTime)).setter(DomainDescription.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdTime").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(DomainDescription.getter(DomainDescription::encryptionKey)).setter(DomainDescription.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<Integer> REPOSITORY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("repositoryCount").getter(DomainDescription.getter(DomainDescription::repositoryCount)).setter(DomainDescription.setter(Builder::repositoryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCount").build()}).build();
    private static final SdkField<Long> ASSET_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("assetSizeBytes").getter(DomainDescription.getter(DomainDescription::assetSizeBytes)).setter(DomainDescription.setter(Builder::assetSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetSizeBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, OWNER_FIELD, ARN_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, ENCRYPTION_KEY_FIELD, REPOSITORY_COUNT_FIELD, ASSET_SIZE_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String owner;
    private final String arn;
    private final String status;
    private final Instant createdTime;
    private final String encryptionKey;
    private final Integer repositoryCount;
    private final Long assetSizeBytes;

    private DomainDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.owner = builder.owner;
        this.arn = builder.arn;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.encryptionKey = builder.encryptionKey;
        this.repositoryCount = builder.repositoryCount;
        this.assetSizeBytes = builder.assetSizeBytes;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public String arn() {
        return this.arn;
    }

    public DomainStatus status() {
        return DomainStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public String encryptionKey() {
        return this.encryptionKey;
    }

    public Integer repositoryCount() {
        return this.repositoryCount;
    }

    public Long assetSizeBytes() {
        return this.assetSizeBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetSizeBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainDescription)) {
            return false;
        }
        DomainDescription other = (DomainDescription)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.repositoryCount(), other.repositoryCount()) && Objects.equals(this.assetSizeBytes(), other.assetSizeBytes());
    }

    public String toString() {
        return ToString.builder((String)"DomainDescription").add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("CreatedTime", (Object)this.createdTime()).add("EncryptionKey", (Object)this.encryptionKey()).add("RepositoryCount", (Object)this.repositoryCount()).add("AssetSizeBytes", (Object)this.assetSizeBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "repositoryCount": {
                return Optional.ofNullable(clazz.cast(this.repositoryCount()));
            }
            case "assetSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.assetSizeBytes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainDescription, T> g) {
        return obj -> g.apply((DomainDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String owner;
        private String arn;
        private String status;
        private Instant createdTime;
        private String encryptionKey;
        private Integer repositoryCount;
        private Long assetSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainDescription model) {
            this.name(model.name);
            this.owner(model.owner);
            this.arn(model.arn);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.encryptionKey(model.encryptionKey);
            this.repositoryCount(model.repositoryCount);
            this.assetSizeBytes(model.assetSizeBytes);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DomainStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Integer getRepositoryCount() {
            return this.repositoryCount;
        }

        @Override
        public final Builder repositoryCount(Integer repositoryCount) {
            this.repositoryCount = repositoryCount;
            return this;
        }

        public final void setRepositoryCount(Integer repositoryCount) {
            this.repositoryCount = repositoryCount;
        }

        public final Long getAssetSizeBytes() {
            return this.assetSizeBytes;
        }

        @Override
        public final Builder assetSizeBytes(Long assetSizeBytes) {
            this.assetSizeBytes = assetSizeBytes;
            return this;
        }

        public final void setAssetSizeBytes(Long assetSizeBytes) {
            this.assetSizeBytes = assetSizeBytes;
        }

        public DomainDescription build() {
            return new DomainDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainDescription> {
        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(DomainStatus var1);

        public Builder createdTime(Instant var1);

        public Builder encryptionKey(String var1);

        public Builder repositoryCount(Integer var1);

        public Builder assetSizeBytes(Long var1);
    }
}

