/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionError;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionErrorMapCopier;
import software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfo;
import software.amazon.awssdk.services.codeartifact.model.SuccessfulPackageVersionInfoMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisposePackageVersionsResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, DisposePackageVersionsResponse> {
    private static final SdkField<Map<String, SuccessfulPackageVersionInfo>> SUCCESSFUL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("successfulVersions").getter(DisposePackageVersionsResponse.getter(DisposePackageVersionsResponse::successfulVersions)).setter(DisposePackageVersionsResponse.setter(Builder::successfulVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulVersions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulPackageVersionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, PackageVersionError>> FAILED_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("failedVersions").getter(DisposePackageVersionsResponse.getter(DisposePackageVersionsResponse::failedVersions)).setter(DisposePackageVersionsResponse.setter(Builder::failedVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedVersions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageVersionError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_VERSIONS_FIELD, FAILED_VERSIONS_FIELD));
    private final Map<String, SuccessfulPackageVersionInfo> successfulVersions;
    private final Map<String, PackageVersionError> failedVersions;

    private DisposePackageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.successfulVersions = builder.successfulVersions;
        this.failedVersions = builder.failedVersions;
    }

    public boolean hasSuccessfulVersions() {
        return this.successfulVersions != null && !(this.successfulVersions instanceof SdkAutoConstructMap);
    }

    public Map<String, SuccessfulPackageVersionInfo> successfulVersions() {
        return this.successfulVersions;
    }

    public boolean hasFailedVersions() {
        return this.failedVersions != null && !(this.failedVersions instanceof SdkAutoConstructMap);
    }

    public Map<String, PackageVersionError> failedVersions() {
        return this.failedVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.successfulVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisposePackageVersionsResponse)) {
            return false;
        }
        DisposePackageVersionsResponse other = (DisposePackageVersionsResponse)((Object)obj);
        return Objects.equals(this.successfulVersions(), other.successfulVersions()) && Objects.equals(this.failedVersions(), other.failedVersions());
    }

    public String toString() {
        return ToString.builder((String)"DisposePackageVersionsResponse").add("SuccessfulVersions", this.successfulVersions()).add("FailedVersions", this.failedVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulVersions": {
                return Optional.ofNullable(clazz.cast(this.successfulVersions()));
            }
            case "failedVersions": {
                return Optional.ofNullable(clazz.cast(this.failedVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisposePackageVersionsResponse, T> g) {
        return obj -> g.apply((DisposePackageVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private Map<String, SuccessfulPackageVersionInfo> successfulVersions = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, PackageVersionError> failedVersions = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DisposePackageVersionsResponse model) {
            super(model);
            this.successfulVersions(model.successfulVersions);
            this.failedVersions(model.failedVersions);
        }

        public final Map<String, SuccessfulPackageVersionInfo.Builder> getSuccessfulVersions() {
            return this.successfulVersions != null ? CollectionUtils.mapValues(this.successfulVersions, SuccessfulPackageVersionInfo::toBuilder) : null;
        }

        @Override
        public final Builder successfulVersions(Map<String, SuccessfulPackageVersionInfo> successfulVersions) {
            this.successfulVersions = SuccessfulPackageVersionInfoMapCopier.copy(successfulVersions);
            return this;
        }

        public final void setSuccessfulVersions(Map<String, SuccessfulPackageVersionInfo.BuilderImpl> successfulVersions) {
            this.successfulVersions = SuccessfulPackageVersionInfoMapCopier.copyFromBuilder(successfulVersions);
        }

        public final Map<String, PackageVersionError.Builder> getFailedVersions() {
            return this.failedVersions != null ? CollectionUtils.mapValues(this.failedVersions, PackageVersionError::toBuilder) : null;
        }

        @Override
        public final Builder failedVersions(Map<String, PackageVersionError> failedVersions) {
            this.failedVersions = PackageVersionErrorMapCopier.copy(failedVersions);
            return this;
        }

        public final void setFailedVersions(Map<String, PackageVersionError.BuilderImpl> failedVersions) {
            this.failedVersions = PackageVersionErrorMapCopier.copyFromBuilder(failedVersions);
        }

        @Override
        public DisposePackageVersionsResponse build() {
            return new DisposePackageVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisposePackageVersionsResponse> {
        public Builder successfulVersions(Map<String, SuccessfulPackageVersionInfo> var1);

        public Builder failedVersions(Map<String, PackageVersionError> var1);
    }
}

