/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.model.AccessDeniedException;
import software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionRequest;
import software.amazon.awssdk.services.codeartifact.model.AssociateExternalConnectionResponse;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactException;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactRequest;
import software.amazon.awssdk.services.codeartifact.model.ConflictException;
import software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.CopyPackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.CreateDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.CreateDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.CreateRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.CreateRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.DeletePackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.DeleteRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribeDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribeDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribePackageVersionResponse;
import software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.DescribeRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionRequest;
import software.amazon.awssdk.services.codeartifact.model.DisassociateExternalConnectionResponse;
import software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.DisposePackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenRequest;
import software.amazon.awssdk.services.codeartifact.model.GetAuthorizationTokenResponse;
import software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.GetDomainPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetRequest;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionAssetResponse;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeRequest;
import software.amazon.awssdk.services.codeartifact.model.GetPackageVersionReadmeResponse;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointRequest;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryEndpointResponse;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.GetRepositoryPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.InternalServerException;
import software.amazon.awssdk.services.codeartifact.model.ListDomainsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListDomainsResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionDependenciesResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackagesResponse;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesInDomainResponse;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesRequest;
import software.amazon.awssdk.services.codeartifact.model.ListRepositoriesResponse;
import software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.PutDomainPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyRequest;
import software.amazon.awssdk.services.codeartifact.model.PutRepositoryPermissionsPolicyResponse;
import software.amazon.awssdk.services.codeartifact.model.ResourceNotFoundException;
import software.amazon.awssdk.services.codeartifact.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.codeartifact.model.ThrottlingException;
import software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusRequest;
import software.amazon.awssdk.services.codeartifact.model.UpdatePackageVersionsStatusResponse;
import software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryRequest;
import software.amazon.awssdk.services.codeartifact.model.UpdateRepositoryResponse;
import software.amazon.awssdk.services.codeartifact.model.ValidationException;
import software.amazon.awssdk.services.codeartifact.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionAssetsIterable;
import software.amazon.awssdk.services.codeartifact.paginators.ListPackageVersionsIterable;
import software.amazon.awssdk.services.codeartifact.paginators.ListPackagesIterable;
import software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesInDomainIterable;
import software.amazon.awssdk.services.codeartifact.paginators.ListRepositoriesIterable;
import software.amazon.awssdk.services.codeartifact.transform.AssociateExternalConnectionRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.CopyPackageVersionsRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.CreateRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DeleteDomainPermissionsPolicyRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DeletePackageVersionsRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DeleteRepositoryPermissionsPolicyRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DeleteRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DescribePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DescribeRepositoryRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DisassociateExternalConnectionRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.DisposePackageVersionsRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.GetAuthorizationTokenRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.GetDomainPermissionsPolicyRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.GetPackageVersionAssetRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.GetPackageVersionReadmeRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.GetRepositoryEndpointRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.GetRepositoryPermissionsPolicyRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListPackageVersionAssetsRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListPackageVersionDependenciesRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListPackageVersionsRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListPackagesRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListRepositoriesInDomainRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.ListRepositoriesRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.PutDomainPermissionsPolicyRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.PutRepositoryPermissionsPolicyRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.UpdatePackageVersionsStatusRequestMarshaller;
import software.amazon.awssdk.services.codeartifact.transform.UpdateRepositoryRequestMarshaller;

@SdkInternalApi
final class DefaultCodeartifactClient
implements CodeartifactClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCodeartifactClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "codeartifact";
    }

    @Override
    public AssociateExternalConnectionResponse associateExternalConnection(AssociateExternalConnectionRequest associateExternalConnectionRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateExternalConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateExternalConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateExternalConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateExternalConnectionRequest).withMarshaller((Marshaller)new AssociateExternalConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CopyPackageVersionsResponse copyPackageVersions(CopyPackageVersionsRequest copyPackageVersionsRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CopyPackageVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CopyPackageVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CopyPackageVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)copyPackageVersionsRequest).withMarshaller((Marshaller)new CopyPackageVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDomainRequest).withMarshaller((Marshaller)new CreateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest createRepositoryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRepositoryRequest).withMarshaller((Marshaller)new CreateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDomainRequest).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteDomainPermissionsPolicyResponse deleteDomainPermissionsPolicy(DeleteDomainPermissionsPolicyRequest deleteDomainPermissionsPolicyRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainPermissionsPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteDomainPermissionsPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomainPermissionsPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDomainPermissionsPolicyRequest).withMarshaller((Marshaller)new DeleteDomainPermissionsPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeletePackageVersionsResponse deletePackageVersions(DeletePackageVersionsRequest deletePackageVersionsRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePackageVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeletePackageVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePackageVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deletePackageVersionsRequest).withMarshaller((Marshaller)new DeletePackageVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRepositoryRequest).withMarshaller((Marshaller)new DeleteRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteRepositoryPermissionsPolicyResponse deleteRepositoryPermissionsPolicy(DeleteRepositoryPermissionsPolicyRequest deleteRepositoryPermissionsPolicyRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRepositoryPermissionsPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteRepositoryPermissionsPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRepositoryPermissionsPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRepositoryPermissionsPolicyRequest).withMarshaller((Marshaller)new DeleteRepositoryPermissionsPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainRequest).withMarshaller((Marshaller)new DescribeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribePackageVersionResponse describePackageVersion(DescribePackageVersionRequest describePackageVersionRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePackageVersionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribePackageVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePackageVersion").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describePackageVersionRequest).withMarshaller((Marshaller)new DescribePackageVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeRepositoryResponse describeRepository(DescribeRepositoryRequest describeRepositoryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRepositoryRequest).withMarshaller((Marshaller)new DescribeRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateExternalConnectionResponse disassociateExternalConnection(DisassociateExternalConnectionRequest disassociateExternalConnectionRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateExternalConnectionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateExternalConnectionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateExternalConnection").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateExternalConnectionRequest).withMarshaller((Marshaller)new DisassociateExternalConnectionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisposePackageVersionsResponse disposePackageVersions(DisposePackageVersionsRequest disposePackageVersionsRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisposePackageVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisposePackageVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisposePackageVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disposePackageVersionsRequest).withMarshaller((Marshaller)new DisposePackageVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetAuthorizationTokenResponse getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAuthorizationTokenResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetAuthorizationTokenResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAuthorizationToken").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAuthorizationTokenRequest).withMarshaller((Marshaller)new GetAuthorizationTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDomainPermissionsPolicyResponse getDomainPermissionsPolicy(GetDomainPermissionsPolicyRequest getDomainPermissionsPolicyRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainPermissionsPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDomainPermissionsPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainPermissionsPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainPermissionsPolicyRequest).withMarshaller((Marshaller)new GetDomainPermissionsPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public <ReturnT> ReturnT getPackageVersionAsset(GetPackageVersionAssetRequest getPackageVersionAssetRequest, ResponseTransformer<GetPackageVersionAssetResponse, ReturnT> responseTransformer) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPackageVersionAssetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ReturnT)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPackageVersionAsset").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPackageVersionAssetRequest).withMarshaller((Marshaller)new GetPackageVersionAssetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
    }

    @Override
    public GetPackageVersionReadmeResponse getPackageVersionReadme(GetPackageVersionReadmeRequest getPackageVersionReadmeRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPackageVersionReadmeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPackageVersionReadmeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPackageVersionReadme").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPackageVersionReadmeRequest).withMarshaller((Marshaller)new GetPackageVersionReadmeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRepositoryEndpointResponse getRepositoryEndpoint(GetRepositoryEndpointRequest getRepositoryEndpointRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryEndpointResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetRepositoryEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryEndpoint").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRepositoryEndpointRequest).withMarshaller((Marshaller)new GetRepositoryEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetRepositoryPermissionsPolicyResponse getRepositoryPermissionsPolicy(GetRepositoryPermissionsPolicyRequest getRepositoryPermissionsPolicyRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRepositoryPermissionsPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetRepositoryPermissionsPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRepositoryPermissionsPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRepositoryPermissionsPolicyRequest).withMarshaller((Marshaller)new GetRepositoryPermissionsPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainsRequest).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        return new ListDomainsIterable(this, this.applyPaginatorUserAgent(listDomainsRequest));
    }

    @Override
    public ListPackageVersionAssetsResponse listPackageVersionAssets(ListPackageVersionAssetsRequest listPackageVersionAssetsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackageVersionAssetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPackageVersionAssetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackageVersionAssets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackageVersionAssetsRequest).withMarshaller((Marshaller)new ListPackageVersionAssetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPackageVersionAssetsIterable listPackageVersionAssetsPaginator(ListPackageVersionAssetsRequest listPackageVersionAssetsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        return new ListPackageVersionAssetsIterable(this, this.applyPaginatorUserAgent(listPackageVersionAssetsRequest));
    }

    @Override
    public ListPackageVersionDependenciesResponse listPackageVersionDependencies(ListPackageVersionDependenciesRequest listPackageVersionDependenciesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackageVersionDependenciesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPackageVersionDependenciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackageVersionDependencies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackageVersionDependenciesRequest).withMarshaller((Marshaller)new ListPackageVersionDependenciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPackageVersionsResponse listPackageVersions(ListPackageVersionsRequest listPackageVersionsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackageVersionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPackageVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackageVersions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackageVersionsRequest).withMarshaller((Marshaller)new ListPackageVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPackageVersionsIterable listPackageVersionsPaginator(ListPackageVersionsRequest listPackageVersionsRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        return new ListPackageVersionsIterable(this, this.applyPaginatorUserAgent(listPackageVersionsRequest));
    }

    @Override
    public ListPackagesResponse listPackages(ListPackagesRequest listPackagesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPackagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListPackagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPackages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listPackagesRequest).withMarshaller((Marshaller)new ListPackagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListPackagesIterable listPackagesPaginator(ListPackagesRequest listPackagesRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        return new ListPackagesIterable(this, this.applyPaginatorUserAgent(listPackagesRequest));
    }

    @Override
    public ListRepositoriesResponse listRepositories(ListRepositoriesRequest listRepositoriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRepositoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRepositoriesRequest).withMarshaller((Marshaller)new ListRepositoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRepositoriesIterable listRepositoriesPaginator(ListRepositoriesRequest listRepositoriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        return new ListRepositoriesIterable(this, this.applyPaginatorUserAgent(listRepositoriesRequest));
    }

    @Override
    public ListRepositoriesInDomainResponse listRepositoriesInDomain(ListRepositoriesInDomainRequest listRepositoriesInDomainRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRepositoriesInDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListRepositoriesInDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRepositoriesInDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listRepositoriesInDomainRequest).withMarshaller((Marshaller)new ListRepositoriesInDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListRepositoriesInDomainIterable listRepositoriesInDomainPaginator(ListRepositoriesInDomainRequest listRepositoriesInDomainRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        return new ListRepositoriesInDomainIterable(this, this.applyPaginatorUserAgent(listRepositoriesInDomainRequest));
    }

    @Override
    public PutDomainPermissionsPolicyResponse putDomainPermissionsPolicy(PutDomainPermissionsPolicyRequest putDomainPermissionsPolicyRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutDomainPermissionsPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutDomainPermissionsPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDomainPermissionsPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putDomainPermissionsPolicyRequest).withMarshaller((Marshaller)new PutDomainPermissionsPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public PutRepositoryPermissionsPolicyResponse putRepositoryPermissionsPolicy(PutRepositoryPermissionsPolicyRequest putRepositoryPermissionsPolicyRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRepositoryPermissionsPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (PutRepositoryPermissionsPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRepositoryPermissionsPolicy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putRepositoryPermissionsPolicyRequest).withMarshaller((Marshaller)new PutRepositoryPermissionsPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdatePackageVersionsStatusResponse updatePackageVersionsStatus(UpdatePackageVersionsStatusRequest updatePackageVersionsStatusRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePackageVersionsStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdatePackageVersionsStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePackageVersionsStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updatePackageVersionsStatusRequest).withMarshaller((Marshaller)new UpdatePackageVersionsStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateRepositoryResponse updateRepository(UpdateRepositoryRequest updateRepositoryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException, CodeartifactException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRepositoryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateRepositoryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRepository").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateRepositoryRequest).withMarshaller((Marshaller)new UpdateRepositoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CodeartifactException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CodeartifactRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.37").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeartifactRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

