/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEventsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogEventsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetLogEventsResponse> {
    private static final SdkField<List<OutputLogEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLogEventsResponse.getter(GetLogEventsResponse::events)).setter(GetLogEventsResponse.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputLogEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_FORWARD_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLogEventsResponse.getter(GetLogEventsResponse::nextForwardToken)).setter(GetLogEventsResponse.setter(Builder::nextForwardToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextForwardToken").build()}).build();
    private static final SdkField<String> NEXT_BACKWARD_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLogEventsResponse.getter(GetLogEventsResponse::nextBackwardToken)).setter(GetLogEventsResponse.setter(Builder::nextBackwardToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextBackwardToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, NEXT_FORWARD_TOKEN_FIELD, NEXT_BACKWARD_TOKEN_FIELD));
    private final List<OutputLogEvent> events;
    private final String nextForwardToken;
    private final String nextBackwardToken;

    private GetLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.nextForwardToken = builder.nextForwardToken;
        this.nextBackwardToken = builder.nextBackwardToken;
    }

    public List<OutputLogEvent> events() {
        return this.events;
    }

    public String nextForwardToken() {
        return this.nextForwardToken;
    }

    public String nextBackwardToken() {
        return this.nextBackwardToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextForwardToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextBackwardToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResponse)) {
            return false;
        }
        GetLogEventsResponse other = (GetLogEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events()) && Objects.equals(this.nextForwardToken(), other.nextForwardToken()) && Objects.equals(this.nextBackwardToken(), other.nextBackwardToken());
    }

    public String toString() {
        return ToString.builder((String)"GetLogEventsResponse").add("Events", this.events()).add("NextForwardToken", (Object)this.nextForwardToken()).add("NextBackwardToken", (Object)this.nextBackwardToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "nextForwardToken": {
                return Optional.ofNullable(clazz.cast(this.nextForwardToken()));
            }
            case "nextBackwardToken": {
                return Optional.ofNullable(clazz.cast(this.nextBackwardToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLogEventsResponse, T> g) {
        return obj -> g.apply((GetLogEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<OutputLogEvent> events = DefaultSdkAutoConstructList.getInstance();
        private String nextForwardToken;
        private String nextBackwardToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogEventsResponse model) {
            super(model);
            this.events(model.events);
            this.nextForwardToken(model.nextForwardToken);
            this.nextBackwardToken(model.nextBackwardToken);
        }

        public final Collection<OutputLogEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(OutputLogEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<OutputLogEvent> events) {
            this.events = OutputLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(OutputLogEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<OutputLogEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (OutputLogEvent)((OutputLogEvent.Builder)OutputLogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<OutputLogEvent.BuilderImpl> events) {
            this.events = OutputLogEventsCopier.copyFromBuilder(events);
        }

        public final String getNextForwardToken() {
            return this.nextForwardToken;
        }

        @Override
        public final Builder nextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
            return this;
        }

        public final void setNextForwardToken(String nextForwardToken) {
            this.nextForwardToken = nextForwardToken;
        }

        public final String getNextBackwardToken() {
            return this.nextBackwardToken;
        }

        @Override
        public final Builder nextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
            return this;
        }

        public final void setNextBackwardToken(String nextBackwardToken) {
            this.nextBackwardToken = nextBackwardToken;
        }

        @Override
        public GetLogEventsResponse build() {
            return new GetLogEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogEventsResponse> {
        public Builder events(Collection<OutputLogEvent> var1);

        public Builder events(OutputLogEvent ... var1);

        public Builder events(Consumer<OutputLogEvent.Builder> ... var1);

        public Builder nextForwardToken(String var1);

        public Builder nextBackwardToken(String var1);
    }
}

