/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEvent;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilteredLogEventsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.SearchedLogStreamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FilterLogEventsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, FilterLogEventsResponse> {
    private static final SdkField<List<FilteredLogEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FilterLogEventsResponse.getter(FilterLogEventsResponse::events)).setter(FilterLogEventsResponse.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilteredLogEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SearchedLogStream>> SEARCHED_LOG_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(FilterLogEventsResponse.getter(FilterLogEventsResponse::searchedLogStreams)).setter(FilterLogEventsResponse.setter(Builder::searchedLogStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchedLogStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchedLogStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FilterLogEventsResponse.getter(FilterLogEventsResponse::nextToken)).setter(FilterLogEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, SEARCHED_LOG_STREAMS_FIELD, NEXT_TOKEN_FIELD));
    private final List<FilteredLogEvent> events;
    private final List<SearchedLogStream> searchedLogStreams;
    private final String nextToken;

    private FilterLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.searchedLogStreams = builder.searchedLogStreams;
        this.nextToken = builder.nextToken;
    }

    public List<FilteredLogEvent> events() {
        return this.events;
    }

    public List<SearchedLogStream> searchedLogStreams() {
        return this.searchedLogStreams;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.events());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchedLogStreams());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsResponse)) {
            return false;
        }
        FilterLogEventsResponse other = (FilterLogEventsResponse)((Object)obj);
        return Objects.equals(this.events(), other.events()) && Objects.equals(this.searchedLogStreams(), other.searchedLogStreams()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"FilterLogEventsResponse").add("Events", this.events()).add("SearchedLogStreams", this.searchedLogStreams()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "searchedLogStreams": {
                return Optional.ofNullable(clazz.cast(this.searchedLogStreams()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterLogEventsResponse, T> g) {
        return obj -> g.apply((FilterLogEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<FilteredLogEvent> events = DefaultSdkAutoConstructList.getInstance();
        private List<SearchedLogStream> searchedLogStreams = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsResponse model) {
            super(model);
            this.events(model.events);
            this.searchedLogStreams(model.searchedLogStreams);
            this.nextToken(model.nextToken);
        }

        public final Collection<FilteredLogEvent.Builder> getEvents() {
            return this.events != null ? (Collection)this.events.stream().map(FilteredLogEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<FilteredLogEvent> events) {
            this.events = FilteredLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(FilteredLogEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<FilteredLogEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (FilteredLogEvent)((FilteredLogEvent.Builder)FilteredLogEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<FilteredLogEvent.BuilderImpl> events) {
            this.events = FilteredLogEventsCopier.copyFromBuilder(events);
        }

        public final Collection<SearchedLogStream.Builder> getSearchedLogStreams() {
            return this.searchedLogStreams != null ? (Collection)this.searchedLogStreams.stream().map(SearchedLogStream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder searchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copy(searchedLogStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchedLogStreams(SearchedLogStream ... searchedLogStreams) {
            this.searchedLogStreams(Arrays.asList(searchedLogStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchedLogStreams(Consumer<SearchedLogStream.Builder> ... searchedLogStreams) {
            this.searchedLogStreams(Stream.of(searchedLogStreams).map(c -> (SearchedLogStream)((SearchedLogStream.Builder)SearchedLogStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSearchedLogStreams(Collection<SearchedLogStream.BuilderImpl> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copyFromBuilder(searchedLogStreams);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public FilterLogEventsResponse build() {
            return new FilterLogEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, FilterLogEventsResponse> {
        public Builder events(Collection<FilteredLogEvent> var1);

        public Builder events(FilteredLogEvent ... var1);

        public Builder events(Consumer<FilteredLogEvent.Builder> ... var1);

        public Builder searchedLogStreams(Collection<SearchedLogStream> var1);

        public Builder searchedLogStreams(SearchedLogStream ... var1);

        public Builder searchedLogStreams(Consumer<SearchedLogStream.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

