/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestination;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse;

public class DescribeDeliveryDestinationsPublisher
implements SdkPublisher<DescribeDeliveryDestinationsResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final DescribeDeliveryDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDeliveryDestinationsPublisher(CloudWatchLogsAsyncClient client, DescribeDeliveryDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDeliveryDestinationsPublisher(CloudWatchLogsAsyncClient client, DescribeDeliveryDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDeliveryDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDeliveryDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DeliveryDestination> deliveryDestinations() {
        return this.flatMapIterable(response -> response.deliveryDestinations());
    }

    private class DescribeDeliveryDestinationsResponseFetcher
    implements AsyncPageFetcher<DescribeDeliveryDestinationsResponse> {
        private DescribeDeliveryDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDeliveryDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDeliveryDestinationsResponse> nextPage(DescribeDeliveryDestinationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDeliveryDestinationsPublisher.this.client.describeDeliveryDestinations(DescribeDeliveryDestinationsPublisher.this.firstRequest);
            }
            return DescribeDeliveryDestinationsPublisher.this.client.describeDeliveryDestinations((DescribeDeliveryDestinationsRequest)((Object)DescribeDeliveryDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

