/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQuerySummary;

public class ListScheduledQueriesPublisher
implements SdkPublisher<ListScheduledQueriesResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final ListScheduledQueriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScheduledQueriesPublisher(CloudWatchLogsAsyncClient client, ListScheduledQueriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScheduledQueriesPublisher(CloudWatchLogsAsyncClient client, ListScheduledQueriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScheduledQueriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScheduledQueriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledQuerySummary> scheduledQueries() {
        return this.flatMapIterable(response -> response.scheduledQueries());
    }

    private class ListScheduledQueriesResponseFetcher
    implements AsyncPageFetcher<ListScheduledQueriesResponse> {
        private ListScheduledQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledQueriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScheduledQueriesResponse> nextPage(ListScheduledQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledQueriesPublisher.this.client.listScheduledQueries(ListScheduledQueriesPublisher.this.firstRequest);
            }
            return ListScheduledQueriesPublisher.this.client.listScheduledQueries((ListScheduledQueriesRequest)((Object)ListScheduledQueriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

