/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImportTaskBatchesRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeImportTaskBatchesRequest> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(DescribeImportTaskBatchesRequest.getter(DescribeImportTaskBatchesRequest::importId)).setter(DescribeImportTaskBatchesRequest.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<List<String>> BATCH_IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchImportStatus").getter(DescribeImportTaskBatchesRequest.getter(DescribeImportTaskBatchesRequest::batchImportStatusAsStrings)).setter(DescribeImportTaskBatchesRequest.setter(Builder::batchImportStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchImportStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(DescribeImportTaskBatchesRequest.getter(DescribeImportTaskBatchesRequest::limit)).setter(DescribeImportTaskBatchesRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeImportTaskBatchesRequest.getter(DescribeImportTaskBatchesRequest::nextToken)).setter(DescribeImportTaskBatchesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, BATCH_IMPORT_STATUS_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImportTaskBatchesRequest.memberNameToFieldInitializer();
    private final String importId;
    private final List<String> batchImportStatus;
    private final Integer limit;
    private final String nextToken;

    private DescribeImportTaskBatchesRequest(BuilderImpl builder) {
        super(builder);
        this.importId = builder.importId;
        this.batchImportStatus = builder.batchImportStatus;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String importId() {
        return this.importId;
    }

    public final List<ImportStatus> batchImportStatus() {
        return ImportStatusListCopier.copyStringToEnum(this.batchImportStatus);
    }

    public final boolean hasBatchImportStatus() {
        return this.batchImportStatus != null && !(this.batchImportStatus instanceof SdkAutoConstructList);
    }

    public final List<String> batchImportStatusAsStrings() {
        return this.batchImportStatus;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchImportStatus() ? this.batchImportStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImportTaskBatchesRequest)) {
            return false;
        }
        DescribeImportTaskBatchesRequest other = (DescribeImportTaskBatchesRequest)((Object)obj);
        return Objects.equals(this.importId(), other.importId()) && this.hasBatchImportStatus() == other.hasBatchImportStatus() && Objects.equals(this.batchImportStatusAsStrings(), other.batchImportStatusAsStrings()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImportTaskBatchesRequest").add("ImportId", (Object)this.importId()).add("BatchImportStatus", this.hasBatchImportStatus() ? this.batchImportStatusAsStrings() : null).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "batchImportStatus": {
                return Optional.ofNullable(clazz.cast(this.batchImportStatusAsStrings()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("batchImportStatus", BATCH_IMPORT_STATUS_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImportTaskBatchesRequest, T> g) {
        return obj -> g.apply((DescribeImportTaskBatchesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String importId;
        private List<String> batchImportStatus = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImportTaskBatchesRequest model) {
            super(model);
            this.importId(model.importId);
            this.batchImportStatusWithStrings(model.batchImportStatus);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final Collection<String> getBatchImportStatus() {
            if (this.batchImportStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.batchImportStatus;
        }

        public final void setBatchImportStatus(Collection<String> batchImportStatus) {
            this.batchImportStatus = ImportStatusListCopier.copy(batchImportStatus);
        }

        @Override
        public final Builder batchImportStatusWithStrings(Collection<String> batchImportStatus) {
            this.batchImportStatus = ImportStatusListCopier.copy(batchImportStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchImportStatusWithStrings(String ... batchImportStatus) {
            this.batchImportStatusWithStrings(Arrays.asList(batchImportStatus));
            return this;
        }

        @Override
        public final Builder batchImportStatus(Collection<ImportStatus> batchImportStatus) {
            this.batchImportStatus = ImportStatusListCopier.copyEnumToString(batchImportStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchImportStatus(ImportStatus ... batchImportStatus) {
            this.batchImportStatus(Arrays.asList(batchImportStatus));
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeImportTaskBatchesRequest build() {
            return new DescribeImportTaskBatchesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImportTaskBatchesRequest> {
        public Builder importId(String var1);

        public Builder batchImportStatusWithStrings(Collection<String> var1);

        public Builder batchImportStatusWithStrings(String ... var1);

        public Builder batchImportStatus(Collection<ImportStatus> var1);

        public Builder batchImportStatus(ImportStatus ... var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

