/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryDestinationType {
    S3("S3"),
    CWL("CWL"),
    FH("FH"),
    XRAY("XRAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryDestinationType> VALUE_MAP;
    private final String value;

    private DeliveryDestinationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryDestinationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryDestinationType> knownValues() {
        EnumSet<DeliveryDestinationType> knownValues = EnumSet.allOf(DeliveryDestinationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryDestinationType.class, DeliveryDestinationType::toString);
    }
}

