/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsAsyncClient;
import software.amazon.awssdk.services.cloudwatchlogs.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.AggregateLogGroupSummary;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAggregateLogGroupSummariesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAggregateLogGroupSummariesResponse;

public class ListAggregateLogGroupSummariesPublisher
implements SdkPublisher<ListAggregateLogGroupSummariesResponse> {
    private final CloudWatchLogsAsyncClient client;
    private final ListAggregateLogGroupSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAggregateLogGroupSummariesPublisher(CloudWatchLogsAsyncClient client, ListAggregateLogGroupSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAggregateLogGroupSummariesPublisher(CloudWatchLogsAsyncClient client, ListAggregateLogGroupSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAggregateLogGroupSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAggregateLogGroupSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregateLogGroupSummary> aggregateLogGroupSummaries() {
        return this.flatMapIterable(response -> response.aggregateLogGroupSummaries());
    }

    private class ListAggregateLogGroupSummariesResponseFetcher
    implements AsyncPageFetcher<ListAggregateLogGroupSummariesResponse> {
        private ListAggregateLogGroupSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregateLogGroupSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAggregateLogGroupSummariesResponse> nextPage(ListAggregateLogGroupSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListAggregateLogGroupSummariesPublisher.this.client.listAggregateLogGroupSummaries(ListAggregateLogGroupSummariesPublisher.this.firstRequest);
            }
            return ListAggregateLogGroupSummariesPublisher.this.client.listAggregateLogGroupSummaries((ListAggregateLogGroupSummariesRequest)((Object)ListAggregateLogGroupSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

