/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.AnomalyDetectorStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.EvaluationFrequency;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnomalyDetector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnomalyDetector> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorArn").getter(AnomalyDetector.getter(AnomalyDetector::anomalyDetectorArn)).setter(AnomalyDetector.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build()}).build();
    private static final SdkField<String> DETECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorName").getter(AnomalyDetector.getter(AnomalyDetector::detectorName)).setter(AnomalyDetector.setter(Builder::detectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorName").build()}).build();
    private static final SdkField<List<String>> LOG_GROUP_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logGroupArnList").getter(AnomalyDetector.getter(AnomalyDetector::logGroupArnList)).setter(AnomalyDetector.setter(Builder::logGroupArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVALUATION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationFrequency").getter(AnomalyDetector.getter(AnomalyDetector::evaluationFrequencyAsString)).setter(AnomalyDetector.setter(Builder::evaluationFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationFrequency").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(AnomalyDetector.getter(AnomalyDetector::filterPattern)).setter(AnomalyDetector.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<String> ANOMALY_DETECTOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorStatus").getter(AnomalyDetector.getter(AnomalyDetector::anomalyDetectorStatusAsString)).setter(AnomalyDetector.setter(Builder::anomalyDetectorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorStatus").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(AnomalyDetector.getter(AnomalyDetector::kmsKeyId)).setter(AnomalyDetector.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Long> CREATION_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTimeStamp").getter(AnomalyDetector.getter(AnomalyDetector::creationTimeStamp)).setter(AnomalyDetector.setter(Builder::creationTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimeStamp").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTimeStamp").getter(AnomalyDetector.getter(AnomalyDetector::lastModifiedTimeStamp)).setter(AnomalyDetector.setter(Builder::lastModifiedTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTimeStamp").build()}).build();
    private static final SdkField<Long> ANOMALY_VISIBILITY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("anomalyVisibilityTime").getter(AnomalyDetector.getter(AnomalyDetector::anomalyVisibilityTime)).setter(AnomalyDetector.setter(Builder::anomalyVisibilityTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyVisibilityTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, DETECTOR_NAME_FIELD, LOG_GROUP_ARN_LIST_FIELD, EVALUATION_FREQUENCY_FIELD, FILTER_PATTERN_FIELD, ANOMALY_DETECTOR_STATUS_FIELD, KMS_KEY_ID_FIELD, CREATION_TIME_STAMP_FIELD, LAST_MODIFIED_TIME_STAMP_FIELD, ANOMALY_VISIBILITY_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnomalyDetector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String anomalyDetectorArn;
    private final String detectorName;
    private final List<String> logGroupArnList;
    private final String evaluationFrequency;
    private final String filterPattern;
    private final String anomalyDetectorStatus;
    private final String kmsKeyId;
    private final Long creationTimeStamp;
    private final Long lastModifiedTimeStamp;
    private final Long anomalyVisibilityTime;

    private AnomalyDetector(BuilderImpl builder) {
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.detectorName = builder.detectorName;
        this.logGroupArnList = builder.logGroupArnList;
        this.evaluationFrequency = builder.evaluationFrequency;
        this.filterPattern = builder.filterPattern;
        this.anomalyDetectorStatus = builder.anomalyDetectorStatus;
        this.kmsKeyId = builder.kmsKeyId;
        this.creationTimeStamp = builder.creationTimeStamp;
        this.lastModifiedTimeStamp = builder.lastModifiedTimeStamp;
        this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final String detectorName() {
        return this.detectorName;
    }

    public final boolean hasLogGroupArnList() {
        return this.logGroupArnList != null && !(this.logGroupArnList instanceof SdkAutoConstructList);
    }

    public final List<String> logGroupArnList() {
        return this.logGroupArnList;
    }

    public final EvaluationFrequency evaluationFrequency() {
        return EvaluationFrequency.fromValue(this.evaluationFrequency);
    }

    public final String evaluationFrequencyAsString() {
        return this.evaluationFrequency;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final AnomalyDetectorStatus anomalyDetectorStatus() {
        return AnomalyDetectorStatus.fromValue(this.anomalyDetectorStatus);
    }

    public final String anomalyDetectorStatusAsString() {
        return this.anomalyDetectorStatus;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Long creationTimeStamp() {
        return this.creationTimeStamp;
    }

    public final Long lastModifiedTimeStamp() {
        return this.lastModifiedTimeStamp;
    }

    public final Long anomalyVisibilityTime() {
        return this.anomalyVisibilityTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogGroupArnList() ? this.logGroupArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyVisibilityTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetector)) {
            return false;
        }
        AnomalyDetector other = (AnomalyDetector)obj;
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.detectorName(), other.detectorName()) && this.hasLogGroupArnList() == other.hasLogGroupArnList() && Objects.equals(this.logGroupArnList(), other.logGroupArnList()) && Objects.equals(this.evaluationFrequencyAsString(), other.evaluationFrequencyAsString()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.anomalyDetectorStatusAsString(), other.anomalyDetectorStatusAsString()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.creationTimeStamp(), other.creationTimeStamp()) && Objects.equals(this.lastModifiedTimeStamp(), other.lastModifiedTimeStamp()) && Objects.equals(this.anomalyVisibilityTime(), other.anomalyVisibilityTime());
    }

    public final String toString() {
        return ToString.builder((String)"AnomalyDetector").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("DetectorName", (Object)this.detectorName()).add("LogGroupArnList", this.hasLogGroupArnList() ? this.logGroupArnList() : null).add("EvaluationFrequency", (Object)this.evaluationFrequencyAsString()).add("FilterPattern", (Object)this.filterPattern()).add("AnomalyDetectorStatus", (Object)this.anomalyDetectorStatusAsString()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CreationTimeStamp", (Object)this.creationTimeStamp()).add("LastModifiedTimeStamp", (Object)this.lastModifiedTimeStamp()).add("AnomalyVisibilityTime", (Object)this.anomalyVisibilityTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "detectorName": {
                return Optional.ofNullable(clazz.cast(this.detectorName()));
            }
            case "logGroupArnList": {
                return Optional.ofNullable(clazz.cast(this.logGroupArnList()));
            }
            case "evaluationFrequency": {
                return Optional.ofNullable(clazz.cast(this.evaluationFrequencyAsString()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "anomalyDetectorStatus": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorStatusAsString()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "creationTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimeStamp()));
            }
            case "lastModifiedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTimeStamp()));
            }
            case "anomalyVisibilityTime": {
                return Optional.ofNullable(clazz.cast(this.anomalyVisibilityTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("anomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("detectorName", DETECTOR_NAME_FIELD);
        map.put("logGroupArnList", LOG_GROUP_ARN_LIST_FIELD);
        map.put("evaluationFrequency", EVALUATION_FREQUENCY_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("anomalyDetectorStatus", ANOMALY_DETECTOR_STATUS_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("creationTimeStamp", CREATION_TIME_STAMP_FIELD);
        map.put("lastModifiedTimeStamp", LAST_MODIFIED_TIME_STAMP_FIELD);
        map.put("anomalyVisibilityTime", ANOMALY_VISIBILITY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetector, T> g) {
        return obj -> g.apply((AnomalyDetector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String detectorName;
        private List<String> logGroupArnList = DefaultSdkAutoConstructList.getInstance();
        private String evaluationFrequency;
        private String filterPattern;
        private String anomalyDetectorStatus;
        private String kmsKeyId;
        private Long creationTimeStamp;
        private Long lastModifiedTimeStamp;
        private Long anomalyVisibilityTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetector model) {
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.detectorName(model.detectorName);
            this.logGroupArnList(model.logGroupArnList);
            this.evaluationFrequency(model.evaluationFrequency);
            this.filterPattern(model.filterPattern);
            this.anomalyDetectorStatus(model.anomalyDetectorStatus);
            this.kmsKeyId(model.kmsKeyId);
            this.creationTimeStamp(model.creationTimeStamp);
            this.lastModifiedTimeStamp(model.lastModifiedTimeStamp);
            this.anomalyVisibilityTime(model.anomalyVisibilityTime);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getDetectorName() {
            return this.detectorName;
        }

        public final void setDetectorName(String detectorName) {
            this.detectorName = detectorName;
        }

        @Override
        public final Builder detectorName(String detectorName) {
            this.detectorName = detectorName;
            return this;
        }

        public final Collection<String> getLogGroupArnList() {
            if (this.logGroupArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logGroupArnList;
        }

        public final void setLogGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
        }

        @Override
        public final Builder logGroupArnList(Collection<String> logGroupArnList) {
            this.logGroupArnList = LogGroupArnListCopier.copy(logGroupArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logGroupArnList(String ... logGroupArnList) {
            this.logGroupArnList(Arrays.asList(logGroupArnList));
            return this;
        }

        public final String getEvaluationFrequency() {
            return this.evaluationFrequency;
        }

        public final void setEvaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
        }

        @Override
        public final Builder evaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        @Override
        public final Builder evaluationFrequency(EvaluationFrequency evaluationFrequency) {
            this.evaluationFrequency(evaluationFrequency == null ? null : evaluationFrequency.toString());
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final String getAnomalyDetectorStatus() {
            return this.anomalyDetectorStatus;
        }

        public final void setAnomalyDetectorStatus(String anomalyDetectorStatus) {
            this.anomalyDetectorStatus = anomalyDetectorStatus;
        }

        @Override
        public final Builder anomalyDetectorStatus(String anomalyDetectorStatus) {
            this.anomalyDetectorStatus = anomalyDetectorStatus;
            return this;
        }

        @Override
        public final Builder anomalyDetectorStatus(AnomalyDetectorStatus anomalyDetectorStatus) {
            this.anomalyDetectorStatus(anomalyDetectorStatus == null ? null : anomalyDetectorStatus.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Long getCreationTimeStamp() {
            return this.creationTimeStamp;
        }

        public final void setCreationTimeStamp(Long creationTimeStamp) {
            this.creationTimeStamp = creationTimeStamp;
        }

        @Override
        public final Builder creationTimeStamp(Long creationTimeStamp) {
            this.creationTimeStamp = creationTimeStamp;
            return this;
        }

        public final Long getLastModifiedTimeStamp() {
            return this.lastModifiedTimeStamp;
        }

        public final void setLastModifiedTimeStamp(Long lastModifiedTimeStamp) {
            this.lastModifiedTimeStamp = lastModifiedTimeStamp;
        }

        @Override
        public final Builder lastModifiedTimeStamp(Long lastModifiedTimeStamp) {
            this.lastModifiedTimeStamp = lastModifiedTimeStamp;
            return this;
        }

        public final Long getAnomalyVisibilityTime() {
            return this.anomalyVisibilityTime;
        }

        public final void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
        }

        @Override
        public final Builder anomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        public AnomalyDetector build() {
            return new AnomalyDetector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnomalyDetector> {
        public Builder anomalyDetectorArn(String var1);

        public Builder detectorName(String var1);

        public Builder logGroupArnList(Collection<String> var1);

        public Builder logGroupArnList(String ... var1);

        public Builder evaluationFrequency(String var1);

        public Builder evaluationFrequency(EvaluationFrequency var1);

        public Builder filterPattern(String var1);

        public Builder anomalyDetectorStatus(String var1);

        public Builder anomalyDetectorStatus(AnomalyDetectorStatus var1);

        public Builder kmsKeyId(String var1);

        public Builder creationTimeStamp(Long var1);

        public Builder lastModifiedTimeStamp(Long var1);

        public Builder anomalyVisibilityTime(Long var1);
    }
}

