/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogFieldsListCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogFieldsListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogFieldType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogFieldType> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LogFieldType.getter(LogFieldType::type)).setter(LogFieldType.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<LogFieldType> ELEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("element").getter(LogFieldType.getter(LogFieldType::element)).setter(LogFieldType.setter(Builder::element)).constructor(LogFieldType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("element").build()}).build();
    private static final SdkField<List<LogFieldsListItem>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(LogFieldType.getter(LogFieldType::fields)).setter(LogFieldType.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LogFieldsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ELEMENT_FIELD, FIELDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogFieldType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final LogFieldType element;
    private final List<LogFieldsListItem> fields;

    private LogFieldType(BuilderImpl builder) {
        this.type = builder.type;
        this.element = builder.element;
        this.fields = builder.fields;
    }

    public final String type() {
        return this.type;
    }

    public final LogFieldType element() {
        return this.element;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<LogFieldsListItem> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.element());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogFieldType)) {
            return false;
        }
        LogFieldType other = (LogFieldType)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.element(), other.element()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"LogFieldType").add("Type", (Object)this.type()).add("Element", (Object)this.element()).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "element": {
                return Optional.ofNullable(clazz.cast(this.element()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("element", ELEMENT_FIELD);
        map.put("fields", FIELDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogFieldType, T> g) {
        return obj -> g.apply((LogFieldType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private LogFieldType element;
        private List<LogFieldsListItem> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogFieldType model) {
            this.type(model.type);
            this.element(model.element);
            this.fields(model.fields);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Builder getElement() {
            return this.element != null ? this.element.toBuilder() : null;
        }

        public final void setElement(BuilderImpl element) {
            this.element = element != null ? element.build() : null;
        }

        @Override
        public final Builder element(LogFieldType element) {
            this.element = element;
            return this;
        }

        public final List<LogFieldsListItem.Builder> getFields() {
            List<LogFieldsListItem.Builder> result = LogFieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<LogFieldsListItem.BuilderImpl> fields) {
            this.fields = LogFieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<LogFieldsListItem> fields) {
            this.fields = LogFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(LogFieldsListItem ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<LogFieldsListItem.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (LogFieldsListItem)((LogFieldsListItem.Builder)LogFieldsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LogFieldType build() {
            return new LogFieldType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogFieldType> {
        public Builder type(String var1);

        public Builder element(LogFieldType var1);

        default public Builder element(Consumer<Builder> element) {
            return this.element((LogFieldType)((Builder)LogFieldType.builder().applyMutation(element)).build());
        }

        public Builder fields(Collection<LogFieldsListItem> var1);

        public Builder fields(LogFieldsListItem ... var1);

        public Builder fields(Consumer<LogFieldsListItem.Builder> ... var1);
    }
}

