/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.DestinationConfiguration;
import software.amazon.awssdk.services.cloudwatchlogs.model.ExecutionStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQueryState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledQuerySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledQuerySummary> {
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduledQueryArn").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::scheduledQueryArn)).setter(ScheduledQuerySummary.setter(Builder::scheduledQueryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledQueryArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::name)).setter(ScheduledQuerySummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::stateAsString)).setter(ScheduledQuerySummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Long> LAST_TRIGGERED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastTriggeredTime").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::lastTriggeredTime)).setter(ScheduledQuerySummary.setter(Builder::lastTriggeredTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTriggeredTime").build()}).build();
    private static final SdkField<String> LAST_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastExecutionStatus").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::lastExecutionStatusAsString)).setter(ScheduledQuerySummary.setter(Builder::lastExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastExecutionStatus").build()}).build();
    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scheduleExpression").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::scheduleExpression)).setter(ScheduledQuerySummary.setter(Builder::scheduleExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduleExpression").build()}).build();
    private static final SdkField<String> TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timezone").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::timezone)).setter(ScheduledQuerySummary.setter(Builder::timezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfiguration").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::destinationConfiguration)).setter(ScheduledQuerySummary.setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::creationTime)).setter(ScheduledQuerySummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedTime").getter(ScheduledQuerySummary.getter(ScheduledQuerySummary::lastUpdatedTime)).setter(ScheduledQuerySummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_ARN_FIELD, NAME_FIELD, STATE_FIELD, LAST_TRIGGERED_TIME_FIELD, LAST_EXECUTION_STATUS_FIELD, SCHEDULE_EXPRESSION_FIELD, TIMEZONE_FIELD, DESTINATION_CONFIGURATION_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledQuerySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scheduledQueryArn;
    private final String name;
    private final String state;
    private final Long lastTriggeredTime;
    private final String lastExecutionStatus;
    private final String scheduleExpression;
    private final String timezone;
    private final DestinationConfiguration destinationConfiguration;
    private final Long creationTime;
    private final Long lastUpdatedTime;

    private ScheduledQuerySummary(BuilderImpl builder) {
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.name = builder.name;
        this.state = builder.state;
        this.lastTriggeredTime = builder.lastTriggeredTime;
        this.lastExecutionStatus = builder.lastExecutionStatus;
        this.scheduleExpression = builder.scheduleExpression;
        this.timezone = builder.timezone;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final String scheduledQueryArn() {
        return this.scheduledQueryArn;
    }

    public final String name() {
        return this.name;
    }

    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Long lastTriggeredTime() {
        return this.lastTriggeredTime;
    }

    public final ExecutionStatus lastExecutionStatus() {
        return ExecutionStatus.fromValue(this.lastExecutionStatus);
    }

    public final String lastExecutionStatusAsString() {
        return this.lastExecutionStatus;
    }

    public final String scheduleExpression() {
        return this.scheduleExpression;
    }

    public final String timezone() {
        return this.timezone;
    }

    public final DestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTriggeredTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.timezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQuerySummary)) {
            return false;
        }
        ScheduledQuerySummary other = (ScheduledQuerySummary)obj;
        return Objects.equals(this.scheduledQueryArn(), other.scheduledQueryArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.lastTriggeredTime(), other.lastTriggeredTime()) && Objects.equals(this.lastExecutionStatusAsString(), other.lastExecutionStatusAsString()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.timezone(), other.timezone()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledQuerySummary").add("ScheduledQueryArn", (Object)this.scheduledQueryArn()).add("Name", (Object)this.name()).add("State", (Object)this.stateAsString()).add("LastTriggeredTime", (Object)this.lastTriggeredTime()).add("LastExecutionStatus", (Object)this.lastExecutionStatusAsString()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("Timezone", (Object)this.timezone()).add("DestinationConfiguration", (Object)this.destinationConfiguration()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "scheduledQueryArn": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueryArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "lastTriggeredTime": {
                return Optional.ofNullable(clazz.cast(this.lastTriggeredTime()));
            }
            case "lastExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.lastExecutionStatusAsString()));
            }
            case "scheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "timezone": {
                return Optional.ofNullable(clazz.cast(this.timezone()));
            }
            case "destinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scheduledQueryArn", SCHEDULED_QUERY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("state", STATE_FIELD);
        map.put("lastTriggeredTime", LAST_TRIGGERED_TIME_FIELD);
        map.put("lastExecutionStatus", LAST_EXECUTION_STATUS_FIELD);
        map.put("scheduleExpression", SCHEDULE_EXPRESSION_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQuerySummary, T> g) {
        return obj -> g.apply((ScheduledQuerySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scheduledQueryArn;
        private String name;
        private String state;
        private Long lastTriggeredTime;
        private String lastExecutionStatus;
        private String scheduleExpression;
        private String timezone;
        private DestinationConfiguration destinationConfiguration;
        private Long creationTime;
        private Long lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQuerySummary model) {
            this.scheduledQueryArn(model.scheduledQueryArn);
            this.name(model.name);
            this.state(model.state);
            this.lastTriggeredTime(model.lastTriggeredTime);
            this.lastExecutionStatus(model.lastExecutionStatus);
            this.scheduleExpression(model.scheduleExpression);
            this.timezone(model.timezone);
            this.destinationConfiguration(model.destinationConfiguration);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getScheduledQueryArn() {
            return this.scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Long getLastTriggeredTime() {
            return this.lastTriggeredTime;
        }

        public final void setLastTriggeredTime(Long lastTriggeredTime) {
            this.lastTriggeredTime = lastTriggeredTime;
        }

        @Override
        public final Builder lastTriggeredTime(Long lastTriggeredTime) {
            this.lastTriggeredTime = lastTriggeredTime;
            return this;
        }

        public final String getLastExecutionStatus() {
            return this.lastExecutionStatus;
        }

        public final void setLastExecutionStatus(String lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
        }

        @Override
        public final Builder lastExecutionStatus(String lastExecutionStatus) {
            this.lastExecutionStatus = lastExecutionStatus;
            return this;
        }

        @Override
        public final Builder lastExecutionStatus(ExecutionStatus lastExecutionStatus) {
            this.lastExecutionStatus(lastExecutionStatus == null ? null : lastExecutionStatus.toString());
            return this;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public ScheduledQuerySummary build() {
            return new ScheduledQuerySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledQuerySummary> {
        public Builder scheduledQueryArn(String var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(ScheduledQueryState var1);

        public Builder lastTriggeredTime(Long var1);

        public Builder lastExecutionStatus(String var1);

        public Builder lastExecutionStatus(ExecutionStatus var1);

        public Builder scheduleExpression(String var1);

        public Builder timezone(String var1);

        public Builder destinationConfiguration(DestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder creationTime(Long var1);

        public Builder lastUpdatedTime(Long var1);
    }
}

