/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportFilter;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatistics;
import software.amazon.awssdk.services.cloudwatchlogs.model.ImportStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Import
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Import> {
    private static final SdkField<String> IMPORT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importId").getter(Import.getter(Import::importId)).setter(Import.setter(Builder::importId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importId").build()}).build();
    private static final SdkField<String> IMPORT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importSourceArn").getter(Import.getter(Import::importSourceArn)).setter(Import.setter(Builder::importSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importSourceArn").build()}).build();
    private static final SdkField<String> IMPORT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importStatus").getter(Import.getter(Import::importStatusAsString)).setter(Import.setter(Builder::importStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatus").build()}).build();
    private static final SdkField<String> IMPORT_DESTINATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("importDestinationArn").getter(Import.getter(Import::importDestinationArn)).setter(Import.setter(Builder::importDestinationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importDestinationArn").build()}).build();
    private static final SdkField<ImportStatistics> IMPORT_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importStatistics").getter(Import.getter(Import::importStatistics)).setter(Import.setter(Builder::importStatistics)).constructor(ImportStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importStatistics").build()}).build();
    private static final SdkField<ImportFilter> IMPORT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("importFilter").getter(Import.getter(Import::importFilter)).setter(Import.setter(Builder::importFilter)).constructor(ImportFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importFilter").build()}).build();
    private static final SdkField<Long> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("creationTime").getter(Import.getter(Import::creationTime)).setter(Import.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastUpdatedTime").getter(Import.getter(Import::lastUpdatedTime)).setter(Import.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(Import.getter(Import::errorMessage)).setter(Import.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_ID_FIELD, IMPORT_SOURCE_ARN_FIELD, IMPORT_STATUS_FIELD, IMPORT_DESTINATION_ARN_FIELD, IMPORT_STATISTICS_FIELD, IMPORT_FILTER_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, ERROR_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Import.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String importId;
    private final String importSourceArn;
    private final String importStatus;
    private final String importDestinationArn;
    private final ImportStatistics importStatistics;
    private final ImportFilter importFilter;
    private final Long creationTime;
    private final Long lastUpdatedTime;
    private final String errorMessage;

    private Import(BuilderImpl builder) {
        this.importId = builder.importId;
        this.importSourceArn = builder.importSourceArn;
        this.importStatus = builder.importStatus;
        this.importDestinationArn = builder.importDestinationArn;
        this.importStatistics = builder.importStatistics;
        this.importFilter = builder.importFilter;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.errorMessage = builder.errorMessage;
    }

    public final String importId() {
        return this.importId;
    }

    public final String importSourceArn() {
        return this.importSourceArn;
    }

    public final ImportStatus importStatus() {
        return ImportStatus.fromValue(this.importStatus);
    }

    public final String importStatusAsString() {
        return this.importStatus;
    }

    public final String importDestinationArn() {
        return this.importDestinationArn;
    }

    public final ImportStatistics importStatistics() {
        return this.importStatistics;
    }

    public final ImportFilter importFilter() {
        return this.importFilter;
    }

    public final Long creationTime() {
        return this.creationTime;
    }

    public final Long lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.importId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.importDestinationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.importStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.importFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Import)) {
            return false;
        }
        Import other = (Import)obj;
        return Objects.equals(this.importId(), other.importId()) && Objects.equals(this.importSourceArn(), other.importSourceArn()) && Objects.equals(this.importStatusAsString(), other.importStatusAsString()) && Objects.equals(this.importDestinationArn(), other.importDestinationArn()) && Objects.equals(this.importStatistics(), other.importStatistics()) && Objects.equals(this.importFilter(), other.importFilter()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Import").add("ImportId", (Object)this.importId()).add("ImportSourceArn", (Object)this.importSourceArn()).add("ImportStatus", (Object)this.importStatusAsString()).add("ImportDestinationArn", (Object)this.importDestinationArn()).add("ImportStatistics", (Object)this.importStatistics()).add("ImportFilter", (Object)this.importFilter()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "importId": {
                return Optional.ofNullable(clazz.cast(this.importId()));
            }
            case "importSourceArn": {
                return Optional.ofNullable(clazz.cast(this.importSourceArn()));
            }
            case "importStatus": {
                return Optional.ofNullable(clazz.cast(this.importStatusAsString()));
            }
            case "importDestinationArn": {
                return Optional.ofNullable(clazz.cast(this.importDestinationArn()));
            }
            case "importStatistics": {
                return Optional.ofNullable(clazz.cast(this.importStatistics()));
            }
            case "importFilter": {
                return Optional.ofNullable(clazz.cast(this.importFilter()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("importId", IMPORT_ID_FIELD);
        map.put("importSourceArn", IMPORT_SOURCE_ARN_FIELD);
        map.put("importStatus", IMPORT_STATUS_FIELD);
        map.put("importDestinationArn", IMPORT_DESTINATION_ARN_FIELD);
        map.put("importStatistics", IMPORT_STATISTICS_FIELD);
        map.put("importFilter", IMPORT_FILTER_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Import, T> g) {
        return obj -> g.apply((Import)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String importId;
        private String importSourceArn;
        private String importStatus;
        private String importDestinationArn;
        private ImportStatistics importStatistics;
        private ImportFilter importFilter;
        private Long creationTime;
        private Long lastUpdatedTime;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Import model) {
            this.importId(model.importId);
            this.importSourceArn(model.importSourceArn);
            this.importStatus(model.importStatus);
            this.importDestinationArn(model.importDestinationArn);
            this.importStatistics(model.importStatistics);
            this.importFilter(model.importFilter);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.errorMessage(model.errorMessage);
        }

        public final String getImportId() {
            return this.importId;
        }

        public final void setImportId(String importId) {
            this.importId = importId;
        }

        @Override
        public final Builder importId(String importId) {
            this.importId = importId;
            return this;
        }

        public final String getImportSourceArn() {
            return this.importSourceArn;
        }

        public final void setImportSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
        }

        @Override
        public final Builder importSourceArn(String importSourceArn) {
            this.importSourceArn = importSourceArn;
            return this;
        }

        public final String getImportStatus() {
            return this.importStatus;
        }

        public final void setImportStatus(String importStatus) {
            this.importStatus = importStatus;
        }

        @Override
        public final Builder importStatus(String importStatus) {
            this.importStatus = importStatus;
            return this;
        }

        @Override
        public final Builder importStatus(ImportStatus importStatus) {
            this.importStatus(importStatus == null ? null : importStatus.toString());
            return this;
        }

        public final String getImportDestinationArn() {
            return this.importDestinationArn;
        }

        public final void setImportDestinationArn(String importDestinationArn) {
            this.importDestinationArn = importDestinationArn;
        }

        @Override
        public final Builder importDestinationArn(String importDestinationArn) {
            this.importDestinationArn = importDestinationArn;
            return this;
        }

        public final ImportStatistics.Builder getImportStatistics() {
            return this.importStatistics != null ? this.importStatistics.toBuilder() : null;
        }

        public final void setImportStatistics(ImportStatistics.BuilderImpl importStatistics) {
            this.importStatistics = importStatistics != null ? importStatistics.build() : null;
        }

        @Override
        public final Builder importStatistics(ImportStatistics importStatistics) {
            this.importStatistics = importStatistics;
            return this;
        }

        public final ImportFilter.Builder getImportFilter() {
            return this.importFilter != null ? this.importFilter.toBuilder() : null;
        }

        public final void setImportFilter(ImportFilter.BuilderImpl importFilter) {
            this.importFilter = importFilter != null ? importFilter.build() : null;
        }

        @Override
        public final Builder importFilter(ImportFilter importFilter) {
            this.importFilter = importFilter;
            return this;
        }

        public final Long getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Long creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Long getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Long lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Import build() {
            return new Import(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Import> {
        public Builder importId(String var1);

        public Builder importSourceArn(String var1);

        public Builder importStatus(String var1);

        public Builder importStatus(ImportStatus var1);

        public Builder importDestinationArn(String var1);

        public Builder importStatistics(ImportStatistics var1);

        default public Builder importStatistics(Consumer<ImportStatistics.Builder> importStatistics) {
            return this.importStatistics((ImportStatistics)((ImportStatistics.Builder)ImportStatistics.builder().applyMutation(importStatistics)).build());
        }

        public Builder importFilter(ImportFilter var1);

        default public Builder importFilter(Consumer<ImportFilter.Builder> importFilter) {
            return this.importFilter((ImportFilter)((ImportFilter.Builder)ImportFilter.builder().applyMutation(importFilter)).build());
        }

        public Builder creationTime(Long var1);

        public Builder lastUpdatedTime(Long var1);

        public Builder errorMessage(String var1);
    }
}

