/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.MatchPatternsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DateTimeConverter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DateTimeConverter> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(DateTimeConverter.getter(DateTimeConverter::source)).setter(DateTimeConverter.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("target").getter(DateTimeConverter.getter(DateTimeConverter::target)).setter(DateTimeConverter.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> TARGET_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetFormat").getter(DateTimeConverter.getter(DateTimeConverter::targetFormat)).setter(DateTimeConverter.setter(Builder::targetFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFormat").build()}).build();
    private static final SdkField<List<String>> MATCH_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matchPatterns").getter(DateTimeConverter.getter(DateTimeConverter::matchPatterns)).setter(DateTimeConverter.setter(Builder::matchPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceTimezone").getter(DateTimeConverter.getter(DateTimeConverter::sourceTimezone)).setter(DateTimeConverter.setter(Builder::sourceTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTimezone").build()}).build();
    private static final SdkField<String> TARGET_TIMEZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTimezone").getter(DateTimeConverter.getter(DateTimeConverter::targetTimezone)).setter(DateTimeConverter.setter(Builder::targetTimezone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTimezone").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("locale").getter(DateTimeConverter.getter(DateTimeConverter::locale)).setter(DateTimeConverter.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locale").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGET_FIELD, TARGET_FORMAT_FIELD, MATCH_PATTERNS_FIELD, SOURCE_TIMEZONE_FIELD, TARGET_TIMEZONE_FIELD, LOCALE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DateTimeConverter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String source;
    private final String target;
    private final String targetFormat;
    private final List<String> matchPatterns;
    private final String sourceTimezone;
    private final String targetTimezone;
    private final String locale;

    private DateTimeConverter(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.targetFormat = builder.targetFormat;
        this.matchPatterns = builder.matchPatterns;
        this.sourceTimezone = builder.sourceTimezone;
        this.targetTimezone = builder.targetTimezone;
        this.locale = builder.locale;
    }

    public final String source() {
        return this.source;
    }

    public final String target() {
        return this.target;
    }

    public final String targetFormat() {
        return this.targetFormat;
    }

    public final boolean hasMatchPatterns() {
        return this.matchPatterns != null && !(this.matchPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> matchPatterns() {
        return this.matchPatterns;
    }

    public final String sourceTimezone() {
        return this.sourceTimezone;
    }

    public final String targetTimezone() {
        return this.targetTimezone;
    }

    public final String locale() {
        return this.locale;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFormat());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchPatterns() ? this.matchPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateTimeConverter)) {
            return false;
        }
        DateTimeConverter other = (DateTimeConverter)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.targetFormat(), other.targetFormat()) && this.hasMatchPatterns() == other.hasMatchPatterns() && Objects.equals(this.matchPatterns(), other.matchPatterns()) && Objects.equals(this.sourceTimezone(), other.sourceTimezone()) && Objects.equals(this.targetTimezone(), other.targetTimezone()) && Objects.equals(this.locale(), other.locale());
    }

    public final String toString() {
        return ToString.builder((String)"DateTimeConverter").add("Source", (Object)this.source()).add("Target", (Object)this.target()).add("TargetFormat", (Object)this.targetFormat()).add("MatchPatterns", this.hasMatchPatterns() ? this.matchPatterns() : null).add("SourceTimezone", (Object)this.sourceTimezone()).add("TargetTimezone", (Object)this.targetTimezone()).add("Locale", (Object)this.locale()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "targetFormat": {
                return Optional.ofNullable(clazz.cast(this.targetFormat()));
            }
            case "matchPatterns": {
                return Optional.ofNullable(clazz.cast(this.matchPatterns()));
            }
            case "sourceTimezone": {
                return Optional.ofNullable(clazz.cast(this.sourceTimezone()));
            }
            case "targetTimezone": {
                return Optional.ofNullable(clazz.cast(this.targetTimezone()));
            }
            case "locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("source", SOURCE_FIELD);
        map.put("target", TARGET_FIELD);
        map.put("targetFormat", TARGET_FORMAT_FIELD);
        map.put("matchPatterns", MATCH_PATTERNS_FIELD);
        map.put("sourceTimezone", SOURCE_TIMEZONE_FIELD);
        map.put("targetTimezone", TARGET_TIMEZONE_FIELD);
        map.put("locale", LOCALE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateTimeConverter, T> g) {
        return obj -> g.apply((DateTimeConverter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private String target;
        private String targetFormat;
        private List<String> matchPatterns = DefaultSdkAutoConstructList.getInstance();
        private String sourceTimezone;
        private String targetTimezone;
        private String locale;

        private BuilderImpl() {
        }

        private BuilderImpl(DateTimeConverter model) {
            this.source(model.source);
            this.target(model.target);
            this.targetFormat(model.targetFormat);
            this.matchPatterns(model.matchPatterns);
            this.sourceTimezone(model.sourceTimezone);
            this.targetTimezone(model.targetTimezone);
            this.locale(model.locale);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getTargetFormat() {
            return this.targetFormat;
        }

        public final void setTargetFormat(String targetFormat) {
            this.targetFormat = targetFormat;
        }

        @Override
        public final Builder targetFormat(String targetFormat) {
            this.targetFormat = targetFormat;
            return this;
        }

        public final Collection<String> getMatchPatterns() {
            if (this.matchPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchPatterns;
        }

        public final void setMatchPatterns(Collection<String> matchPatterns) {
            this.matchPatterns = MatchPatternsCopier.copy(matchPatterns);
        }

        @Override
        public final Builder matchPatterns(Collection<String> matchPatterns) {
            this.matchPatterns = MatchPatternsCopier.copy(matchPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchPatterns(String ... matchPatterns) {
            this.matchPatterns(Arrays.asList(matchPatterns));
            return this;
        }

        public final String getSourceTimezone() {
            return this.sourceTimezone;
        }

        public final void setSourceTimezone(String sourceTimezone) {
            this.sourceTimezone = sourceTimezone;
        }

        @Override
        public final Builder sourceTimezone(String sourceTimezone) {
            this.sourceTimezone = sourceTimezone;
            return this;
        }

        public final String getTargetTimezone() {
            return this.targetTimezone;
        }

        public final void setTargetTimezone(String targetTimezone) {
            this.targetTimezone = targetTimezone;
        }

        @Override
        public final Builder targetTimezone(String targetTimezone) {
            this.targetTimezone = targetTimezone;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public DateTimeConverter build() {
            return new DateTimeConverter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DateTimeConverter> {
        public Builder source(String var1);

        public Builder target(String var1);

        public Builder targetFormat(String var1);

        public Builder matchPatterns(Collection<String> var1);

        public Builder matchPatterns(String ... var1);

        public Builder sourceTimezone(String var1);

        public Builder targetTimezone(String var1);

        public Builder locale(String var1);
    }
}

