/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudwatchlogs.internal.CloudWatchLogsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudwatchlogs.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.cloudwatchlogs.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.AssociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConflictException;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateExportTaskResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.CreateLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DataAlreadyAcceptedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteAccountPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIndexPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteLogStreamResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeleteTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeAccountPoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeConfigurationTemplatesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliveryDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDeliverySourcesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeDestinationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeFieldIndexesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeIndexPoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeMetricFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueriesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeQueryDefinitionsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeResourcePoliciesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeSubscriptionFiltersResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DisassociateKmsKeyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.FilterLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliveryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogGroupFieldsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogRecordResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.InternalStreamingException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidOperationException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudwatchlogs.model.InvalidSequenceTokenException;
import software.amazon.awssdk.services.cloudwatchlogs.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListAnomaliesResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListIntegrationsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListIntegrationsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsForQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.ListTagsLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.MalformedQueryException;
import software.amazon.awssdk.services.cloudwatchlogs.model.OperationAbortedException;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutAccountPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDataProtectionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliveryDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDeliverySourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutDestinationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIndexPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIntegrationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutIntegrationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutQueryDefinitionResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutRetentionPolicyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutSubscriptionFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.PutTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudwatchlogs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.cloudwatchlogs.model.SessionStreamingException;
import software.amazon.awssdk.services.cloudwatchlogs.model.SessionTimeoutException;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.StopQueryResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestMetricFilterResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.TestTransformerResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ThrottlingException;
import software.amazon.awssdk.services.cloudwatchlogs.model.TooManyTagsException;
import software.amazon.awssdk.services.cloudwatchlogs.model.UnrecognizedClientException;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagLogGroupResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateAnomalyResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateDeliveryConfigurationResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.UpdateLogAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ValidationException;
import software.amazon.awssdk.services.cloudwatchlogs.transform.AssociateKmsKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CancelExportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateDeliveryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateExportTaskRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.CreateLogStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteAccountPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDataProtectionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliveryDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliveryDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliveryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDeliverySourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteIndexPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteLogStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteQueryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteSubscriptionFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DeleteTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeAccountPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDeliveriesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDeliveryDestinationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDeliverySourcesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeDestinationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeExportTasksRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeFieldIndexesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeIndexPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeLogGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeLogStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeMetricFiltersRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeQueryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeResourcePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DescribeSubscriptionFiltersRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.DisassociateKmsKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.FilterLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDataProtectionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliveryDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliveryDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliveryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetDeliverySourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogGroupFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetLogRecordRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.GetTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListAnomaliesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListIntegrationsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListLogAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListLogGroupsForQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListLogGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.ListTagsLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutAccountPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDataProtectionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDeliveryDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDeliveryDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDeliverySourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDestinationPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutDestinationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutIndexPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutIntegrationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutLogEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutQueryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutRetentionPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutSubscriptionFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.PutTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.StopQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TagLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TestMetricFilterRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.TestTransformerRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UntagLogGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateAnomalyRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateDeliveryConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudwatchlogs.transform.UpdateLogAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CloudWatchLogsClient}.
 *
 * @see CloudWatchLogsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudWatchLogsClient implements CloudWatchLogsClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudWatchLogsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudWatchLogsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "CloudWatch_Logs" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates the specified KMS key with either one log group in the account, or with all stored CloudWatch Logs
     * query insights results in the account.
     * </p>
     * <p>
     * When you use <code>AssociateKmsKey</code>, you specify either the <code>logGroupName</code> parameter or the
     * <code>resourceIdentifier</code> parameter. You can't specify both of those parameters in the same operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>logGroupName</code> parameter to cause log events ingested into that log group to be encrypted
     * with that key. Only the log events ingested after the key is associated are encrypted with that key.
     * </p>
     * <p>
     * Associating a KMS key with a log group overrides any existing associations between the log group and a KMS key.
     * After a KMS key is associated with a log group, all newly ingested data for the log group is encrypted using the
     * KMS key. This association is stored as long as the data encrypted with the KMS key is still within CloudWatch
     * Logs. This enables CloudWatch Logs to decrypt this data whenever it is requested.
     * </p>
     * <p>
     * Associating a key with a log group does not cause the results of queries of that log group to be encrypted with
     * that key. To have query results encrypted with a KMS key, you must use an <code>AssociateKmsKey</code> operation
     * with the <code>resourceIdentifier</code> parameter that specifies a <code>query-result</code> resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the <code>resourceIdentifier</code> parameter with a <code>query-result</code> resource, to use that key
     * to encrypt the stored results of all future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in the account. The response from a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html"
     * >GetQueryResults</a> operation will still return the query results in plain text.
     * </p>
     * <p>
     * Even if you have not associated a key with your query results, the query results are encrypted when stored, using
     * the default CloudWatch Logs method.
     * </p>
     * <p>
     * If you run a query from a monitoring account that queries logs in a source account, the query results key from
     * the monitoring account, if any, is used.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If you delete the key that is used to encrypt log events or log group query results, then all the associated
     * stored log events or query results that were encrypted with that key will be unencryptable and unusable.
     * </p>
     * </important> <note>
     * <p>
     * CloudWatch Logs supports only symmetric KMS keys. Do not associate an asymmetric KMS key with your log group or
     * query results. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and
     * Asymmetric Keys</a>.
     * </p>
     * </note>
     * <p>
     * It can take up to 5 minutes for this operation to take effect.
     * </p>
     * <p>
     * If you attempt to associate a KMS key with a log group but the KMS key does not exist or the KMS key is disabled,
     * you receive an <code>InvalidParameterException</code> error.
     * </p>
     *
     * @param associateKmsKeyRequest
     * @return Result of the AssociateKmsKey operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.AssociateKmsKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/AssociateKmsKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateKmsKeyResponse associateKmsKey(AssociateKmsKeyRequest associateKmsKeyRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateKmsKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateKmsKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateKmsKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateKmsKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateKmsKey");

            return clientHandler.execute(new ClientExecutionParams<AssociateKmsKeyRequest, AssociateKmsKeyResponse>()
                    .withOperationName("AssociateKmsKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateKmsKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateKmsKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the specified export task.
     * </p>
     * <p>
     * The task must be in the <code>PENDING</code> or <code>RUNNING</code> state.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelExportTaskResponse cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest)
            throws InvalidParameterException, ResourceNotFoundException, InvalidOperationException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelExportTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelExportTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelExportTask");

            return clientHandler.execute(new ClientExecutionParams<CancelExportTaskRequest, CancelExportTaskResponse>()
                    .withOperationName("CancelExportTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelExportTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelExportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <i>delivery</i>. A delivery is a connection between a logical <i>delivery source</i> and a logical
     * <i>delivery destination</i> that you have already created.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source using this operation. These
     * services are listed as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * A delivery destination can represent a log group in CloudWatch Logs, an Amazon S3 bucket, a delivery stream in
     * Firehose, or X-Ray.
     * </p>
     * <p>
     * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery destination</i>, which is a logical object that represents the actual delivery destination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * To update an existing delivery configuration, use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UpdateDeliveryConfiguration.html"
     * >UpdateDeliveryConfiguration</a>.
     * </p>
     *
     * @param createDeliveryRequest
     * @return Result of the CreateDelivery operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.CreateDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDeliveryResponse createDelivery(CreateDeliveryRequest createDeliveryRequest) throws ServiceUnavailableException,
            ConflictException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDeliveryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDeliveryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDeliveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeliveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDelivery");

            return clientHandler.execute(new ClientExecutionParams<CreateDeliveryRequest, CreateDeliveryResponse>()
                    .withOperationName("CreateDelivery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDeliveryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDeliveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an export task so that you can efficiently export data from a log group to an Amazon S3 bucket. When you
     * perform a <code>CreateExportTask</code> operation, you must use credentials that have permission to write to the
     * S3 bucket that you specify as the destination.
     * </p>
     * <p>
     * Exporting log data to S3 buckets that are encrypted by KMS is supported. Exporting log data to Amazon S3 buckets
     * that have S3 Object Lock enabled with a retention period is also supported.
     * </p>
     * <p>
     * Exporting to S3 buckets that are encrypted with AES-256 is supported.
     * </p>
     * <p>
     * This is an asynchronous call. If all the required information is provided, this operation initiates an export
     * task and responds with the ID of the task. After the task has started, you can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html"
     * >DescribeExportTasks</a> to get the status of the export task. Each account can only have one active (
     * <code>RUNNING</code> or <code>PENDING</code>) export task at a time. To cancel an export task, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html"
     * >CancelExportTask</a>.
     * </p>
     * <p>
     * You can export logs from multiple log groups or multiple time ranges to the same S3 bucket. To separate log data
     * for each export task, specify a prefix to be used as the Amazon S3 key prefix for all exported objects.
     * </p>
     * <note>
     * <p>
     * We recommend that you don't regularly export to Amazon S3 as a way to continuously archive your logs. For that
     * use case, we instead recommend that you use subscriptions. For more information about subscriptions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Subscriptions.html">Real-time processing of log
     * data with subscriptions</a>.
     * </p>
     * </note> <note>
     * <p>
     * Time-based sorting on chunks of log data inside an exported file is not guaranteed. You can sort the exported log
     * field data by using Linux utilities.
     * </p>
     * </note>
     *
     * @param createExportTaskRequest
     * @return Result of the CreateExportTask operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.CreateExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateExportTaskResponse createExportTask(CreateExportTaskRequest createExportTaskRequest)
            throws InvalidParameterException, LimitExceededException, OperationAbortedException, ServiceUnavailableException,
            ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateExportTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateExportTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createExportTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createExportTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateExportTask");

            return clientHandler.execute(new ClientExecutionParams<CreateExportTaskRequest, CreateExportTaskResponse>()
                    .withOperationName("CreateExportTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createExportTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateExportTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an <i>anomaly detector</i> that regularly scans one or more log groups and look for patterns and
     * anomalies in the logs.
     * </p>
     * <p>
     * An anomaly detector can help surface issues by automatically discovering anomalies in your log event traffic. An
     * anomaly detector uses machine learning algorithms to scan log events and find <i>patterns</i>. A pattern is a
     * shared text structure that recurs among your log fields. Patterns provide a useful tool for analyzing large sets
     * of logs because a large number of log events can often be compressed into a few patterns.
     * </p>
     * <p>
     * The anomaly detector uses pattern recognition to find <code>anomalies</code>, which are unusual log events. It
     * uses the <code>evaluationFrequency</code> to compare current log events and patterns with trained baselines.
     * </p>
     * <p>
     * Fields within a pattern are called <i>tokens</i>. Fields that vary within a pattern, such as a request ID or
     * timestamp, are referred to as <i>dynamic tokens</i> and represented by <code>&lt;*&gt;</code>.
     * </p>
     * <p>
     * The following is an example of a pattern:
     * </p>
     * <p>
     * <code>[INFO] Request time: &lt;*&gt; ms</code>
     * </p>
     * <p>
     * This pattern represents log events like <code>[INFO] Request time: 327 ms</code> and other similar log events
     * that differ only by the number, in this csse 327. When the pattern is displayed, the different numbers are
     * replaced by <code>&lt;*&gt;</code>
     * </p>
     * <note>
     * <p>
     * Any parts of log events that are masked as sensitive data are not scanned for anomalies. For more information
     * about masking sensitive data, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Help protect
     * sensitive log data with masking</a>.
     * </p>
     * </note>
     *
     * @param createLogAnomalyDetectorRequest
     * @return Result of the CreateLogAnomalyDetector operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.CreateLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateLogAnomalyDetectorResponse createLogAnomalyDetector(
            CreateLogAnomalyDetectorRequest createLogAnomalyDetectorRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException, LimitExceededException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLogAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLogAnomalyDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLogAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateLogAnomalyDetectorRequest, CreateLogAnomalyDetectorResponse>()
                            .withOperationName("CreateLogAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createLogAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateLogAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a log group with the specified name. You can create up to 1,000,000 log groups per Region per account.
     * </p>
     * <p>
     * You must use the following guidelines when naming a log group:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Log group names must be unique within a Region for an Amazon Web Services account.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names can be between 1 and 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names consist of the following characters: a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen), '/' (forward
     * slash), '.' (period), and '#' (number sign)
     * </p>
     * </li>
     * <li>
     * <p>
     * Log group names can't start with the string <code>aws/</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you create a log group, by default the log events in the log group do not expire. To set a retention policy
     * so that events expire and are deleted after a specified time, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutRetentionPolicy.html"
     * >PutRetentionPolicy</a>.
     * </p>
     * <p>
     * If you associate an KMS key with the log group, ingested data is encrypted using the KMS key. This association is
     * stored as long as the data encrypted with the KMS key is still within CloudWatch Logs. This enables CloudWatch
     * Logs to decrypt this data whenever it is requested.
     * </p>
     * <p>
     * If you attempt to associate a KMS key with the log group but the KMS key does not exist or the KMS key is
     * disabled, you receive an <code>InvalidParameterException</code> error.
     * </p>
     * <important>
     * <p>
     * CloudWatch Logs supports only symmetric KMS keys. Do not associate an asymmetric KMS key with your log group. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using Symmetric and
     * Asymmetric Keys</a>.
     * </p>
     * </important>
     *
     * @param createLogGroupRequest
     * @return Result of the CreateLogGroup operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.CreateLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLogGroupResponse createLogGroup(CreateLogGroupRequest createLogGroupRequest) throws InvalidParameterException,
            ResourceAlreadyExistsException, LimitExceededException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLogGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateLogGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLogGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateLogGroupRequest, CreateLogGroupResponse>()
                    .withOperationName("CreateLogGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLogGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLogGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a log stream for the specified log group. A log stream is a sequence of log events that originate from a
     * single source, such as an application instance or a resource that is being monitored.
     * </p>
     * <p>
     * There is no limit on the number of log streams that you can create for a log group. There is a limit of 50 TPS on
     * <code>CreateLogStream</code> operations, after which transactions are throttled.
     * </p>
     * <p>
     * You must use the following guidelines when naming a log stream:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Log stream names must be unique within the log group.
     * </p>
     * </li>
     * <li>
     * <p>
     * Log stream names can be between 1 and 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Don't use ':' (colon) or '*' (asterisk) characters.
     * </p>
     * </li>
     * </ul>
     *
     * @param createLogStreamRequest
     * @return Result of the CreateLogStream operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.CreateLogStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/CreateLogStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLogStreamResponse createLogStream(CreateLogStreamRequest createLogStreamRequest)
            throws InvalidParameterException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLogStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateLogStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLogStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogStream");

            return clientHandler.execute(new ClientExecutionParams<CreateLogStreamRequest, CreateLogStreamResponse>()
                    .withOperationName("CreateLogStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLogStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLogStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a CloudWatch Logs account policy. This stops the account-wide policy from applying to log groups in the
     * account. If you delete a data protection policy or subscription filter policy, any log-group level policies of
     * those types remain in effect.
     * </p>
     * <p>
     * To use this operation, you must be signed on with the correct permissions depending on the type of policy that
     * you are deleting.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To delete a data protection policy, you must have the <code>logs:DeleteDataProtectionPolicy</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a subscription filter policy, you must have the <code>logs:DeleteSubscriptionFilter</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a transformer policy, you must have the <code>logs:DeleteTransformer</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a field index policy, you must have the <code>logs:DeleteIndexPolicy</code> and
     * <code>logs:DeleteAccountPolicy</code> permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you delete a field index policy, the indexing of the log events that happened before you deleted the policy
     * will still be used for up to 30 days to improve CloudWatch Logs Insights queries.
     * </p>
     *
     * @param deleteAccountPolicyRequest
     * @return Result of the DeleteAccountPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteAccountPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteAccountPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAccountPolicyResponse deleteAccountPolicy(DeleteAccountPolicyRequest deleteAccountPolicyRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteAccountPolicyRequest, DeleteAccountPolicyResponse>()
                    .withOperationName("DeleteAccountPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAccountPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAccountPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the data protection policy from the specified log group.
     * </p>
     * <p>
     * For more information about data protection policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html"
     * >PutDataProtectionPolicy</a>.
     * </p>
     *
     * @param deleteDataProtectionPolicyRequest
     * @return Result of the DeleteDataProtectionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDataProtectionPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDataProtectionPolicyResponse deleteDataProtectionPolicy(
            DeleteDataProtectionPolicyRequest deleteDataProtectionPolicyRequest) throws InvalidParameterException,
            OperationAbortedException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataProtectionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDataProtectionPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataProtectionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataProtectionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataProtectionPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDataProtectionPolicyRequest, DeleteDataProtectionPolicyResponse>()
                            .withOperationName("DeleteDataProtectionPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDataProtectionPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDataProtectionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <i>delivery</i>. A delivery is a connection between a logical <i>delivery source</i> and a logical
     * <i>delivery destination</i>. Deleting a delivery only deletes the connection between the delivery source and
     * delivery destination. It does not delete the delivery destination or the delivery source.
     * </p>
     *
     * @param deleteDeliveryRequest
     * @return Result of the DeleteDelivery operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDeliveryResponse deleteDelivery(DeleteDeliveryRequest deleteDeliveryRequest) throws ResourceNotFoundException,
            ServiceUnavailableException, ConflictException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeliveryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDeliveryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeliveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeliveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDelivery");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeliveryRequest, DeleteDeliveryResponse>()
                    .withOperationName("DeleteDelivery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDeliveryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeliveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <i>delivery destination</i>. A delivery is a connection between a logical <i>delivery source</i> and a
     * logical <i>delivery destination</i>.
     * </p>
     * <p>
     * You can't delete a delivery destination if any current deliveries are associated with it. To find whether any
     * deliveries are associated with this delivery destination, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation and check the <code>deliveryDestinationArn</code> field in the results.
     * </p>
     *
     * @param deleteDeliveryDestinationRequest
     * @return Result of the DeleteDeliveryDestination operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliveryDestination"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeliveryDestinationResponse deleteDeliveryDestination(
            DeleteDeliveryDestinationRequest deleteDeliveryDestinationRequest) throws ResourceNotFoundException,
            ServiceUnavailableException, ConflictException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeliveryDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeliveryDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeliveryDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeliveryDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeliveryDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDeliveryDestinationRequest, DeleteDeliveryDestinationResponse>()
                            .withOperationName("DeleteDeliveryDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDeliveryDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDeliveryDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a delivery destination policy. For more information about these policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a>.
     * </p>
     *
     * @param deleteDeliveryDestinationPolicyRequest
     * @return Result of the DeleteDeliveryDestinationPolicy operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteDeliveryDestinationPolicyResponse deleteDeliveryDestinationPolicy(
            DeleteDeliveryDestinationPolicyRequest deleteDeliveryDestinationPolicyRequest) throws ServiceUnavailableException,
            ValidationException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeliveryDestinationPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeliveryDestinationPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeliveryDestinationPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteDeliveryDestinationPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeliveryDestinationPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDeliveryDestinationPolicyRequest, DeleteDeliveryDestinationPolicyResponse>()
                            .withOperationName("DeleteDeliveryDestinationPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDeliveryDestinationPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDeliveryDestinationPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <i>delivery source</i>. A delivery is a connection between a logical <i>delivery source</i> and a
     * logical <i>delivery destination</i>.
     * </p>
     * <p>
     * You can't delete a delivery source if any current deliveries are associated with it. To find whether any
     * deliveries are associated with this delivery source, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation and check the <code>deliverySourceName</code> field in the results.
     * </p>
     *
     * @param deleteDeliverySourceRequest
     * @return Result of the DeleteDeliverySource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDeliverySourceResponse deleteDeliverySource(DeleteDeliverySourceRequest deleteDeliverySourceRequest)
            throws ResourceNotFoundException, ServiceUnavailableException, ConflictException, ValidationException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDeliverySourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDeliverySourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeliverySourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeliverySourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeliverySource");

            return clientHandler.execute(new ClientExecutionParams<DeleteDeliverySourceRequest, DeleteDeliverySourceResponse>()
                    .withOperationName("DeleteDeliverySource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDeliverySourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDeliverySourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified destination, and eventually disables all the subscription filters that publish to it. This
     * operation does not delete the physical resource encapsulated by the destination.
     * </p>
     *
     * @param deleteDestinationRequest
     * @return Result of the DeleteDestination operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteDestination" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDestinationResponse deleteDestination(DeleteDestinationRequest deleteDestinationRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDestination");

            return clientHandler.execute(new ClientExecutionParams<DeleteDestinationRequest, DeleteDestinationResponse>()
                    .withOperationName("DeleteDestination").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a log-group level field index policy that was applied to a single log group. The indexing of the log
     * events that happened before you delete the policy will still be used for as many as 30 days to improve CloudWatch
     * Logs Insights queries.
     * </p>
     * <p>
     * You can't use this operation to delete an account-level index policy. Instead, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DeleteAccountPolicy.html"
     * >DeletAccountPolicy</a>.
     * </p>
     * <p>
     * If you delete a log-group level field index policy and there is an account-level field index policy, in a few
     * minutes the log group begins using that account-wide policy to index new incoming log events.
     * </p>
     *
     * @param deleteIndexPolicyRequest
     * @return Result of the DeleteIndexPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteIndexPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteIndexPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIndexPolicyResponse deleteIndexPolicy(DeleteIndexPolicyRequest deleteIndexPolicyRequest)
            throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, OperationAbortedException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIndexPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIndexPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIndexPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIndexPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIndexPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteIndexPolicyRequest, DeleteIndexPolicyResponse>()
                    .withOperationName("DeleteIndexPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIndexPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIndexPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the integration between CloudWatch Logs and OpenSearch Service. If your integration has active vended
     * logs dashboards, you must specify <code>true</code> for the <code>force</code> parameter, otherwise the operation
     * will fail. If you delete the integration by setting <code>force</code> to <code>true</code>, all your vended logs
     * dashboards powered by OpenSearch Service will be deleted and the data that was on them will no longer be
     * accessible.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, ValidationException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIntegrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIntegrationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIntegration");

            return clientHandler.execute(new ClientExecutionParams<DeleteIntegrationRequest, DeleteIntegrationResponse>()
                    .withOperationName("DeleteIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified CloudWatch Logs anomaly detector.
     * </p>
     *
     * @param deleteLogAnomalyDetectorRequest
     * @return Result of the DeleteLogAnomalyDetector operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteLogAnomalyDetectorResponse deleteLogAnomalyDetector(
            DeleteLogAnomalyDetectorRequest deleteLogAnomalyDetectorRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLogAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLogAnomalyDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLogAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLogAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLogAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLogAnomalyDetectorRequest, DeleteLogAnomalyDetectorResponse>()
                            .withOperationName("DeleteLogAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteLogAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLogAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified log group and permanently deletes all the archived log events associated with the log
     * group.
     * </p>
     *
     * @param deleteLogGroupRequest
     * @return Result of the DeleteLogGroup operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLogGroupResponse deleteLogGroup(DeleteLogGroupRequest deleteLogGroupRequest) throws InvalidParameterException,
            ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLogGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteLogGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLogGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLogGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteLogGroupRequest, DeleteLogGroupResponse>()
                    .withOperationName("DeleteLogGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLogGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLogGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified log stream and permanently deletes all the archived log events associated with the log
     * stream.
     * </p>
     *
     * @param deleteLogStreamRequest
     * @return Result of the DeleteLogStream operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteLogStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteLogStream" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLogStreamResponse deleteLogStream(DeleteLogStreamRequest deleteLogStreamRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLogStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteLogStreamResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLogStreamRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLogStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLogStream");

            return clientHandler.execute(new ClientExecutionParams<DeleteLogStreamRequest, DeleteLogStreamResponse>()
                    .withOperationName("DeleteLogStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLogStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLogStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified metric filter.
     * </p>
     *
     * @param deleteMetricFilterRequest
     * @return Result of the DeleteMetricFilter operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteMetricFilterResponse deleteMetricFilter(DeleteMetricFilterRequest deleteMetricFilterRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMetricFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMetricFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMetricFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMetricFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMetricFilter");

            return clientHandler.execute(new ClientExecutionParams<DeleteMetricFilterRequest, DeleteMetricFilterResponse>()
                    .withOperationName("DeleteMetricFilter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteMetricFilterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteMetricFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a saved CloudWatch Logs Insights query definition. A query definition contains details about a saved
     * CloudWatch Logs Insights query.
     * </p>
     * <p>
     * Each <code>DeleteQueryDefinition</code> operation can delete one query definition.
     * </p>
     * <p>
     * You must have the <code>logs:DeleteQueryDefinition</code> permission to be able to perform this operation.
     * </p>
     *
     * @param deleteQueryDefinitionRequest
     * @return Result of the DeleteQueryDefinition operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteQueryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteQueryDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteQueryDefinitionResponse deleteQueryDefinition(DeleteQueryDefinitionRequest deleteQueryDefinitionRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteQueryDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteQueryDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteQueryDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteQueryDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteQueryDefinition");

            return clientHandler.execute(new ClientExecutionParams<DeleteQueryDefinitionRequest, DeleteQueryDefinitionResponse>()
                    .withOperationName("DeleteQueryDefinition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteQueryDefinitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteQueryDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resource policy from this account. This revokes the access of the identities in that policy to put log
     * events to this account.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteResourcePolicyRequest, DeleteResourcePolicyResponse>()
                    .withOperationName("DeleteResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified retention policy.
     * </p>
     * <p>
     * Log events do not expire if they belong to log groups without a retention policy.
     * </p>
     *
     * @param deleteRetentionPolicyRequest
     * @return Result of the DeleteRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteRetentionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteRetentionPolicyResponse deleteRetentionPolicy(DeleteRetentionPolicyRequest deleteRetentionPolicyRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRetentionPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRetentionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetentionPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteRetentionPolicyRequest, DeleteRetentionPolicyResponse>()
                    .withOperationName("DeleteRetentionPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRetentionPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRetentionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified subscription filter.
     * </p>
     *
     * @param deleteSubscriptionFilterRequest
     * @return Result of the DeleteSubscriptionFilter operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteSubscriptionFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteSubscriptionFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSubscriptionFilterResponse deleteSubscriptionFilter(
            DeleteSubscriptionFilterRequest deleteSubscriptionFilterRequest) throws InvalidParameterException,
            ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSubscriptionFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSubscriptionFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSubscriptionFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubscriptionFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubscriptionFilter");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSubscriptionFilterRequest, DeleteSubscriptionFilterResponse>()
                            .withOperationName("DeleteSubscriptionFilter").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSubscriptionFilterRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSubscriptionFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the log transformer for the specified log group. As soon as you do this, the transformation of incoming
     * log events according to that transformer stops. If this account has an account-level transformer that applies to
     * this log group, the log group begins using that account-level transformer when this log-group level transformer
     * is deleted.
     * </p>
     * <p>
     * After you delete a transformer, be sure to edit any metric filters or subscription filters that relied on the
     * transformed versions of the log events.
     * </p>
     *
     * @param deleteTransformerRequest
     * @return Result of the DeleteTransformer operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DeleteTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DeleteTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTransformerResponse deleteTransformer(DeleteTransformerRequest deleteTransformerRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException,
            InvalidOperationException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTransformerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTransformerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTransformerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTransformerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTransformer");

            return clientHandler.execute(new ClientExecutionParams<DeleteTransformerRequest, DeleteTransformerResponse>()
                    .withOperationName("DeleteTransformer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTransformerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTransformerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all CloudWatch Logs account policies in the account.
     * </p>
     * <p>
     * To use this operation, you must be signed on with the correct permissions depending on the type of policy that
     * you are retrieving information for.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To see data protection policies, you must have the <code>logs:GetDataProtectionPolicy</code> and
     * <code>logs:DescribeAccountPolicies</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To see subscription filter policies, you must have the <code>logs:DescribeSubscriptionFilters</code> and
     * <code>logs:DescribeAccountPolicies</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To see transformer policies, you must have the <code>logs:GetTransformer</code> and
     * <code>logs:DescribeAccountPolicies</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To see field index policies, you must have the <code>logs:DescribeIndexPolicies</code> and
     * <code>logs:DescribeAccountPolicies</code> permissions.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountPoliciesRequest
     * @return Result of the DescribeAccountPolicies operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeAccountPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeAccountPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAccountPoliciesResponse describeAccountPolicies(DescribeAccountPoliciesRequest describeAccountPoliciesRequest)
            throws InvalidParameterException, OperationAbortedException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountPoliciesRequest, DescribeAccountPoliciesResponse>()
                            .withOperationName("DescribeAccountPolicies").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to return the valid and default values that are used when creating delivery sources, delivery
     * destinations, and deliveries. For more information about deliveries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     *
     * @param describeConfigurationTemplatesRequest
     * @return Result of the DescribeConfigurationTemplates operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConfigurationTemplatesResponse describeConfigurationTemplates(
            DescribeConfigurationTemplatesRequest describeConfigurationTemplatesRequest) throws ServiceUnavailableException,
            ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConfigurationTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConfigurationTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigurationTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationTemplatesRequest, DescribeConfigurationTemplatesResponse>()
                            .withOperationName("DescribeConfigurationTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeConfigurationTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConfigurationTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the deliveries that have been created in the account.
     * </p>
     * <p>
     * A <i>delivery</i> is a connection between a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html">
     * <i>delivery source</i> </a> and a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html">
     * <i>delivery destination</i> </a>.
     * </p>
     * <p>
     * A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The
     * destination can be CloudWatch Logs, Amazon S3, Firehose or X-Ray. Only some Amazon Web Services services support
     * being configured as a delivery source. These services are listed in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>
     * </p>
     *
     * @param describeDeliveriesRequest
     * @return Result of the DescribeDeliveries operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeDeliveries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDeliveriesResponse describeDeliveries(DescribeDeliveriesRequest describeDeliveriesRequest)
            throws ServiceUnavailableException, ServiceQuotaExceededException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeliveriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDeliveriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeliveriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeliveriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveries");

            return clientHandler.execute(new ClientExecutionParams<DescribeDeliveriesRequest, DescribeDeliveriesResponse>()
                    .withOperationName("DescribeDeliveries").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDeliveriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDeliveriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the delivery destinations that have been created in the account.
     * </p>
     *
     * @param describeDeliveryDestinationsRequest
     * @return Result of the DescribeDeliveryDestinations operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeDeliveryDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliveryDestinations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDeliveryDestinationsResponse describeDeliveryDestinations(
            DescribeDeliveryDestinationsRequest describeDeliveryDestinationsRequest) throws ServiceUnavailableException,
            ServiceQuotaExceededException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeliveryDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDeliveryDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeliveryDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeliveryDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryDestinations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryDestinationsRequest, DescribeDeliveryDestinationsResponse>()
                            .withOperationName("DescribeDeliveryDestinations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDeliveryDestinationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDeliveryDestinationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the delivery sources that have been created in the account.
     * </p>
     *
     * @param describeDeliverySourcesRequest
     * @return Result of the DescribeDeliverySources operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeDeliverySources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDeliverySources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDeliverySourcesResponse describeDeliverySources(DescribeDeliverySourcesRequest describeDeliverySourcesRequest)
            throws ServiceUnavailableException, ServiceQuotaExceededException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDeliverySourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDeliverySourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeliverySourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeliverySourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliverySources");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliverySourcesRequest, DescribeDeliverySourcesResponse>()
                            .withOperationName("DescribeDeliverySources").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDeliverySourcesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDeliverySourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all your destinations. The results are ASCII-sorted by destination name.
     * </p>
     *
     * @param describeDestinationsRequest
     * @return Result of the DescribeDestinations operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeDestinations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeDestinations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDestinationsResponse describeDestinations(DescribeDestinationsRequest describeDestinationsRequest)
            throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDestinations");

            return clientHandler.execute(new ClientExecutionParams<DescribeDestinationsRequest, DescribeDestinationsResponse>()
                    .withOperationName("DescribeDestinations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDestinationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDestinationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the specified export tasks. You can list all your export tasks or filter the results based on task ID or
     * task status.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeExportTasksResponse describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest)
            throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeExportTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeExportTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeExportTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeExportTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeExportTasks");

            return clientHandler.execute(new ClientExecutionParams<DescribeExportTasksRequest, DescribeExportTasksResponse>()
                    .withOperationName("DescribeExportTasks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeExportTasksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeExportTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of custom and default field indexes which are discovered in log data. For more information about
     * field index policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a>.
     * </p>
     *
     * @param describeFieldIndexesRequest
     * @return Result of the DescribeFieldIndexes operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeFieldIndexes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeFieldIndexes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeFieldIndexesResponse describeFieldIndexes(DescribeFieldIndexesRequest describeFieldIndexesRequest)
            throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, OperationAbortedException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFieldIndexesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFieldIndexesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFieldIndexesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFieldIndexesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFieldIndexes");

            return clientHandler.execute(new ClientExecutionParams<DescribeFieldIndexesRequest, DescribeFieldIndexesResponse>()
                    .withOperationName("DescribeFieldIndexes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFieldIndexesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFieldIndexesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the field index policies of the specified log group. For more information about field index policies, see
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html">
     * PutIndexPolicy</a>.
     * </p>
     * <p>
     * If a specified log group has a log-group level index policy, that policy is returned by this operation.
     * </p>
     * <p>
     * If a specified log group doesn't have a log-group level index policy, but an account-wide index policy applies to
     * it, that account-wide policy is returned by this operation.
     * </p>
     * <p>
     * To find information about only account-level policies, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html"
     * >DescribeAccountPolicies</a> instead.
     * </p>
     *
     * @param describeIndexPoliciesRequest
     * @return Result of the DescribeIndexPolicies operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeIndexPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeIndexPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeIndexPoliciesResponse describeIndexPolicies(DescribeIndexPoliciesRequest describeIndexPoliciesRequest)
            throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, OperationAbortedException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIndexPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeIndexPoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIndexPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIndexPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIndexPolicies");

            return clientHandler.execute(new ClientExecutionParams<DescribeIndexPoliciesRequest, DescribeIndexPoliciesResponse>()
                    .withOperationName("DescribeIndexPolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeIndexPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIndexPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about log groups. You can return all your log groups or filter the results by prefix. The
     * results are ASCII-sorted by log group name.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that control access to the <code>DescribeLogGroups</code> action by
     * using the <code>aws:ResourceTag/<i>key-name</i> </code> condition key. Other CloudWatch Logs actions do support
     * the use of the <code>aws:ResourceTag/<i>key-name</i> </code> condition key to control access. For more
     * information about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param describeLogGroupsRequest
     * @return Result of the DescribeLogGroups operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeLogGroupsResponse describeLogGroups(DescribeLogGroupsRequest describeLogGroupsRequest)
            throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLogGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeLogGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLogGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLogGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLogGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeLogGroupsRequest, DescribeLogGroupsResponse>()
                    .withOperationName("DescribeLogGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeLogGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLogGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the log streams for the specified log group. You can list all the log streams or filter the results by
     * prefix. You can also control how the results are ordered.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <p>
     * This operation has a limit of 25 transactions per second, after which transactions are throttled.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param describeLogStreamsRequest
     * @return Result of the DescribeLogStreams operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeLogStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeLogStreams" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeLogStreamsResponse describeLogStreams(DescribeLogStreamsRequest describeLogStreamsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLogStreamsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeLogStreamsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLogStreamsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLogStreamsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLogStreams");

            return clientHandler.execute(new ClientExecutionParams<DescribeLogStreamsRequest, DescribeLogStreamsResponse>()
                    .withOperationName("DescribeLogStreams").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeLogStreamsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLogStreamsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the specified metric filters. You can list all of the metric filters or filter the results by log name,
     * prefix, metric name, or metric namespace. The results are ASCII-sorted by filter name.
     * </p>
     *
     * @param describeMetricFiltersRequest
     * @return Result of the DescribeMetricFilters operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeMetricFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeMetricFilters" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeMetricFiltersResponse describeMetricFilters(DescribeMetricFiltersRequest describeMetricFiltersRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMetricFiltersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMetricFiltersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMetricFiltersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMetricFiltersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMetricFilters");

            return clientHandler.execute(new ClientExecutionParams<DescribeMetricFiltersRequest, DescribeMetricFiltersResponse>()
                    .withOperationName("DescribeMetricFilters").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeMetricFiltersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeMetricFiltersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of CloudWatch Logs Insights queries that are scheduled, running, or have been run recently in this
     * account. You can request all queries or limit it to queries of a specific log group or queries with a certain
     * status.
     * </p>
     *
     * @param describeQueriesRequest
     * @return Result of the DescribeQueries operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeQueriesResponse describeQueries(DescribeQueriesRequest describeQueriesRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeQueriesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeQueriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQueriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeQueriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQueries");

            return clientHandler.execute(new ClientExecutionParams<DescribeQueriesRequest, DescribeQueriesResponse>()
                    .withOperationName("DescribeQueries").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeQueriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeQueriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This operation returns a paginated list of your saved CloudWatch Logs Insights query definitions. You can
     * retrieve query definitions from the current account or from a source account that is linked to the current
     * account.
     * </p>
     * <p>
     * You can use the <code>queryDefinitionNamePrefix</code> parameter to limit the results to only the query
     * definitions that have names that start with a certain string.
     * </p>
     *
     * @param describeQueryDefinitionsRequest
     * @return Result of the DescribeQueryDefinitions operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeQueryDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeQueryDefinitions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeQueryDefinitionsResponse describeQueryDefinitions(
            DescribeQueryDefinitionsRequest describeQueryDefinitionsRequest) throws InvalidParameterException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeQueryDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeQueryDefinitionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeQueryDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeQueryDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeQueryDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeQueryDefinitionsRequest, DescribeQueryDefinitionsResponse>()
                            .withOperationName("DescribeQueryDefinitions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeQueryDefinitionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeQueryDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resource policies in this account.
     * </p>
     *
     * @param describeResourcePoliciesRequest
     * @return Result of the DescribeResourcePolicies operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeResourcePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeResourcePoliciesResponse describeResourcePolicies(
            DescribeResourcePoliciesRequest describeResourcePoliciesRequest) throws InvalidParameterException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeResourcePoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeResourcePoliciesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeResourcePoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeResourcePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeResourcePolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeResourcePoliciesRequest, DescribeResourcePoliciesResponse>()
                            .withOperationName("DescribeResourcePolicies").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeResourcePoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeResourcePoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the subscription filters for the specified log group. You can list all the subscription filters or filter
     * the results by prefix. The results are ASCII-sorted by filter name.
     * </p>
     *
     * @param describeSubscriptionFiltersRequest
     * @return Result of the DescribeSubscriptionFilters operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DescribeSubscriptionFilters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DescribeSubscriptionFilters"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSubscriptionFiltersResponse describeSubscriptionFilters(
            DescribeSubscriptionFiltersRequest describeSubscriptionFiltersRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSubscriptionFiltersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSubscriptionFiltersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSubscriptionFiltersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSubscriptionFiltersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSubscriptionFilters");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSubscriptionFiltersRequest, DescribeSubscriptionFiltersResponse>()
                            .withOperationName("DescribeSubscriptionFilters").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSubscriptionFiltersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSubscriptionFiltersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified KMS key from the specified log group or from all CloudWatch Logs Insights query
     * results in the account.
     * </p>
     * <p>
     * When you use <code>DisassociateKmsKey</code>, you specify either the <code>logGroupName</code> parameter or the
     * <code>resourceIdentifier</code> parameter. You can't specify both of those parameters in the same operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>logGroupName</code> parameter to stop using the KMS key to encrypt future log events ingested
     * and stored in the log group. Instead, they will be encrypted with the default CloudWatch Logs method. The log
     * events that were ingested while the key was associated with the log group are still encrypted with that key.
     * Therefore, CloudWatch Logs will need permissions for the key whenever that data is accessed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Specify the <code>resourceIdentifier</code> parameter with the <code>query-result</code> resource to stop using
     * the KMS key to encrypt the results of all future <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * operations in the account. They will instead be encrypted with the default CloudWatch Logs method. The results
     * from queries that ran while the key was associated with the account are still encrypted with that key. Therefore,
     * CloudWatch Logs will need permissions for the key whenever that data is accessed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * It can take up to 5 minutes for this operation to take effect.
     * </p>
     *
     * @param disassociateKmsKeyRequest
     * @return Result of the DisassociateKmsKey operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.DisassociateKmsKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/DisassociateKmsKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisassociateKmsKeyResponse disassociateKmsKey(DisassociateKmsKeyRequest disassociateKmsKeyRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateKmsKeyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateKmsKeyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateKmsKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateKmsKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateKmsKey");

            return clientHandler.execute(new ClientExecutionParams<DisassociateKmsKeyRequest, DisassociateKmsKeyResponse>()
                    .withOperationName("DisassociateKmsKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disassociateKmsKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateKmsKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists log events from the specified log group. You can list all the log events or filter the results using one or
     * more of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A filter pattern
     * </p>
     * </li>
     * <li>
     * <p>
     * A time range
     * </p>
     * </li>
     * <li>
     * <p>
     * The log stream name, or a log stream name prefix that matches multiple log streams
     * </p>
     * </li>
     * </ul>
     * <p>
     * You must have the <code>logs:FilterLogEvents</code> permission to perform this operation.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <p>
     * <code>FilterLogEvents</code> is a paginated operation. Each page returned can contain up to 1 MB of log events or
     * up to 10,000 log events. A returned page might only be partially full, or even empty. For example, if the result
     * of a query would return 15,000 log events, the first page isn't guaranteed to have 10,000 log events even if they
     * all fit into 1 MB.
     * </p>
     * <p>
     * Partially full or empty pages don't necessarily mean that pagination is finished. If the results include a
     * <code>nextToken</code>, there might be more log events available. You can return these additional log events by
     * providing the nextToken in a subsequent <code>FilterLogEvents</code> operation. If the results don't include a
     * <code>nextToken</code>, then pagination is finished.
     * </p>
     * <p>
     * Specifying the <code>limit</code> parameter only guarantees that a single page doesn't return more log events
     * than the specified limit, but it might return fewer events than the limit. This is the expected API behavior.
     * </p>
     * <p>
     * The returned log events are sorted by event timestamp, the timestamp when the event was ingested by CloudWatch
     * Logs, and the ID of the <code>PutLogEvents</code> request.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <note>
     * <p>
     * If you are using <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html">log
     * transformation</a>, the <code>FilterLogEvents</code> operation returns only the original versions of log events,
     * before they were transformed. To view the transformed versions, you must use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">CloudWatch Logs query.</a>
     * </p>
     * </note>
     *
     * @param filterLogEventsRequest
     * @return Result of the FilterLogEvents operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.FilterLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/FilterLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FilterLogEventsResponse filterLogEvents(FilterLogEventsRequest filterLogEventsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FilterLogEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                FilterLogEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(filterLogEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, filterLogEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FilterLogEvents");

            return clientHandler.execute(new ClientExecutionParams<FilterLogEventsRequest, FilterLogEventsResponse>()
                    .withOperationName("FilterLogEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(filterLogEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FilterLogEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a log group data protection policy.
     * </p>
     *
     * @param getDataProtectionPolicyRequest
     * @return Result of the GetDataProtectionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDataProtectionPolicyResponse getDataProtectionPolicy(GetDataProtectionPolicyRequest getDataProtectionPolicyRequest)
            throws InvalidParameterException, OperationAbortedException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataProtectionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDataProtectionPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataProtectionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataProtectionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataProtectionPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDataProtectionPolicyRequest, GetDataProtectionPolicyResponse>()
                            .withOperationName("GetDataProtectionPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDataProtectionPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDataProtectionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns complete information about one logical <i>delivery</i>. A delivery is a connection between a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html">
     * <i>delivery source</i> </a> and a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html">
     * <i>delivery destination</i> </a>.
     * </p>
     * <p>
     * A delivery source represents an Amazon Web Services resource that sends logs to an logs delivery destination. The
     * destination can be CloudWatch Logs, Amazon S3, or Firehose. Only some Amazon Web Services services support being
     * configured as a delivery source. These services are listed in <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enable logging
     * from Amazon Web Services services.</a>
     * </p>
     * <p>
     * You need to specify the delivery <code>id</code> in this operation. You can find the IDs of the deliveries in
     * your account with the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeDeliveries.html"
     * >DescribeDeliveries</a> operation.
     * </p>
     *
     * @param getDeliveryRequest
     * @return Result of the GetDelivery operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetDelivery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDelivery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeliveryResponse getDelivery(GetDeliveryRequest getDeliveryRequest) throws ResourceNotFoundException,
            ServiceUnavailableException, ValidationException, ServiceQuotaExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeliveryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeliveryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeliveryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeliveryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDelivery");

            return clientHandler.execute(new ClientExecutionParams<GetDeliveryRequest, GetDeliveryResponse>()
                    .withOperationName("GetDelivery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getDeliveryRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeliveryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves complete information about one delivery destination.
     * </p>
     *
     * @param getDeliveryDestinationRequest
     * @return Result of the GetDeliveryDestination operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliveryDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDeliveryDestinationResponse getDeliveryDestination(GetDeliveryDestinationRequest getDeliveryDestinationRequest)
            throws ResourceNotFoundException, ServiceUnavailableException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeliveryDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeliveryDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeliveryDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeliveryDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeliveryDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDeliveryDestinationRequest, GetDeliveryDestinationResponse>()
                            .withOperationName("GetDeliveryDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDeliveryDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDeliveryDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the delivery destination policy assigned to the delivery destination that you specify. For more
     * information about delivery destinations and their policies, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a>.
     * </p>
     *
     * @param getDeliveryDestinationPolicyRequest
     * @return Result of the GetDeliveryDestinationPolicy operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeliveryDestinationPolicyResponse getDeliveryDestinationPolicy(
            GetDeliveryDestinationPolicyRequest getDeliveryDestinationPolicyRequest) throws ServiceUnavailableException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeliveryDestinationPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDeliveryDestinationPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeliveryDestinationPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeliveryDestinationPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeliveryDestinationPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDeliveryDestinationPolicyRequest, GetDeliveryDestinationPolicyResponse>()
                            .withOperationName("GetDeliveryDestinationPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDeliveryDestinationPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDeliveryDestinationPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves complete information about one delivery source.
     * </p>
     *
     * @param getDeliverySourceRequest
     * @return Result of the GetDeliverySource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDeliverySourceResponse getDeliverySource(GetDeliverySourceRequest getDeliverySourceRequest)
            throws ResourceNotFoundException, ServiceUnavailableException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeliverySourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDeliverySourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDeliverySourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeliverySourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeliverySource");

            return clientHandler.execute(new ClientExecutionParams<GetDeliverySourceRequest, GetDeliverySourceResponse>()
                    .withOperationName("GetDeliverySource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDeliverySourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDeliverySourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about one integration between CloudWatch Logs and OpenSearch Service.
     * </p>
     *
     * @param getIntegrationRequest
     * @return Result of the GetIntegration operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws InvalidParameterException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetIntegrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntegration");

            return clientHandler.execute(new ClientExecutionParams<GetIntegrationRequest, GetIntegrationResponse>()
                    .withOperationName("GetIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the log anomaly detector that you specify. The KMS key ARN detected is valid.
     * </p>
     *
     * @param getLogAnomalyDetectorRequest
     * @return Result of the GetLogAnomalyDetector operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLogAnomalyDetectorResponse getLogAnomalyDetector(GetLogAnomalyDetectorRequest getLogAnomalyDetectorRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLogAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLogAnomalyDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogAnomalyDetector");

            return clientHandler.execute(new ClientExecutionParams<GetLogAnomalyDetectorRequest, GetLogAnomalyDetectorResponse>()
                    .withOperationName("GetLogAnomalyDetector").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLogAnomalyDetectorRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLogAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists log events from the specified log stream. You can list all of the log events or filter using a time range.
     * </p>
     * <p>
     * <code>GetLogEvents</code> is a paginated operation. Each page returned can contain up to 1 MB of log events or up
     * to 10,000 log events. A returned page might only be partially full, or even empty. For example, if the result of
     * a query would return 15,000 log events, the first page isn't guaranteed to have 10,000 log events even if they
     * all fit into 1 MB.
     * </p>
     * <p>
     * Partially full or empty pages don't necessarily mean that pagination is finished. As long as the
     * <code>nextBackwardToken</code> or <code>nextForwardToken</code> returned is NOT equal to the
     * <code>nextToken</code> that you passed into the API call, there might be more log events available. The token
     * that you use depends on the direction you want to move in along the log stream. The returned tokens are never
     * null.
     * </p>
     * <note>
     * <p>
     * If you set <code>startFromHead</code> to <code>true</code> and you don’t include <code>endTime</code> in your
     * request, you can end up in a situation where the pagination doesn't terminate. This can happen when the new log
     * events are being added to the target log streams faster than they are being read. This situation is a good use
     * case for the CloudWatch Logs <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs_LiveTail.html">Live Tail</a>
     * feature.
     * </p>
     * </note>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must include one of these two parameters, but you can't include both.
     * </p>
     * <note>
     * <p>
     * If you are using <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html">log
     * transformation</a>, the <code>GetLogEvents</code> operation returns only the original versions of log events,
     * before they were transformed. To view the transformed versions, you must use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">CloudWatch Logs query.</a>
     * </p>
     * </note>
     *
     * @param getLogEventsRequest
     * @return Result of the GetLogEvents operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLogEventsResponse getLogEvents(GetLogEventsRequest getLogEventsRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLogEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLogEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogEvents");

            return clientHandler.execute(new ClientExecutionParams<GetLogEventsRequest, GetLogEventsResponse>()
                    .withOperationName("GetLogEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLogEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLogEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the fields that are included in log events in the specified log group. Includes the percentage
     * of log events that contain each field. The search is limited to a time period that you specify.
     * </p>
     * <p>
     * You can specify the log group to search by using either <code>logGroupIdentifier</code> or
     * <code>logGroupName</code>. You must specify one of these parameters, but you can't specify both.
     * </p>
     * <p>
     * In the results, fields that start with <code>@</code> are fields generated by CloudWatch Logs. For example,
     * <code>@timestamp</code> is the timestamp of each log event. For more information about the fields that are
     * generated by CloudWatch logs, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html"
     * >Supported Logs and Discovered Fields</a>.
     * </p>
     * <p>
     * The response results are sorted by the frequency percentage, starting with the highest percentage.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account and
     * view data from the linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param getLogGroupFieldsRequest
     * @return Result of the GetLogGroupFields operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetLogGroupFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogGroupFields" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLogGroupFieldsResponse getLogGroupFields(GetLogGroupFieldsRequest getLogGroupFieldsRequest)
            throws InvalidParameterException, LimitExceededException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLogGroupFieldsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLogGroupFieldsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogGroupFieldsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogGroupFieldsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogGroupFields");

            return clientHandler.execute(new ClientExecutionParams<GetLogGroupFieldsRequest, GetLogGroupFieldsResponse>()
                    .withOperationName("GetLogGroupFields").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLogGroupFieldsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLogGroupFieldsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all of the fields and values of a single log event. All fields are retrieved, even if the original
     * query that produced the <code>logRecordPointer</code> retrieved only a subset of fields. Fields are returned as
     * field name/field value pairs.
     * </p>
     * <p>
     * The full unparsed log event is returned within <code>@message</code>.
     * </p>
     *
     * @param getLogRecordRequest
     * @return Result of the GetLogRecord operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetLogRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetLogRecord" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLogRecordResponse getLogRecord(GetLogRecordRequest getLogRecordRequest) throws InvalidParameterException,
            LimitExceededException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLogRecordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLogRecordResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLogRecordRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLogRecordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLogRecord");

            return clientHandler.execute(new ClientExecutionParams<GetLogRecordRequest, GetLogRecordResponse>()
                    .withOperationName("GetLogRecord").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLogRecordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLogRecordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the results from the specified query.
     * </p>
     * <p>
     * Only the fields requested in the query are returned, along with a <code>@ptr</code> field, which is the
     * identifier for the log record. You can use the value of <code>@ptr</code> in a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogRecord.html"
     * >GetLogRecord</a> operation to get the full log record.
     * </p>
     * <p>
     * <code>GetQueryResults</code> does not start running a query. To run a query, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>.
     * For more information about how long results of previous queries are available, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/cloudwatch_limits_cwl.html">CloudWatch Logs
     * quotas</a>.
     * </p>
     * <p>
     * If the value of the <code>Status</code> field in the output is <code>Running</code>, this operation returns only
     * partial results. If you see a value of <code>Scheduled</code> or <code>Running</code> for the status, you can
     * retry the operation later to see the final results.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account to
     * start queries in linked source accounts. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>.
     * </p>
     *
     * @param getQueryResultsRequest
     * @return Result of the GetQueryResults operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetQueryResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetQueryResults" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetQueryResultsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetQueryResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getQueryResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getQueryResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetQueryResults");

            return clientHandler.execute(new ClientExecutionParams<GetQueryResultsRequest, GetQueryResultsResponse>()
                    .withOperationName("GetQueryResults").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getQueryResultsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetQueryResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the information about the log transformer associated with this log group.
     * </p>
     * <p>
     * This operation returns data only for transformers created at the log group level. To get information for an
     * account-level transformer, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeAccountPolicies.html"
     * >DescribeAccountPolicies</a>.
     * </p>
     *
     * @param getTransformerRequest
     * @return Result of the GetTransformer operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.GetTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/GetTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTransformerResponse getTransformer(GetTransformerRequest getTransformerRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, InvalidOperationException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTransformerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTransformerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTransformerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTransformerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTransformer");

            return clientHandler.execute(new ClientExecutionParams<GetTransformerRequest, GetTransformerResponse>()
                    .withOperationName("GetTransformer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTransformerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTransformerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of anomalies that log anomaly detectors have found. For details about the structure format of each
     * anomaly object that is returned, see the example in this section.
     * </p>
     *
     * @param listAnomaliesRequest
     * @return Result of the ListAnomalies operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListAnomalies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListAnomalies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAnomaliesResponse listAnomalies(ListAnomaliesRequest listAnomaliesRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnomaliesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAnomaliesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnomaliesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnomaliesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnomalies");

            return clientHandler.execute(new ClientExecutionParams<ListAnomaliesRequest, ListAnomaliesResponse>()
                    .withOperationName("ListAnomalies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAnomaliesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAnomaliesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of integrations between CloudWatch Logs and other services in this account. Currently, only one
     * integration can be created in an account, and this integration must be with OpenSearch Service.
     * </p>
     *
     * @param listIntegrationsRequest
     * @return Result of the ListIntegrations operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListIntegrations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIntegrationsResponse listIntegrations(ListIntegrationsRequest listIntegrationsRequest)
            throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIntegrationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIntegrationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIntegrationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIntegrationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIntegrations");

            return clientHandler.execute(new ClientExecutionParams<ListIntegrationsRequest, ListIntegrationsResponse>()
                    .withOperationName("ListIntegrations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIntegrationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIntegrationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of the log anomaly detectors in the account.
     * </p>
     *
     * @param listLogAnomalyDetectorsRequest
     * @return Result of the ListLogAnomalyDetectors operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListLogAnomalyDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogAnomalyDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLogAnomalyDetectorsResponse listLogAnomalyDetectors(ListLogAnomalyDetectorsRequest listLogAnomalyDetectorsRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLogAnomalyDetectorsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLogAnomalyDetectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLogAnomalyDetectorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLogAnomalyDetectorsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLogAnomalyDetectors");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLogAnomalyDetectorsRequest, ListLogAnomalyDetectorsResponse>()
                            .withOperationName("ListLogAnomalyDetectors").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listLogAnomalyDetectorsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLogAnomalyDetectorsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of log groups in the Region in your account. If you are performing this action in a monitoring
     * account, you can choose to also return log groups from source accounts that are linked to the monitoring account.
     * For more information about using cross-account observability to set up monitoring accounts and source accounts,
     * see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html">
     * CloudWatch cross-account observability</a>.
     * </p>
     * <p>
     * You can optionally filter the list by log group class and by using regular expressions in your request to match
     * strings in the log group names.
     * </p>
     * <p>
     * This operation is paginated. By default, your first use of this operation returns 50 results, and includes a
     * token to use in a subsequent operation to return more results.
     * </p>
     *
     * @param listLogGroupsRequest
     * @return Result of the ListLogGroups operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListLogGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLogGroupsResponse listLogGroups(ListLogGroupsRequest listLogGroupsRequest) throws InvalidParameterException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLogGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLogGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLogGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLogGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLogGroups");

            return clientHandler.execute(new ClientExecutionParams<ListLogGroupsRequest, ListLogGroupsResponse>()
                    .withOperationName("ListLogGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listLogGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLogGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of the log groups that were analyzed during a single CloudWatch Logs Insights query. This can be
     * useful for queries that use log group name prefixes or the <code>filterIndex</code> command, because the log
     * groups are dynamically selected in these cases.
     * </p>
     * <p>
     * For more information about field indexes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>.
     * </p>
     *
     * @param listLogGroupsForQueryRequest
     * @return Result of the ListLogGroupsForQuery operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListLogGroupsForQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListLogGroupsForQuery" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListLogGroupsForQueryResponse listLogGroupsForQuery(ListLogGroupsForQueryRequest listLogGroupsForQueryRequest)
            throws InvalidParameterException, AccessDeniedException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLogGroupsForQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLogGroupsForQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLogGroupsForQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLogGroupsForQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLogGroupsForQuery");

            return clientHandler.execute(new ClientExecutionParams<ListLogGroupsForQueryRequest, ListLogGroupsForQueryResponse>()
                    .withOperationName("ListLogGroupsForQuery").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listLogGroupsForQueryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLogGroupsForQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays the tags associated with a CloudWatch Logs resource. Currently, log groups and destinations support
     * tagging.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * The ListTagsLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a> instead.
     * </p>
     * </important>
     * <p>
     * Lists the tags for the specified log group.
     * </p>
     *
     * @param listTagsLogGroupRequest
     * @return Result of the ListTagsLogGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.ListTagsLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/ListTagsLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsLogGroupResponse listTagsLogGroup(ListTagsLogGroupRequest listTagsLogGroupRequest)
            throws ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsLogGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsLogGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsLogGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsLogGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsLogGroup");

            return clientHandler.execute(new ClientExecutionParams<ListTagsLogGroupRequest, ListTagsLogGroupResponse>()
                    .withOperationName("ListTagsLogGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsLogGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsLogGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an account-level data protection policy, subscription filter policy, field index policy, transformer
     * policy, or metric extraction policy that applies to all log groups or a subset of log groups in the account.
     * </p>
     * <p>
     * To use this operation, you must be signed on with the correct permissions depending on the type of policy that
     * you are creating.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a data protection policy, you must have the <code>logs:PutDataProtectionPolicy</code> and
     * <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a subscription filter policy, you must have the <code>logs:PutSubscriptionFilter</code> and
     * <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a transformer policy, you must have the <code>logs:PutTransformer</code> and
     * <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a field index policy, you must have the <code>logs:PutIndexPolicy</code> and
     * <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a metric extraction policy, you must have the <code>logs:PutMetricExtractionPolicy</code> and
     * <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Data protection policy</b>
     * </p>
     * <p>
     * A data protection policy can help safeguard sensitive data that's ingested by your log groups by auditing and
     * masking the sensitive log data. Each account can have only one account-level data protection policy.
     * </p>
     * <important>
     * <p>
     * Sensitive data is detected and masked when it is ingested into a log group. When you set a data protection
     * policy, log events ingested into the log groups before that time are not masked.
     * </p>
     * </important>
     * <p>
     * If you use <code>PutAccountPolicy</code> to create a data protection policy for your whole account, it applies to
     * both existing log groups and all log groups that are created later in this account. The account-level policy is
     * applied to existing log groups with eventual consistency. It might take up to 5 minutes before sensitive data in
     * existing log groups begins to be masked.
     * </p>
     * <p>
     * By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * A user who has the <code>logs:Unmask</code> permission can use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html"
     * >GetLogEvents</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html"
     * >FilterLogEvents</a> operation with the <code>unmask</code> parameter set to <code>true</code> to view the
     * unmasked log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
     * console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.
     * </p>
     * <p>
     * For more information, including a list of types of data that can be audited and masked, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive
     * log data with masking</a>.
     * </p>
     * <p>
     * To use the <code>PutAccountPolicy</code> operation for a data protection policy, you must be signed on with the
     * <code>logs:PutDataProtectionPolicy</code> and <code>logs:PutAccountPolicy</code> permissions.
     * </p>
     * <p>
     * The <code>PutAccountPolicy</code> operation applies to all log groups in the account. You can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDataProtectionPolicy.html"
     * >PutDataProtectionPolicy</a> to create a data protection policy that applies to just one log group. If a log
     * group has its own data protection policy and the account also has an account-level data protection policy, then
     * the two policies are cumulative. Any sensitive term specified in either policy is masked.
     * </p>
     * <p>
     * <b>Subscription filter policy</b>
     * </p>
     * <p>
     * A subscription filter policy sets up a real-time feed of log events from CloudWatch Logs to other Amazon Web
     * Services services. Account-level subscription filter policies apply to both existing log groups and log groups
     * that are created later in this account. Supported destinations are Kinesis Data Streams, Firehose, and Lambda.
     * When log events are sent to the receiving service, they are Base64 encoded and compressed with the GZIP format.
     * </p>
     * <p>
     * The following destinations are supported for subscription filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Kinesis Data Streams data stream in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Firehose data stream in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A Lambda function in the same account as the subscription policy, for same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination in a different account created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html"
     * >PutDestination</a>, for cross-account delivery. Kinesis Data Streams and Firehose are supported as logical
     * destinations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each account can have one account-level subscription filter policy per Region. If you are updating an existing
     * filter, you must specify the correct name in <code>PolicyName</code>. To perform a <code>PutAccountPolicy</code>
     * subscription filter operation for any destination except a Lambda function, you must also have the
     * <code>iam:PassRole</code> permission.
     * </p>
     * <p>
     * <b>Transformer policy</b>
     * </p>
     * <p>
     * Creates or updates a <i>log transformer policy</i> for your account. You use log transformers to transform log
     * events into a different format, making them easier for you to process and analyze. You can also transform logs
     * from different sources into standardized formats that contain relevant, source-specific information. After you
     * have created a transformer, CloudWatch Logs performs this transformation at the time of log ingestion. You can
     * then refer to the transformed versions of the logs during operations such as querying with CloudWatch Logs
     * Insights or creating metric filters or subscription filters.
     * </p>
     * <p>
     * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata
     * can include log group name, log stream name, account ID and Region.
     * </p>
     * <p>
     * A transformer for a log group is a series of processors, where each processor applies one type of transformation
     * to the log events ingested into this log group. For more information about the available processors to use in a
     * transformer, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors"
     * > Processors that you can use</a>.
     * </p>
     * <p>
     * Having log events in standardized format enables visibility across your applications for your log analysis,
     * reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box
     * transformation templates for major Amazon Web Services log sources such as VPC flow logs, Lambda, and Amazon RDS.
     * You can use pre-built transformation templates or create custom transformation policies.
     * </p>
     * <p>
     * You can create transformers only for the log groups in the Standard log class.
     * </p>
     * <p>
     * You can have one account-level transformer policy that applies to all log groups in the account. Or you can
     * create as many as 20 account-level transformer policies that are each scoped to a subset of log groups with the
     * <code>selectionCriteria</code> parameter. If you have multiple account-level transformer policies with selection
     * criteria, no two of them can use the same or overlapping log group name prefixes. For example, if you have one
     * policy filtered to log groups that start with <code>my-log</code>, you can't have another field index policy
     * filtered to <code>my-logpprod</code> or <code>my-logging</code>.
     * </p>
     * <p>
     * CloudWatch Logs provides default field indexes for all log groups in the Standard log class. Default field
     * indexes are automatically available for the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>@aws.region</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>@aws.account</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>@source.log</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>traceId</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default field indexes are in addition to any custom field indexes you define within your policy. Default field
     * indexes are not counted towards your field index quota.
     * </p>
     * <p>
     * You can also set up a transformer at the log-group level. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutTransformer.html"
     * >PutTransformer</a>. If there is both a log-group level transformer created with <code>PutTransformer</code> and
     * an account-level transformer that could apply to the same log group, the log group uses only the log-group level
     * transformer. It ignores the account-level transformer.
     * </p>
     * <p>
     * <b>Field index policy</b>
     * </p>
     * <p>
     * You can use field index policies to create indexes on fields found in log events in the log group. Creating field
     * indexes can help lower the scan volume for CloudWatch Logs Insights queries that reference those fields, because
     * these queries attempt to skip the processing of log events that are known to not match the indexed field. Good
     * fields to index are fields that you often need to query for and fields or values that match only a small fraction
     * of the total log events. Common examples of indexes include request ID, session ID, user IDs, or instance IDs.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>
     * </p>
     * <p>
     * To find the fields that are in your log group events, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html"
     * >GetLogGroupFields</a> operation.
     * </p>
     * <p>
     * For example, suppose you have created a field index for <code>requestId</code>. Then, any CloudWatch Logs
     * Insights query on that log group that includes <code>requestId = <i>value</i> </code> or
     * <code>requestId in [<i>value</i>, <i>value</i>, ...]</code> will attempt to process only the log events where the
     * indexed field matches the specified value.
     * </p>
     * <p>
     * Matches of log events to the names of indexed fields are case-sensitive. For example, an indexed field of
     * <code>RequestId</code> won't match a log event containing <code>requestId</code>.
     * </p>
     * <p>
     * You can have one account-level field index policy that applies to all log groups in the account. Or you can
     * create as many as 20 account-level field index policies that are each scoped to a subset of log groups with the
     * <code>selectionCriteria</code> parameter. If you have multiple account-level index policies with selection
     * criteria, no two of them can use the same or overlapping log group name prefixes. For example, if you have one
     * policy filtered to log groups that start with <code>my-log</code>, you can't have another field index policy
     * filtered to <code>my-logpprod</code> or <code>my-logging</code>.
     * </p>
     * <p>
     * If you create an account-level field index policy in a monitoring account in cross-account observability, the
     * policy is applied only to the monitoring account and not to any source accounts.
     * </p>
     * <p>
     * If you want to create a field index policy for a single log group, you can use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutIndexPolicy.html"
     * >PutIndexPolicy</a> instead of <code>PutAccountPolicy</code>. If you do so, that log group will use only that
     * log-group level policy, and will ignore the account-level policy that you create with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>.
     * </p>
     * <p>
     * <b>Metric extraction policy</b>
     * </p>
     * <p>
     * A metric extraction policy controls whether CloudWatch Metrics can be created through the Embedded Metrics Format
     * (EMF) for log groups in your account. By default, EMF metric creation is enabled for all log groups. You can use
     * metric extraction policies to disable EMF metric creation for your entire account or specific log groups.
     * </p>
     * <p>
     * When a policy disables EMF metric creation for a log group, log events in the EMF format are still ingested, but
     * no CloudWatch Metrics are created from them.
     * </p>
     * <important>
     * <p>
     * Creating a policy disables metrics for AWS features that use EMF to create metrics, such as CloudWatch Container
     * Insights and CloudWatch Application Signals. To prevent turning off those features by accident, we recommend that
     * you exclude the underlying log-groups through a selection-criteria such as
     * <code>LogGroupNamePrefix NOT IN ["/aws/containerinsights", "/aws/ecs/containerinsights", "/aws/application-signals/data"]</code>
     * .
     * </p>
     * </important>
     * <p>
     * Each account can have either one account-level metric extraction policy that applies to all log groups, or up to
     * 5 policies that are each scoped to a subset of log groups with the <code>selectionCriteria</code> parameter. The
     * selection criteria supports filtering by <code>LogGroupName</code> and <code>LogGroupNamePrefix</code> using the
     * operators <code>IN</code> and <code>NOT IN</code>. You can specify up to 50 values in each <code>IN</code> or
     * <code>NOT IN</code> list.
     * </p>
     * <p>
     * The selection criteria can be specified in these formats:
     * </p>
     * <p>
     * <code>LogGroupName IN ["log-group-1", "log-group-2"]</code>
     * </p>
     * <p>
     * <code>LogGroupNamePrefix NOT IN ["/aws/prefix1", "/aws/prefix2"]</code>
     * </p>
     * <p>
     * If you have multiple account-level metric extraction policies with selection criteria, no two of them can have
     * overlapping criteria. For example, if you have one policy with selection criteria
     * <code>LogGroupNamePrefix IN ["my-log"]</code>, you can't have another metric extraction policy with selection
     * criteria <code>LogGroupNamePrefix IN ["/my-log-prod"]</code> or
     * <code>LogGroupNamePrefix IN ["/my-logging"]</code>, as the set of log groups matching these prefixes would be a
     * subset of the log groups matching the first policy's prefix, creating an overlap.
     * </p>
     * <p>
     * When using <code>NOT IN</code>, only one policy with this operator is allowed per account.
     * </p>
     * <p>
     * When combining policies with <code>IN</code> and <code>NOT IN</code> operators, the overlap check ensures that
     * policies don't have conflicting effects. Two policies with <code>IN</code> and <code>NOT IN</code> operators do
     * not overlap if and only if every value in the <code>IN </code>policy is completely contained within some value in
     * the <code>NOT IN</code> policy. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you have a <code>NOT IN</code> policy for prefix <code>"/aws/lambda"</code>, you can create an <code>IN</code>
     * policy for the exact log group name <code>"/aws/lambda/function1"</code> because the set of log groups matching
     * <code>"/aws/lambda/function1"</code> is a subset of the log groups matching <code>"/aws/lambda"</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you have a <code>NOT IN</code> policy for prefix <code>"/aws/lambda"</code>, you cannot create an
     * <code>IN</code> policy for prefix <code>"/aws"</code> because the set of log groups matching <code>"/aws"</code>
     * is not a subset of the log groups matching <code>"/aws/lambda"</code>.
     * </p>
     * </li>
     * </ul>
     *
     * @param putAccountPolicyRequest
     * @return Result of the PutAccountPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutAccountPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutAccountPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutAccountPolicyResponse putAccountPolicy(PutAccountPolicyRequest putAccountPolicyRequest)
            throws InvalidParameterException, OperationAbortedException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutAccountPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutAccountPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putAccountPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putAccountPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutAccountPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutAccountPolicyRequest, PutAccountPolicyResponse>()
                    .withOperationName("PutAccountPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putAccountPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutAccountPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a data protection policy for the specified log group. A data protection policy can help safeguard
     * sensitive data that's ingested by the log group by auditing and masking the sensitive log data.
     * </p>
     * <important>
     * <p>
     * Sensitive data is detected and masked when it is ingested into the log group. When you set a data protection
     * policy, log events ingested into the log group before that time are not masked.
     * </p>
     * </important>
     * <p>
     * By default, when a user views a log event that includes masked data, the sensitive data is replaced by asterisks.
     * A user who has the <code>logs:Unmask</code> permission can use a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogEvents.html"
     * >GetLogEvents</a> or <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_FilterLogEvents.html"
     * >FilterLogEvents</a> operation with the <code>unmask</code> parameter set to <code>true</code> to view the
     * unmasked log events. Users with the <code>logs:Unmask</code> can also view unmasked data in the CloudWatch Logs
     * console by running a CloudWatch Logs Insights query with the <code>unmask</code> query command.
     * </p>
     * <p>
     * For more information, including a list of types of data that can be audited and masked, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data.html">Protect sensitive
     * log data with masking</a>.
     * </p>
     * <p>
     * The <code>PutDataProtectionPolicy</code> operation applies to only the specified log group. You can also use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html">
     * PutAccountPolicy</a> to create an account-level data protection policy that applies to all log groups in the
     * account, including both existing log groups and log groups that are created level. If a log group has its own
     * data protection policy and the account also has an account-level data protection policy, then the two policies
     * are cumulative. Any sensitive term specified in either policy is masked.
     * </p>
     *
     * @param putDataProtectionPolicyRequest
     * @return Result of the PutDataProtectionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutDataProtectionPolicyResponse putDataProtectionPolicy(PutDataProtectionPolicyRequest putDataProtectionPolicyRequest)
            throws InvalidParameterException, LimitExceededException, OperationAbortedException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDataProtectionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDataProtectionPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDataProtectionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDataProtectionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDataProtectionPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutDataProtectionPolicyRequest, PutDataProtectionPolicyResponse>()
                            .withOperationName("PutDataProtectionPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putDataProtectionPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDataProtectionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a logical <i>delivery destination</i>. A delivery destination is an Amazon Web Services
     * resource that represents an Amazon Web Services service that logs can be sent to. CloudWatch Logs, Amazon S3, and
     * Firehose are supported as logs delivery destinations and X-Ray as the trace delivery destination.
     * </p>
     * <p>
     * To configure logs delivery between a supported Amazon Web Services service and a destination, you must do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutDeliveryDestination</code> to create a <i>delivery destination</i> in the same account of the actual
     * delivery destination. The delivery destination that you create is a logical object that represents the actual
     * delivery destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * If you use this operation to update an existing delivery destination, all the current delivery destination
     * parameters are overwritten with the new parameter values that you specify.
     * </p>
     *
     * @param putDeliveryDestinationRequest
     * @return Result of the PutDeliveryDestination operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutDeliveryDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliveryDestination" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutDeliveryDestinationResponse putDeliveryDestination(PutDeliveryDestinationRequest putDeliveryDestinationRequest)
            throws ServiceUnavailableException, ConflictException, ValidationException, ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDeliveryDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDeliveryDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDeliveryDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDeliveryDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDeliveryDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<PutDeliveryDestinationRequest, PutDeliveryDestinationResponse>()
                            .withOperationName("PutDeliveryDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putDeliveryDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDeliveryDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and assigns an IAM policy that grants permissions to CloudWatch Logs to deliver logs cross-account to a
     * specified destination in this account. To configure the delivery of logs from an Amazon Web Services service in
     * another account to a logs delivery destination in the current account, you must do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a delivery source, which is a logical object that represents the resource that is actually sending the
     * logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliverySource.html"
     * >PutDeliverySource</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery destination</i>, which is a logical object that represents the actual delivery destination.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use this operation in the destination account to assign an IAM policy to the destination. This policy allows
     * delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a <i>delivery</i> by pairing exactly one delivery source and one delivery destination. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * The contents of the policy must include two statements. One statement enables general logs delivery, and the
     * other allows delivery to the chosen destination. See the examples for the needed policies.
     * </p>
     *
     * @param putDeliveryDestinationPolicyRequest
     * @return Result of the PutDeliveryDestinationPolicy operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutDeliveryDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliveryDestinationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutDeliveryDestinationPolicyResponse putDeliveryDestinationPolicy(
            PutDeliveryDestinationPolicyRequest putDeliveryDestinationPolicyRequest) throws ServiceUnavailableException,
            ValidationException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDeliveryDestinationPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDeliveryDestinationPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDeliveryDestinationPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDeliveryDestinationPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDeliveryDestinationPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<PutDeliveryDestinationPolicyRequest, PutDeliveryDestinationPolicyResponse>()
                            .withOperationName("PutDeliveryDestinationPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putDeliveryDestinationPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutDeliveryDestinationPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a logical <i>delivery source</i>. A delivery source represents an Amazon Web Services resource
     * that sends logs to an logs delivery destination. The destination can be CloudWatch Logs, Amazon S3, Firehose or
     * X-Ray for sending traces.
     * </p>
     * <p>
     * To configure logs delivery between a delivery destination and an Amazon Web Services service that is supported as
     * a delivery source, you must do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>PutDeliverySource</code> to create a delivery source, which is a logical object that represents the
     * resource that is actually sending the logs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>PutDeliveryDestination</code> to create a <i>delivery destination</i>, which is a logical object that
     * represents the actual delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestination.html"
     * >PutDeliveryDestination</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are delivering logs cross-account, you must use <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDeliveryDestinationPolicy.html"
     * >PutDeliveryDestinationPolicy</a> in the destination account to assign an IAM policy to the destination. This
     * policy allows delivery to that destination.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>CreateDelivery</code> to create a <i>delivery</i> by pairing exactly one delivery source and one
     * delivery destination. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CreateDelivery.html"
     * >CreateDelivery</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can configure a single delivery source to send logs to multiple destinations by creating multiple deliveries.
     * You can also create multiple deliveries to configure multiple delivery sources to send logs to the same delivery
     * destination.
     * </p>
     * <p>
     * Only some Amazon Web Services services support being configured as a delivery source. These services are listed
     * as <b>Supported [V2 Permissions]</b> in the table at <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html">Enabling
     * logging from Amazon Web Services services.</a>
     * </p>
     * <p>
     * If you use this operation to update an existing delivery source, all the current delivery source parameters are
     * overwritten with the new parameter values that you specify.
     * </p>
     *
     * @param putDeliverySourceRequest
     * @return Result of the PutDeliverySource operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws ServiceQuotaExceededException
     *         This request exceeds a service quota.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutDeliverySource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDeliverySource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutDeliverySourceResponse putDeliverySource(PutDeliverySourceRequest putDeliverySourceRequest)
            throws ServiceUnavailableException, ConflictException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDeliverySourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutDeliverySourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDeliverySourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDeliverySourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDeliverySource");

            return clientHandler.execute(new ClientExecutionParams<PutDeliverySourceRequest, PutDeliverySourceResponse>()
                    .withOperationName("PutDeliverySource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putDeliverySourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutDeliverySourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a destination. This operation is used only to create destinations for cross-account
     * subscriptions.
     * </p>
     * <p>
     * A destination encapsulates a physical resource (such as an Amazon Kinesis stream). With a destination, you can
     * subscribe to a real-time stream of log events for a different account, ingested using <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a>.
     * </p>
     * <p>
     * Through an access policy, a destination controls what is written to it. By default, <code>PutDestination</code>
     * does not set any access policy with the destination, which means a cross-account user cannot call <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutSubscriptionFilter.html"
     * >PutSubscriptionFilter</a> against this destination. To enable this, the destination owner must call <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestinationPolicy.html"
     * >PutDestinationPolicy</a> after <code>PutDestination</code>.
     * </p>
     * <p>
     * To perform a <code>PutDestination</code> operation, you must also have the <code>iam:PassRole</code> permission.
     * </p>
     *
     * @param putDestinationRequest
     * @return Result of the PutDestination operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutDestination
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestination" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutDestinationResponse putDestination(PutDestinationRequest putDestinationRequest) throws InvalidParameterException,
            OperationAbortedException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDestinationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutDestinationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDestinationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDestination");

            return clientHandler.execute(new ClientExecutionParams<PutDestinationRequest, PutDestinationResponse>()
                    .withOperationName("PutDestination").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putDestinationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates an access policy associated with an existing destination. An access policy is an <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html">IAM policy document</a> that is
     * used to authorize claims to register a subscription filter against a given destination.
     * </p>
     *
     * @param putDestinationPolicyRequest
     * @return Result of the PutDestinationPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutDestinationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutDestinationPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutDestinationPolicyResponse putDestinationPolicy(PutDestinationPolicyRequest putDestinationPolicyRequest)
            throws InvalidParameterException, OperationAbortedException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutDestinationPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutDestinationPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putDestinationPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putDestinationPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutDestinationPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutDestinationPolicyRequest, PutDestinationPolicyResponse>()
                    .withOperationName("PutDestinationPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putDestinationPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutDestinationPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a <i>field index policy</i> for the specified log group. Only log groups in the Standard log
     * class support field index policies. For more information about log classes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch_Logs_Log_Classes.html">Log classes</a>.
     * </p>
     * <p>
     * You can use field index policies to create <i>field indexes</i> on fields found in log events in the log group.
     * Creating field indexes speeds up and lowers the costs for CloudWatch Logs Insights queries that reference those
     * field indexes, because these queries attempt to skip the processing of log events that are known to not match the
     * indexed field. Good fields to index are fields that you often need to query for and fields or values that match
     * only a small fraction of the total log events. Common examples of indexes include request ID, session ID, userID,
     * and instance IDs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-Field-Indexing.html">Create field
     * indexes to improve query performance and reduce costs</a>.
     * </p>
     * <p>
     * To find the fields that are in your log group events, use the <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetLogGroupFields.html"
     * >GetLogGroupFields</a> operation.
     * </p>
     * <p>
     * For example, suppose you have created a field index for <code>requestId</code>. Then, any CloudWatch Logs
     * Insights query on that log group that includes <code>requestId = <i>value</i> </code> or
     * <code>requestId IN [<i>value</i>, <i>value</i>, ...]</code> will process fewer log events to reduce costs, and
     * have improved performance.
     * </p>
     * <p>
     * CloudWatch Logs provides default field indexes for all log groups in the Standard log class. Default field
     * indexes are automatically available for the following fields:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>@aws.region</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>@aws.account</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>@source.log</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>traceId</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default field indexes are in addition to any custom field indexes you define within your policy. Default field
     * indexes are not counted towards your field index quota.
     * </p>
     * <p>
     * Each index policy has the following quotas and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * As many as 20 fields can be included in the policy.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each field name can include as many as 100 characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Matches of log events to the names of indexed fields are case-sensitive. For example, a field index of
     * <code>RequestId</code> won't match a log event containing <code>requestId</code>.
     * </p>
     * <p>
     * Log group-level field index policies created with <code>PutIndexPolicy</code> override account-level field index
     * policies created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>. If you use <code>PutIndexPolicy</code> to create a field index policy for a log group,
     * that log group uses only that policy. The log group ignores any account-wide field index policy that you might
     * have created.
     * </p>
     *
     * @param putIndexPolicyRequest
     * @return Result of the PutIndexPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutIndexPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutIndexPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutIndexPolicyResponse putIndexPolicy(PutIndexPolicyRequest putIndexPolicyRequest) throws InvalidParameterException,
            ResourceNotFoundException, LimitExceededException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutIndexPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutIndexPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putIndexPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIndexPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIndexPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutIndexPolicyRequest, PutIndexPolicyResponse>()
                    .withOperationName("PutIndexPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putIndexPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutIndexPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an integration between CloudWatch Logs and another service in this account. Currently, only integrations
     * with OpenSearch Service are supported, and currently you can have only one integration in your account.
     * </p>
     * <p>
     * Integrating with OpenSearch Service makes it possible for you to create curated vended logs dashboards, powered
     * by OpenSearch Service analytics. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-OpenSearch-Dashboards.html">Vended
     * log dashboards powered by Amazon OpenSearch Service</a>.
     * </p>
     * <p>
     * You can use this operation only to create a new integration. You can't modify an existing integration.
     * </p>
     *
     * @param putIntegrationRequest
     * @return Result of the PutIntegration operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutIntegration" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutIntegrationResponse putIntegration(PutIntegrationRequest putIntegrationRequest) throws InvalidParameterException,
            LimitExceededException, ServiceUnavailableException, ValidationException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutIntegrationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutIntegrationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putIntegrationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putIntegrationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutIntegration");

            return clientHandler.execute(new ClientExecutionParams<PutIntegrationRequest, PutIntegrationResponse>()
                    .withOperationName("PutIntegration").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putIntegrationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutIntegrationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads a batch of log events to the specified log stream.
     * </p>
     * <important>
     * <p>
     * The sequence token is now ignored in <code>PutLogEvents</code> actions. <code>PutLogEvents</code> actions are
     * always accepted and never return <code>InvalidSequenceTokenException</code> or
     * <code>DataAlreadyAcceptedException</code> even if the sequence token is not valid. You can use parallel
     * <code>PutLogEvents</code> actions on the same log stream.
     * </p>
     * </important>
     * <p>
     * The batch of events must satisfy the following constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The maximum batch size is 1,048,576 bytes. This size is calculated as the sum of all event messages in UTF-8,
     * plus 26 bytes for each log event.
     * </p>
     * </li>
     * <li>
     * <p>
     * Events more than 2 hours in the future are rejected while processing remaining valid events.
     * </p>
     * </li>
     * <li>
     * <p>
     * Events older than 14 days or preceding the log group's retention period are rejected while processing remaining
     * valid events.
     * </p>
     * </li>
     * <li>
     * <p>
     * The log events in the batch must be in chronological order by their timestamp. The timestamp is the time that the
     * event occurred, expressed as the number of milliseconds after <code>Jan 1, 1970 00:00:00 UTC</code>. (In Amazon
     * Web Services Tools for PowerShell and the Amazon Web Services SDK for .NET, the timestamp is specified in .NET
     * format: <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2017-09-15T13:45:30</code>.)
     * </p>
     * </li>
     * <li>
     * <p>
     * A batch of log events in a single request must be in a chronological order. Otherwise, the operation fails.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each log event can be no larger than 1 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum number of log events in a batch is 10,000.
     * </p>
     * </li>
     * <li>
     * <p>
     * For valid events (within 14 days in the past to 2 hours in future), the time span in a single batch cannot exceed
     * 24 hours. Otherwise, the operation fails.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * The quota of five requests per second per log stream has been removed. Instead, <code>PutLogEvents</code> actions
     * are throttled based on a per-second per-account quota. You can request an increase to the per-second throttling
     * quota by using the Service Quotas service.
     * </p>
     * </important>
     * <p>
     * If a call to <code>PutLogEvents</code> returns "UnrecognizedClientException" the most likely cause is a non-valid
     * Amazon Web Services access key ID or secret key.
     * </p>
     *
     * @param putLogEventsRequest
     * @return Result of the PutLogEvents operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws InvalidSequenceTokenException
     *         The sequence token is not valid. You can get the correct sequence token in the
     *         <code>expectedSequenceToken</code> field in the <code>InvalidSequenceTokenException</code> message. </p>
     *         <important>
     *         <p>
     *         <code>PutLogEvents</code> actions are now always accepted and never return
     *         <code>InvalidSequenceTokenException</code> regardless of receiving an invalid sequence token.
     *         </p>
     * @throws DataAlreadyAcceptedException
     *         The event was already logged.</p> <important>
     *         <p>
     *         <code>PutLogEvents</code> actions are now always accepted and never return
     *         <code>DataAlreadyAcceptedException</code> regardless of whether a given batch of log events has already
     *         been accepted.
     *         </p>
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws UnrecognizedClientException
     *         The most likely cause is an Amazon Web Services access key ID or secret key that's not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutLogEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutLogEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutLogEventsResponse putLogEvents(PutLogEventsRequest putLogEventsRequest) throws InvalidParameterException,
            InvalidSequenceTokenException, DataAlreadyAcceptedException, ResourceNotFoundException, ServiceUnavailableException,
            UnrecognizedClientException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutLogEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutLogEventsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putLogEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLogEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLogEvents");

            return clientHandler.execute(new ClientExecutionParams<PutLogEventsRequest, PutLogEventsResponse>()
                    .withOperationName("PutLogEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putLogEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutLogEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a metric filter and associates it with the specified log group. With metric filters, you can
     * configure rules to extract metric data from log events ingested through <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a>.
     * </p>
     * <p>
     * The maximum number of metric filters that can be associated with a log group is 100.
     * </p>
     * <p>
     * Using regular expressions in filter patterns is supported. For these filters, there is a quota of two regular
     * expression patterns within a single filter pattern. There is also a quota of five regular expression patterns per
     * log group. For more information about using regular expressions in filter patterns, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html"> Filter pattern
     * syntax for metric filters, subscription filters, filter log events, and Live Tail</a>.
     * </p>
     * <p>
     * When you create a metric filter, you can also optionally assign a unit and dimensions to the metric that is
     * created.
     * </p>
     * <important>
     * <p>
     * Metrics extracted from log events are charged as custom metrics. To prevent unexpected high charges, do not
     * specify high-cardinality fields such as <code>IPAddress</code> or <code>requestID</code> as dimensions. Each
     * different value found for a dimension is treated as a separate metric and accrues charges as a separate custom
     * metric.
     * </p>
     * <p>
     * CloudWatch Logs might disable a metric filter if it generates 1,000 different name/value pairs for your specified
     * dimensions within one hour.
     * </p>
     * <p>
     * You can also set up a billing alarm to alert you if your charges are higher than expected. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/monitor_estimated_charges_with_cloudwatch.html">
     * Creating a Billing Alarm to Monitor Your Estimated Amazon Web Services Charges</a>.
     * </p>
     * </important>
     *
     * @param putMetricFilterRequest
     * @return Result of the PutMetricFilter operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutMetricFilterResponse putMetricFilter(PutMetricFilterRequest putMetricFilterRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, LimitExceededException,
            ServiceUnavailableException, InvalidOperationException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutMetricFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutMetricFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putMetricFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putMetricFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutMetricFilter");

            return clientHandler.execute(new ClientExecutionParams<PutMetricFilterRequest, PutMetricFilterResponse>()
                    .withOperationName("PutMetricFilter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putMetricFilterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutMetricFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a query definition for CloudWatch Logs Insights. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AnalyzingLogData.html">Analyzing Log Data with
     * CloudWatch Logs Insights</a>.
     * </p>
     * <p>
     * To update a query definition, specify its <code>queryDefinitionId</code> in your request. The values of
     * <code>name</code>, <code>queryString</code>, and <code>logGroupNames</code> are changed to the values that you
     * specify in your update operation. No current values are retained from the current query definition. For example,
     * imagine updating a current query definition that includes log groups. If you don't specify the
     * <code>logGroupNames</code> parameter in your update operation, the query definition changes to contain no log
     * groups.
     * </p>
     * <p>
     * You must have the <code>logs:PutQueryDefinition</code> permission to be able to perform this operation.
     * </p>
     *
     * @param putQueryDefinitionRequest
     * @return Result of the PutQueryDefinition operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutQueryDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutQueryDefinition" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutQueryDefinitionResponse putQueryDefinition(PutQueryDefinitionRequest putQueryDefinitionRequest)
            throws InvalidParameterException, LimitExceededException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutQueryDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutQueryDefinitionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putQueryDefinitionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putQueryDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutQueryDefinition");

            return clientHandler.execute(new ClientExecutionParams<PutQueryDefinitionRequest, PutQueryDefinitionResponse>()
                    .withOperationName("PutQueryDefinition").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putQueryDefinitionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutQueryDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a resource policy allowing other Amazon Web Services services to put log events to this
     * account, such as Amazon Route 53. An account can have up to 10 resource policies per Amazon Web Services Region.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutResourcePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws InvalidParameterException, LimitExceededException, OperationAbortedException, ResourceNotFoundException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutResourcePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutResourcePolicyRequest, PutResourcePolicyResponse>()
                    .withOperationName("PutResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the retention of the specified log group. With a retention policy, you can configure the number of days for
     * which to retain log events in the specified log group.
     * </p>
     * <note>
     * <p>
     * CloudWatch Logs doesn't immediately delete log events when they reach their retention setting. It typically takes
     * up to 72 hours after that before log events are deleted, but in rare situations might take longer.
     * </p>
     * <p>
     * To illustrate, imagine that you change a log group to have a longer retention setting when it contains log events
     * that are past the expiration date, but haven't been deleted. Those log events will take up to 72 hours to be
     * deleted after the new retention date is reached. To make sure that log data is deleted permanently, keep a log
     * group at its lower retention setting until 72 hours after the previous retention period ends. Alternatively, wait
     * to change the retention setting until you confirm that the earlier log events are deleted.
     * </p>
     * <p>
     * When log events reach their retention setting they are marked for deletion. After they are marked for deletion,
     * they do not add to your archival storage costs anymore, even if they are not actually deleted until later. These
     * log events marked for deletion are also not included when you use an API to retrieve the <code>storedBytes</code>
     * value to see how many bytes a log group is storing.
     * </p>
     * </note>
     *
     * @param putRetentionPolicyRequest
     * @return Result of the PutRetentionPolicy operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutRetentionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutRetentionPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutRetentionPolicyResponse putRetentionPolicy(PutRetentionPolicyRequest putRetentionPolicyRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutRetentionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutRetentionPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putRetentionPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRetentionPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRetentionPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutRetentionPolicyRequest, PutRetentionPolicyResponse>()
                    .withOperationName("PutRetentionPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putRetentionPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutRetentionPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a subscription filter and associates it with the specified log group. With subscription
     * filters, you can subscribe to a real-time stream of log events ingested through <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutLogEvents.html"
     * >PutLogEvents</a> and have them delivered to a specific destination. When log events are sent to the receiving
     * service, they are Base64 encoded and compressed with the GZIP format.
     * </p>
     * <p>
     * The following destinations are supported for subscription filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Kinesis data stream belonging to the same account as the subscription filter, for same-account
     * delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * A logical destination created with <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutDestination.html"
     * >PutDestination</a> that belongs to a different account, for cross-account delivery. We currently support Kinesis
     * Data Streams and Firehose as logical destinations.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Kinesis Data Firehose delivery stream that belongs to the same account as the subscription filter, for
     * same-account delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Lambda function that belongs to the same account as the subscription filter, for same-account delivery.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each log group can have up to two subscription filters associated with it. If you are updating an existing
     * filter, you must specify the correct name in <code>filterName</code>.
     * </p>
     * <p>
     * Using regular expressions in filter patterns is supported. For these filters, there is a quotas of quota of two
     * regular expression patterns within a single filter pattern. There is also a quota of five regular expression
     * patterns per log group. For more information about using regular expressions in filter patterns, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html"> Filter pattern
     * syntax for metric filters, subscription filters, filter log events, and Live Tail</a>.
     * </p>
     * <p>
     * To perform a <code>PutSubscriptionFilter</code> operation for any destination except a Lambda function, you must
     * also have the <code>iam:PassRole</code> permission.
     * </p>
     *
     * @param putSubscriptionFilterRequest
     * @return Result of the PutSubscriptionFilter operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutSubscriptionFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutSubscriptionFilter" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutSubscriptionFilterResponse putSubscriptionFilter(PutSubscriptionFilterRequest putSubscriptionFilterRequest)
            throws InvalidParameterException, ResourceNotFoundException, OperationAbortedException, LimitExceededException,
            ServiceUnavailableException, InvalidOperationException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutSubscriptionFilterResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutSubscriptionFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSubscriptionFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSubscriptionFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSubscriptionFilter");

            return clientHandler.execute(new ClientExecutionParams<PutSubscriptionFilterRequest, PutSubscriptionFilterResponse>()
                    .withOperationName("PutSubscriptionFilter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putSubscriptionFilterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutSubscriptionFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates or updates a <i>log transformer</i> for a single log group. You use log transformers to transform log
     * events into a different format, making them easier for you to process and analyze. You can also transform logs
     * from different sources into standardized formats that contains relevant, source-specific information.
     * </p>
     * <p>
     * After you have created a transformer, CloudWatch Logs performs the transformations at the time of log ingestion.
     * You can then refer to the transformed versions of the logs during operations such as querying with CloudWatch
     * Logs Insights or creating metric filters or subscription filers.
     * </p>
     * <p>
     * You can also use a transformer to copy metadata from metadata keys into the log events themselves. This metadata
     * can include log group name, log stream name, account ID and Region.
     * </p>
     * <p>
     * A transformer for a log group is a series of processors, where each processor applies one type of transformation
     * to the log events ingested into this log group. The processors work one after another, in the order that you list
     * them, like a pipeline. For more information about the available processors to use in a transformer, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatch-Logs-Transformation.html#CloudWatch-Logs-Transformation-Processors"
     * > Processors that you can use</a>.
     * </p>
     * <p>
     * Having log events in standardized format enables visibility across your applications for your log analysis,
     * reporting, and alarming needs. CloudWatch Logs provides transformation for common log types with out-of-the-box
     * transformation templates for major Amazon Web Services log sources such as VPC flow logs, Lambda, and Amazon RDS.
     * You can use pre-built transformation templates or create custom transformation policies.
     * </p>
     * <p>
     * You can create transformers only for the log groups in the Standard log class.
     * </p>
     * <p>
     * You can also set up a transformer at the account level. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_PutAccountPolicy.html"
     * >PutAccountPolicy</a>. If there is both a log-group level transformer created with <code>PutTransformer</code>
     * and an account-level transformer that could apply to the same log group, the log group uses only the log-group
     * level transformer. It ignores the account-level transformer.
     * </p>
     *
     * @param putTransformerRequest
     * @return Result of the PutTransformer operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.PutTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/PutTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutTransformerResponse putTransformer(PutTransformerRequest putTransformerRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, LimitExceededException, OperationAbortedException,
            InvalidOperationException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutTransformerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutTransformerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putTransformerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putTransformerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutTransformer");

            return clientHandler.execute(new ClientExecutionParams<PutTransformerRequest, PutTransformerResponse>()
                    .withOperationName("PutTransformer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(putTransformerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutTransformerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a query of one or more log groups using CloudWatch Logs Insights. You specify the log groups and time
     * range to query and the query string to use.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs Insights
     * Query Syntax</a>.
     * </p>
     * <p>
     * After you run a query using <code>StartQuery</code>, the query results are stored by CloudWatch Logs. You can use
     * <a href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_GetQueryResults.html">
     * GetQueryResults</a> to retrieve the results of a query, using the <code>queryId</code> that
     * <code>StartQuery</code> returns.
     * </p>
     * <note>
     * <p>
     * To specify the log groups to query, a <code>StartQuery</code> operation must include one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Either exactly one of the following parameters: <code>logGroupName</code>, <code>logGroupNames</code>, or
     * <code>logGroupIdentifiers</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Or the <code>queryString</code> must include a <code>SOURCE</code> command to select log groups for the query.
     * The <code>SOURCE</code> command can select log groups based on log group name prefix, account ID, and log class.
     * </p>
     * <p>
     * For more information about the <code>SOURCE</code> command, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax-Source.html">SOURCE</a>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * If you have associated a KMS key with the query results in this account, then <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_StartQuery.html">StartQuery</a>
     * uses that key to encrypt the results when it stores them. If no key is associated with query results, the query
     * results are encrypted with the default CloudWatch Logs encryption method.
     * </p>
     * <p>
     * Queries time out after 60 minutes of runtime. If your queries are timing out, reduce the time range being
     * searched or partition your query into a number of queries.
     * </p>
     * <p>
     * If you are using CloudWatch cross-account observability, you can use this operation in a monitoring account to
     * start a query in a linked source account. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html"
     * >CloudWatch cross-account observability</a>. For a cross-account <code>StartQuery</code> operation, the query
     * definition must be defined in the monitoring account.
     * </p>
     * <p>
     * You can have up to 30 concurrent CloudWatch Logs insights queries, including queries that have been added to
     * dashboards.
     * </p>
     *
     * @param startQueryRequest
     * @return Result of the StartQuery operation returned by the service.
     * @throws MalformedQueryException
     *         The query string is not valid. Details about this error are displayed in a <code>QueryCompileError</code>
     *         object. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_QueryCompileError.html"
     *         >QueryCompileError</a>.</p>
     *         <p>
     *         For more information about valid query syntax, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html">CloudWatch Logs
     *         Insights Query Syntax</a>.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws LimitExceededException
     *         You have reached the maximum number of resources that can be created.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.StartQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StartQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartQueryResponse startQuery(StartQueryRequest startQueryRequest) throws MalformedQueryException,
            InvalidParameterException, LimitExceededException, ResourceNotFoundException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartQuery");

            return clientHandler.execute(new ClientExecutionParams<StartQueryRequest, StartQueryResponse>()
                    .withOperationName("StartQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(startQueryRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a CloudWatch Logs Insights query that is in progress. If the query has already ended, the operation returns
     * an error indicating that the specified query is not running.
     * </p>
     *
     * @param stopQueryRequest
     * @return Result of the StopQuery operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.StopQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/StopQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopQueryResponse stopQuery(StopQueryRequest stopQueryRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopQuery");

            return clientHandler.execute(new ClientExecutionParams<StopQueryRequest, StopQueryResponse>()
                    .withOperationName("StopQuery").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(stopQueryRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * The TagLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html">TagResource</a>
     * instead.
     * </p>
     * </important>
     * <p>
     * Adds or updates the specified tags for the specified log group.
     * </p>
     * <p>
     * To list the tags for a log group, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a>. To remove tags, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html"
     * >UntagResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging"
     * >Tag Log Groups in Amazon CloudWatch Logs</a> in the <i>Amazon CloudWatch Logs User Guide</i>.
     * </p>
     * <p>
     * CloudWatch Logs doesn't support IAM policies that prevent users from assigning specified tags to log groups using
     * the <code>aws:Resource/<i>key-name</i> </code> or <code>aws:TagKeys</code> condition keys. For more information
     * about using tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Controlling access to Amazon Web
     * Services resources using tags</a>.
     * </p>
     *
     * @param tagLogGroupRequest
     * @return Result of the TagLogGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.TagLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagLogGroupResponse tagLogGroup(TagLogGroupRequest tagLogGroupRequest) throws ResourceNotFoundException,
            InvalidParameterException, AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagLogGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagLogGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagLogGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagLogGroup");

            return clientHandler.execute(new ClientExecutionParams<TagLogGroupRequest, TagLogGroupResponse>()
                    .withOperationName("TagLogGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagLogGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagLogGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified CloudWatch Logs resource. Currently, the only
     * CloudWatch Logs resources that can be tagged are log groups and destinations.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by
     * granting a user permission to access or change only resources with certain tag values.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of
     * characters.
     * </p>
     * <p>
     * You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag
     * key for the alarm, this tag is appended to the list of tags associated with the alarm. If you specify a tag key
     * that is already associated with the alarm, the new tag value that you specify replaces the previous value for
     * that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a CloudWatch Logs resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws TooManyTagsException
     *         A resource can have no more than 50 tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, TooManyTagsException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tests the filter pattern of a metric filter against a sample of log event messages. You can use this operation to
     * validate the correctness of a metric filter pattern.
     * </p>
     *
     * @param testMetricFilterRequest
     * @return Result of the TestMetricFilter operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.TestMetricFilter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestMetricFilter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestMetricFilterResponse testMetricFilter(TestMetricFilterRequest testMetricFilterRequest)
            throws InvalidParameterException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestMetricFilterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TestMetricFilterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testMetricFilterRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testMetricFilterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestMetricFilter");

            return clientHandler.execute(new ClientExecutionParams<TestMetricFilterRequest, TestMetricFilterResponse>()
                    .withOperationName("TestMetricFilter").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(testMetricFilterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestMetricFilterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to test a log transformer. You enter the transformer configuration and a set of log events to
     * test with. The operation responds with an array that includes the original log events and the transformed
     * versions.
     * </p>
     *
     * @param testTransformerRequest
     * @return Result of the TestTransformer operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws InvalidOperationException
     *         The operation is not valid on the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.TestTransformer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/TestTransformer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestTransformerResponse testTransformer(TestTransformerRequest testTransformerRequest)
            throws InvalidParameterException, ServiceUnavailableException, InvalidOperationException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestTransformerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TestTransformerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testTransformerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testTransformerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestTransformer");

            return clientHandler.execute(new ClientExecutionParams<TestTransformerRequest, TestTransformerResponse>()
                    .withOperationName("TestTransformer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(testTransformerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestTransformerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <important>
     * <p>
     * The UntagLogGroup operation is on the path to deprecation. We recommend that you use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagResource.html"
     * >UntagResource</a> instead.
     * </p>
     * </important>
     * <p>
     * Removes the specified tags from the specified log group.
     * </p>
     * <p>
     * To list the tags for a log group, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsForResource.html"
     * >ListTagsForResource</a>. To add tags, use <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_TagResource.html">TagResource</a>.
     * </p>
     * <p>
     * When using IAM policies to control tag management for CloudWatch Logs log groups, the condition keys
     * <code>aws:Resource/key-name</code> and <code>aws:TagKeys</code> cannot be used to restrict which tags users can
     * assign.
     * </p>
     *
     * @param untagLogGroupRequest
     * @return Result of the UntagLogGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.UntagLogGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagLogGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagLogGroupResponse untagLogGroup(UntagLogGroupRequest untagLogGroupRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagLogGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagLogGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagLogGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagLogGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagLogGroup");

            return clientHandler.execute(new ClientExecutionParams<UntagLogGroupRequest, UntagLogGroupResponse>()
                    .withOperationName("UntagLogGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagLogGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagLogGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to <i>suppress</i> anomaly detection for a specified anomaly or pattern. If you suppress an
     * anomaly, CloudWatch Logs won't report new occurrences of that anomaly and won't update that anomaly with new
     * data. If you suppress a pattern, CloudWatch Logs won't report any anomalies related to that pattern.
     * </p>
     * <p>
     * You must specify either <code>anomalyId</code> or <code>patternId</code>, but you can't specify both parameters
     * in the same operation.
     * </p>
     * <p>
     * If you have previously used this operation to suppress detection of a pattern or anomaly, you can use it again to
     * cause CloudWatch Logs to end the suppression. To do this, use this operation and specify the anomaly or pattern
     * to stop suppressing, and omit the <code>suppressionType</code> and <code>suppressionPeriod</code> parameters.
     * </p>
     *
     * @param updateAnomalyRequest
     * @return Result of the UpdateAnomaly operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.UpdateAnomaly
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateAnomaly" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAnomalyResponse updateAnomaly(UpdateAnomalyRequest updateAnomalyRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnomalyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAnomalyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnomalyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnomalyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnomaly");

            return clientHandler.execute(new ClientExecutionParams<UpdateAnomalyRequest, UpdateAnomalyResponse>()
                    .withOperationName("UpdateAnomaly").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAnomalyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAnomalyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this operation to update the configuration of a <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_Delivery.html">delivery</a> to
     * change either the S3 path pattern or the format of the delivered logs. You can't use this operation to change the
     * source or destination of the delivery.
     * </p>
     *
     * @param updateDeliveryConfigurationRequest
     * @return Result of the UpdateDeliveryConfiguration operation returned by the service.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws ConflictException
     *         This operation attempted to create a resource that already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         One of the parameters for the request is not valid.
     * @throws AccessDeniedException
     *         You don't have sufficient permissions to perform this action.
     * @throws ThrottlingException
     *         The request was throttled because of quota limits.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.UpdateDeliveryConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateDeliveryConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDeliveryConfigurationResponse updateDeliveryConfiguration(
            UpdateDeliveryConfigurationRequest updateDeliveryConfigurationRequest) throws ServiceUnavailableException,
            ConflictException, ResourceNotFoundException, ValidationException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDeliveryConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDeliveryConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDeliveryConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeliveryConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeliveryConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDeliveryConfigurationRequest, UpdateDeliveryConfigurationResponse>()
                            .withOperationName("UpdateDeliveryConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDeliveryConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDeliveryConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing log anomaly detector.
     * </p>
     *
     * @param updateLogAnomalyDetectorRequest
     * @return Result of the UpdateLogAnomalyDetector operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter is specified incorrectly.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ServiceUnavailableException
     *         The service cannot complete the request.
     * @throws OperationAbortedException
     *         Multiple concurrent requests to update the same resource were in conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudWatchLogsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudWatchLogsClient.UpdateLogAnomalyDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/logs-2014-03-28/UpdateLogAnomalyDetector" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateLogAnomalyDetectorResponse updateLogAnomalyDetector(
            UpdateLogAnomalyDetectorRequest updateLogAnomalyDetectorRequest) throws InvalidParameterException,
            ResourceNotFoundException, ServiceUnavailableException, OperationAbortedException, AwsServiceException,
            SdkClientException, CloudWatchLogsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLogAnomalyDetectorResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLogAnomalyDetectorResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "InvalidOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidOperationException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "LimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(LimitExceededException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "DataAlreadyAcceptedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DataAlreadyAcceptedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DataAlreadyAcceptedException::builder).build());
            case "InvalidSequenceTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSequenceTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidSequenceTokenException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "InternalStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalStreamingException::builder).build());
            case "OperationAbortedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationAbortedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationAbortedException::builder).build());
            case "SessionTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionTimeoutException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionTimeoutException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "UnrecognizedClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnrecognizedClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnrecognizedClientException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "TooManyTagsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TooManyTagsException::builder).build());
            case "MalformedQueryException":
                return Optional.of(ExceptionMetadata.builder().errorCode("MalformedQueryException").httpStatusCode(400)
                        .exceptionBuilderSupplier(MalformedQueryException::builder).build());
            case "ServiceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
            case "SessionStreamingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SessionStreamingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SessionStreamingException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateLogAnomalyDetectorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLogAnomalyDetectorRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudWatch Logs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLogAnomalyDetector");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLogAnomalyDetectorRequest, UpdateLogAnomalyDetectorResponse>()
                            .withOperationName("UpdateLogAnomalyDetector").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateLogAnomalyDetectorRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateLogAnomalyDetectorRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        CloudWatchLogsServiceClientConfigurationBuilder serviceConfigBuilder = new CloudWatchLogsServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(CloudWatchLogsException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final CloudWatchLogsServiceClientConfiguration serviceClientConfiguration() {
        return new CloudWatchLogsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
