/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveryDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeliveryDestinationResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetDeliveryDestinationResponse> {
    private static final SdkField<DeliveryDestination> DELIVERY_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deliveryDestination").getter(GetDeliveryDestinationResponse.getter(GetDeliveryDestinationResponse::deliveryDestination)).setter(GetDeliveryDestinationResponse.setter(Builder::deliveryDestination)).constructor(DeliveryDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeliveryDestinationResponse.memberNameToFieldInitializer();
    private final DeliveryDestination deliveryDestination;

    private GetDeliveryDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.deliveryDestination = builder.deliveryDestination;
    }

    public final DeliveryDestination deliveryDestination() {
        return this.deliveryDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeliveryDestinationResponse)) {
            return false;
        }
        GetDeliveryDestinationResponse other = (GetDeliveryDestinationResponse)((Object)obj);
        return Objects.equals(this.deliveryDestination(), other.deliveryDestination());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeliveryDestinationResponse").add("DeliveryDestination", (Object)this.deliveryDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryDestination": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DeliveryDestination>> map = new HashMap<String, SdkField<DeliveryDestination>>();
        map.put("deliveryDestination", DELIVERY_DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeliveryDestinationResponse, T> g) {
        return obj -> g.apply((GetDeliveryDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private DeliveryDestination deliveryDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeliveryDestinationResponse model) {
            super(model);
            this.deliveryDestination(model.deliveryDestination);
        }

        public final DeliveryDestination.Builder getDeliveryDestination() {
            return this.deliveryDestination != null ? this.deliveryDestination.toBuilder() : null;
        }

        public final void setDeliveryDestination(DeliveryDestination.BuilderImpl deliveryDestination) {
            this.deliveryDestination = deliveryDestination != null ? deliveryDestination.build() : null;
        }

        @Override
        public final Builder deliveryDestination(DeliveryDestination deliveryDestination) {
            this.deliveryDestination = deliveryDestination;
            return this;
        }

        @Override
        public GetDeliveryDestinationResponse build() {
            return new GetDeliveryDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeliveryDestinationResponse> {
        public Builder deliveryDestination(DeliveryDestination var1);

        default public Builder deliveryDestination(Consumer<DeliveryDestination.Builder> deliveryDestination) {
            return this.deliveryDestination((DeliveryDestination)((DeliveryDestination.Builder)DeliveryDestination.builder().applyMutation(deliveryDestination)).build());
        }
    }
}

