/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogRecordCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLogRecordResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetLogRecordResponse> {
    private static final SdkField<Map<String, String>> LOG_RECORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("logRecord").getter(GetLogRecordResponse.getter(GetLogRecordResponse::logRecord)).setter(GetLogRecordResponse.setter(Builder::logRecord)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logRecord").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_RECORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLogRecordResponse.memberNameToFieldInitializer();
    private final Map<String, String> logRecord;

    private GetLogRecordResponse(BuilderImpl builder) {
        super(builder);
        this.logRecord = builder.logRecord;
    }

    public final boolean hasLogRecord() {
        return this.logRecord != null && !(this.logRecord instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> logRecord() {
        return this.logRecord;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogRecord() ? this.logRecord() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogRecordResponse)) {
            return false;
        }
        GetLogRecordResponse other = (GetLogRecordResponse)((Object)obj);
        return this.hasLogRecord() == other.hasLogRecord() && Objects.equals(this.logRecord(), other.logRecord());
    }

    public final String toString() {
        return ToString.builder((String)"GetLogRecordResponse").add("LogRecord", this.hasLogRecord() ? this.logRecord() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logRecord": {
                return Optional.ofNullable(clazz.cast(this.logRecord()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("logRecord", LOG_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLogRecordResponse, T> g) {
        return obj -> g.apply((GetLogRecordResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> logRecord = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLogRecordResponse model) {
            super(model);
            this.logRecord(model.logRecord);
        }

        public final Map<String, String> getLogRecord() {
            if (this.logRecord instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.logRecord;
        }

        public final void setLogRecord(Map<String, String> logRecord) {
            this.logRecord = LogRecordCopier.copy(logRecord);
        }

        @Override
        public final Builder logRecord(Map<String, String> logRecord) {
            this.logRecord = LogRecordCopier.copy(logRecord);
            return this;
        }

        @Override
        public GetLogRecordResponse build() {
            return new GetLogRecordResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLogRecordResponse> {
        public Builder logRecord(Map<String, String> var1);
    }
}

