/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationDetails;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationStatus;
import software.amazon.awssdk.services.cloudwatchlogs.model.IntegrationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntegrationResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, GetIntegrationResponse> {
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationName").getter(GetIntegrationResponse.getter(GetIntegrationResponse::integrationName)).setter(GetIntegrationResponse.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationName").build()}).build();
    private static final SdkField<String> INTEGRATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationType").getter(GetIntegrationResponse.getter(GetIntegrationResponse::integrationTypeAsString)).setter(GetIntegrationResponse.setter(Builder::integrationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationType").build()}).build();
    private static final SdkField<String> INTEGRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integrationStatus").getter(GetIntegrationResponse.getter(GetIntegrationResponse::integrationStatusAsString)).setter(GetIntegrationResponse.setter(Builder::integrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationStatus").build()}).build();
    private static final SdkField<IntegrationDetails> INTEGRATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("integrationDetails").getter(GetIntegrationResponse.getter(GetIntegrationResponse::integrationDetails)).setter(GetIntegrationResponse.setter(Builder::integrationDetails)).constructor(IntegrationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrationDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGRATION_NAME_FIELD, INTEGRATION_TYPE_FIELD, INTEGRATION_STATUS_FIELD, INTEGRATION_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetIntegrationResponse.memberNameToFieldInitializer();
    private final String integrationName;
    private final String integrationType;
    private final String integrationStatus;
    private final IntegrationDetails integrationDetails;

    private GetIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationName = builder.integrationName;
        this.integrationType = builder.integrationType;
        this.integrationStatus = builder.integrationStatus;
        this.integrationDetails = builder.integrationDetails;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final IntegrationType integrationType() {
        return IntegrationType.fromValue(this.integrationType);
    }

    public final String integrationTypeAsString() {
        return this.integrationType;
    }

    public final IntegrationStatus integrationStatus() {
        return IntegrationStatus.fromValue(this.integrationStatus);
    }

    public final String integrationStatusAsString() {
        return this.integrationStatus;
    }

    public final IntegrationDetails integrationDetails() {
        return this.integrationDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationResponse)) {
            return false;
        }
        GetIntegrationResponse other = (GetIntegrationResponse)((Object)obj);
        return Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.integrationTypeAsString(), other.integrationTypeAsString()) && Objects.equals(this.integrationStatusAsString(), other.integrationStatusAsString()) && Objects.equals(this.integrationDetails(), other.integrationDetails());
    }

    public final String toString() {
        return ToString.builder((String)"GetIntegrationResponse").add("IntegrationName", (Object)this.integrationName()).add("IntegrationType", (Object)this.integrationTypeAsString()).add("IntegrationStatus", (Object)this.integrationStatusAsString()).add("IntegrationDetails", (Object)this.integrationDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "integrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "integrationType": {
                return Optional.ofNullable(clazz.cast(this.integrationTypeAsString()));
            }
            case "integrationStatus": {
                return Optional.ofNullable(clazz.cast(this.integrationStatusAsString()));
            }
            case "integrationDetails": {
                return Optional.ofNullable(clazz.cast(this.integrationDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("integrationName", INTEGRATION_NAME_FIELD);
        map.put("integrationType", INTEGRATION_TYPE_FIELD);
        map.put("integrationStatus", INTEGRATION_STATUS_FIELD);
        map.put("integrationDetails", INTEGRATION_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetIntegrationResponse, T> g) {
        return obj -> g.apply((GetIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String integrationName;
        private String integrationType;
        private String integrationStatus;
        private IntegrationDetails integrationDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationResponse model) {
            super(model);
            this.integrationName(model.integrationName);
            this.integrationType(model.integrationType);
            this.integrationStatus(model.integrationStatus);
            this.integrationDetails(model.integrationDetails);
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(String integrationType) {
            this.integrationType = integrationType;
        }

        @Override
        public final Builder integrationType(String integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        @Override
        public final Builder integrationType(IntegrationType integrationType) {
            this.integrationType(integrationType == null ? null : integrationType.toString());
            return this;
        }

        public final String getIntegrationStatus() {
            return this.integrationStatus;
        }

        public final void setIntegrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
        }

        @Override
        public final Builder integrationStatus(String integrationStatus) {
            this.integrationStatus = integrationStatus;
            return this;
        }

        @Override
        public final Builder integrationStatus(IntegrationStatus integrationStatus) {
            this.integrationStatus(integrationStatus == null ? null : integrationStatus.toString());
            return this;
        }

        public final IntegrationDetails.Builder getIntegrationDetails() {
            return this.integrationDetails != null ? this.integrationDetails.toBuilder() : null;
        }

        public final void setIntegrationDetails(IntegrationDetails.BuilderImpl integrationDetails) {
            this.integrationDetails = integrationDetails != null ? integrationDetails.build() : null;
        }

        @Override
        public final Builder integrationDetails(IntegrationDetails integrationDetails) {
            this.integrationDetails = integrationDetails;
            return this;
        }

        @Override
        public GetIntegrationResponse build() {
            return new GetIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIntegrationResponse> {
        public Builder integrationName(String var1);

        public Builder integrationType(String var1);

        public Builder integrationType(IntegrationType var1);

        public Builder integrationStatus(String var1);

        public Builder integrationStatus(IntegrationStatus var1);

        public Builder integrationDetails(IntegrationDetails var1);

        default public Builder integrationDetails(Consumer<IntegrationDetails.Builder> integrationDetails) {
            return this.integrationDetails((IntegrationDetails)((IntegrationDetails.Builder)IntegrationDetails.builder().applyMutation(integrationDetails)).build());
        }
    }
}

