/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliverySource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDeliverySourceResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutDeliverySourceResponse> {
    private static final SdkField<DeliverySource> DELIVERY_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deliverySource").getter(PutDeliverySourceResponse.getter(PutDeliverySourceResponse::deliverySource)).setter(PutDeliverySourceResponse.setter(Builder::deliverySource)).constructor(DeliverySource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliverySource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutDeliverySourceResponse.memberNameToFieldInitializer();
    private final DeliverySource deliverySource;

    private PutDeliverySourceResponse(BuilderImpl builder) {
        super(builder);
        this.deliverySource = builder.deliverySource;
    }

    public final DeliverySource deliverySource() {
        return this.deliverySource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverySource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliverySourceResponse)) {
            return false;
        }
        PutDeliverySourceResponse other = (PutDeliverySourceResponse)((Object)obj);
        return Objects.equals(this.deliverySource(), other.deliverySource());
    }

    public final String toString() {
        return ToString.builder((String)"PutDeliverySourceResponse").add("DeliverySource", (Object)this.deliverySource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliverySource": {
                return Optional.ofNullable(clazz.cast(this.deliverySource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DeliverySource>> map = new HashMap<String, SdkField<DeliverySource>>();
        map.put("deliverySource", DELIVERY_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDeliverySourceResponse, T> g) {
        return obj -> g.apply((PutDeliverySourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private DeliverySource deliverySource;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliverySourceResponse model) {
            super(model);
            this.deliverySource(model.deliverySource);
        }

        public final DeliverySource.Builder getDeliverySource() {
            return this.deliverySource != null ? this.deliverySource.toBuilder() : null;
        }

        public final void setDeliverySource(DeliverySource.BuilderImpl deliverySource) {
            this.deliverySource = deliverySource != null ? deliverySource.build() : null;
        }

        @Override
        public final Builder deliverySource(DeliverySource deliverySource) {
            this.deliverySource = deliverySource;
            return this;
        }

        @Override
        public PutDeliverySourceResponse build() {
            return new PutDeliverySourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDeliverySourceResponse> {
        public Builder deliverySource(DeliverySource var1);

        default public Builder deliverySource(Consumer<DeliverySource.Builder> deliverySource) {
            return this.deliverySource((DeliverySource)((DeliverySource.Builder)DeliverySource.builder().applyMutation(deliverySource)).build());
        }
    }
}

