/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.AccountIdsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroupClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLogGroupsRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DescribeLogGroupsRequest> {
    private static final SdkField<List<String>> ACCOUNT_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("accountIdentifiers").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::accountIdentifiers)).setter(DescribeLogGroupsRequest.setter(Builder::accountIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupNamePrefix").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::logGroupNamePrefix)).setter(DescribeLogGroupsRequest.setter(Builder::logGroupNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNamePrefix").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupNamePattern").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::logGroupNamePattern)).setter(DescribeLogGroupsRequest.setter(Builder::logGroupNamePattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupNamePattern").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::nextToken)).setter(DescribeLogGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::limit)).setter(DescribeLogGroupsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()}).build();
    private static final SdkField<Boolean> INCLUDE_LINKED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeLinkedAccounts").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::includeLinkedAccounts)).setter(DescribeLogGroupsRequest.setter(Builder::includeLinkedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeLinkedAccounts").build()}).build();
    private static final SdkField<String> LOG_GROUP_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupClass").getter(DescribeLogGroupsRequest.getter(DescribeLogGroupsRequest::logGroupClassAsString)).setter(DescribeLogGroupsRequest.setter(Builder::logGroupClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_IDENTIFIERS_FIELD, LOG_GROUP_NAME_PREFIX_FIELD, LOG_GROUP_NAME_PATTERN_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD, INCLUDE_LINKED_ACCOUNTS_FIELD, LOG_GROUP_CLASS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeLogGroupsRequest.memberNameToFieldInitializer();
    private final List<String> accountIdentifiers;
    private final String logGroupNamePrefix;
    private final String logGroupNamePattern;
    private final String nextToken;
    private final Integer limit;
    private final Boolean includeLinkedAccounts;
    private final String logGroupClass;

    private DescribeLogGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.accountIdentifiers = builder.accountIdentifiers;
        this.logGroupNamePrefix = builder.logGroupNamePrefix;
        this.logGroupNamePattern = builder.logGroupNamePattern;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
        this.includeLinkedAccounts = builder.includeLinkedAccounts;
        this.logGroupClass = builder.logGroupClass;
    }

    public final boolean hasAccountIdentifiers() {
        return this.accountIdentifiers != null && !(this.accountIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> accountIdentifiers() {
        return this.accountIdentifiers;
    }

    public final String logGroupNamePrefix() {
        return this.logGroupNamePrefix;
    }

    public final String logGroupNamePattern() {
        return this.logGroupNamePattern;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final Boolean includeLinkedAccounts() {
        return this.includeLinkedAccounts;
    }

    public final LogGroupClass logGroupClass() {
        return LogGroupClass.fromValue(this.logGroupClass);
    }

    public final String logGroupClassAsString() {
        return this.logGroupClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIdentifiers() ? this.accountIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupNamePattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeLinkedAccounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLogGroupsRequest)) {
            return false;
        }
        DescribeLogGroupsRequest other = (DescribeLogGroupsRequest)((Object)obj);
        return this.hasAccountIdentifiers() == other.hasAccountIdentifiers() && Objects.equals(this.accountIdentifiers(), other.accountIdentifiers()) && Objects.equals(this.logGroupNamePrefix(), other.logGroupNamePrefix()) && Objects.equals(this.logGroupNamePattern(), other.logGroupNamePattern()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.includeLinkedAccounts(), other.includeLinkedAccounts()) && Objects.equals(this.logGroupClassAsString(), other.logGroupClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLogGroupsRequest").add("AccountIdentifiers", this.hasAccountIdentifiers() ? this.accountIdentifiers() : null).add("LogGroupNamePrefix", (Object)this.logGroupNamePrefix()).add("LogGroupNamePattern", (Object)this.logGroupNamePattern()).add("NextToken", (Object)this.nextToken()).add("Limit", (Object)this.limit()).add("IncludeLinkedAccounts", (Object)this.includeLinkedAccounts()).add("LogGroupClass", (Object)this.logGroupClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.accountIdentifiers()));
            }
            case "logGroupNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.logGroupNamePrefix()));
            }
            case "logGroupNamePattern": {
                return Optional.ofNullable(clazz.cast(this.logGroupNamePattern()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "includeLinkedAccounts": {
                return Optional.ofNullable(clazz.cast(this.includeLinkedAccounts()));
            }
            case "logGroupClass": {
                return Optional.ofNullable(clazz.cast(this.logGroupClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountIdentifiers", ACCOUNT_IDENTIFIERS_FIELD);
        map.put("logGroupNamePrefix", LOG_GROUP_NAME_PREFIX_FIELD);
        map.put("logGroupNamePattern", LOG_GROUP_NAME_PATTERN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("includeLinkedAccounts", INCLUDE_LINKED_ACCOUNTS_FIELD);
        map.put("logGroupClass", LOG_GROUP_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeLogGroupsRequest, T> g) {
        return obj -> g.apply((DescribeLogGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private List<String> accountIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String logGroupNamePrefix;
        private String logGroupNamePattern;
        private String nextToken;
        private Integer limit;
        private Boolean includeLinkedAccounts;
        private String logGroupClass;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLogGroupsRequest model) {
            super(model);
            this.accountIdentifiers(model.accountIdentifiers);
            this.logGroupNamePrefix(model.logGroupNamePrefix);
            this.logGroupNamePattern(model.logGroupNamePattern);
            this.nextToken(model.nextToken);
            this.limit(model.limit);
            this.includeLinkedAccounts(model.includeLinkedAccounts);
            this.logGroupClass(model.logGroupClass);
        }

        public final Collection<String> getAccountIdentifiers() {
            if (this.accountIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIdentifiers;
        }

        public final void setAccountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
        }

        @Override
        public final Builder accountIdentifiers(Collection<String> accountIdentifiers) {
            this.accountIdentifiers = AccountIdsCopier.copy(accountIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIdentifiers(String ... accountIdentifiers) {
            this.accountIdentifiers(Arrays.asList(accountIdentifiers));
            return this;
        }

        public final String getLogGroupNamePrefix() {
            return this.logGroupNamePrefix;
        }

        public final void setLogGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
        }

        @Override
        public final Builder logGroupNamePrefix(String logGroupNamePrefix) {
            this.logGroupNamePrefix = logGroupNamePrefix;
            return this;
        }

        public final String getLogGroupNamePattern() {
            return this.logGroupNamePattern;
        }

        public final void setLogGroupNamePattern(String logGroupNamePattern) {
            this.logGroupNamePattern = logGroupNamePattern;
        }

        @Override
        public final Builder logGroupNamePattern(String logGroupNamePattern) {
            this.logGroupNamePattern = logGroupNamePattern;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Boolean getIncludeLinkedAccounts() {
            return this.includeLinkedAccounts;
        }

        public final void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
        }

        @Override
        public final Builder includeLinkedAccounts(Boolean includeLinkedAccounts) {
            this.includeLinkedAccounts = includeLinkedAccounts;
            return this;
        }

        public final String getLogGroupClass() {
            return this.logGroupClass;
        }

        public final void setLogGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
        }

        @Override
        public final Builder logGroupClass(String logGroupClass) {
            this.logGroupClass = logGroupClass;
            return this;
        }

        @Override
        public final Builder logGroupClass(LogGroupClass logGroupClass) {
            this.logGroupClass(logGroupClass == null ? null : logGroupClass.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLogGroupsRequest build() {
            return new DescribeLogGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLogGroupsRequest> {
        public Builder accountIdentifiers(Collection<String> var1);

        public Builder accountIdentifiers(String ... var1);

        public Builder logGroupNamePrefix(String var1);

        public Builder logGroupNamePattern(String var1);

        public Builder nextToken(String var1);

        public Builder limit(Integer var1);

        public Builder includeLinkedAccounts(Boolean var1);

        public Builder logGroupClass(String var1);

        public Builder logGroupClass(LogGroupClass var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

