/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplate;
import software.amazon.awssdk.services.cloudwatchlogs.model.ConfigurationTemplatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationTemplatesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationTemplatesResponse> {
    private static final SdkField<List<ConfigurationTemplate>> CONFIGURATION_TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configurationTemplates").getter(DescribeConfigurationTemplatesResponse.getter(DescribeConfigurationTemplatesResponse::configurationTemplates)).setter(DescribeConfigurationTemplatesResponse.setter(Builder::configurationTemplates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationTemplates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeConfigurationTemplatesResponse.getter(DescribeConfigurationTemplatesResponse::nextToken)).setter(DescribeConfigurationTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_TEMPLATES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("configurationTemplates", CONFIGURATION_TEMPLATES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfigurationTemplate> configurationTemplates;
    private final String nextToken;

    private DescribeConfigurationTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.configurationTemplates = builder.configurationTemplates;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationTemplates() {
        return this.configurationTemplates != null && !(this.configurationTemplates instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationTemplate> configurationTemplates() {
        return this.configurationTemplates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationTemplates() ? this.configurationTemplates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationTemplatesResponse)) {
            return false;
        }
        DescribeConfigurationTemplatesResponse other = (DescribeConfigurationTemplatesResponse)((Object)obj);
        return this.hasConfigurationTemplates() == other.hasConfigurationTemplates() && Objects.equals(this.configurationTemplates(), other.configurationTemplates()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationTemplatesResponse").add("ConfigurationTemplates", this.hasConfigurationTemplates() ? this.configurationTemplates() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configurationTemplates": {
                return Optional.ofNullable(clazz.cast(this.configurationTemplates()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationTemplatesResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationTemplate> configurationTemplates = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationTemplatesResponse model) {
            super(model);
            this.configurationTemplates(model.configurationTemplates);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationTemplate.Builder> getConfigurationTemplates() {
            List<ConfigurationTemplate.Builder> result = ConfigurationTemplatesCopier.copyToBuilder(this.configurationTemplates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationTemplates(Collection<ConfigurationTemplate.BuilderImpl> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplatesCopier.copyFromBuilder(configurationTemplates);
        }

        @Override
        public final Builder configurationTemplates(Collection<ConfigurationTemplate> configurationTemplates) {
            this.configurationTemplates = ConfigurationTemplatesCopier.copy(configurationTemplates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(ConfigurationTemplate ... configurationTemplates) {
            this.configurationTemplates(Arrays.asList(configurationTemplates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationTemplates(Consumer<ConfigurationTemplate.Builder> ... configurationTemplates) {
            this.configurationTemplates(Stream.of(configurationTemplates).map(c -> (ConfigurationTemplate)((ConfigurationTemplate.Builder)ConfigurationTemplate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeConfigurationTemplatesResponse build() {
            return new DescribeConfigurationTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationTemplatesResponse> {
        public Builder configurationTemplates(Collection<ConfigurationTemplate> var1);

        public Builder configurationTemplates(ConfigurationTemplate ... var1);

        public Builder configurationTemplates(Consumer<ConfigurationTemplate.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

