/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputLogEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputLogEvent> {
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("timestamp").getter(OutputLogEvent.getter(OutputLogEvent::timestamp)).setter(OutputLogEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(OutputLogEvent.getter(OutputLogEvent::message)).setter(OutputLogEvent.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Long> INGESTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ingestionTime").getter(OutputLogEvent.getter(OutputLogEvent::ingestionTime)).setter(OutputLogEvent.setter(Builder::ingestionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, MESSAGE_FIELD, INGESTION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputLogEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long timestamp;
    private final String message;
    private final Long ingestionTime;

    private OutputLogEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.message = builder.message;
        this.ingestionTime = builder.ingestionTime;
    }

    public final Long timestamp() {
        return this.timestamp;
    }

    public final String message() {
        return this.message;
    }

    public final Long ingestionTime() {
        return this.ingestionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLogEvent)) {
            return false;
        }
        OutputLogEvent other = (OutputLogEvent)obj;
        return Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.ingestionTime(), other.ingestionTime());
    }

    public final String toString() {
        return ToString.builder((String)"OutputLogEvent").add("Timestamp", (Object)this.timestamp()).add("Message", (Object)this.message()).add("IngestionTime", (Object)this.ingestionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ingestionTime": {
                return Optional.ofNullable(clazz.cast(this.ingestionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("ingestionTime", INGESTION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputLogEvent, T> g) {
        return obj -> g.apply((OutputLogEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long timestamp;
        private String message;
        private Long ingestionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLogEvent model) {
            this.timestamp(model.timestamp);
            this.message(model.message);
            this.ingestionTime(model.ingestionTime);
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getIngestionTime() {
            return this.ingestionTime;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        public OutputLogEvent build() {
            return new OutputLogEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputLogEvent> {
        public Builder timestamp(Long var1);

        public Builder message(String var1);

        public Builder ingestionTime(Long var1);
    }
}

