/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.RecordFieldsCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.S3DeliveryConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeliveryConfigurationRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, UpdateDeliveryConfigurationRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateDeliveryConfigurationRequest.getter(UpdateDeliveryConfigurationRequest::id)).setter(UpdateDeliveryConfigurationRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> RECORD_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recordFields").getter(UpdateDeliveryConfigurationRequest.getter(UpdateDeliveryConfigurationRequest::recordFields)).setter(UpdateDeliveryConfigurationRequest.setter(Builder::recordFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldDelimiter").getter(UpdateDeliveryConfigurationRequest.getter(UpdateDeliveryConfigurationRequest::fieldDelimiter)).setter(UpdateDeliveryConfigurationRequest.setter(Builder::fieldDelimiter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldDelimiter").build()}).build();
    private static final SdkField<S3DeliveryConfiguration> S3_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3DeliveryConfiguration").getter(UpdateDeliveryConfigurationRequest.getter(UpdateDeliveryConfigurationRequest::s3DeliveryConfiguration)).setter(UpdateDeliveryConfigurationRequest.setter(Builder::s3DeliveryConfiguration)).constructor(S3DeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DeliveryConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, RECORD_FIELDS_FIELD, FIELD_DELIMITER_FIELD, S3_DELIVERY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDeliveryConfigurationRequest.memberNameToFieldInitializer();
    private final String id;
    private final List<String> recordFields;
    private final String fieldDelimiter;
    private final S3DeliveryConfiguration s3DeliveryConfiguration;

    private UpdateDeliveryConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.recordFields = builder.recordFields;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.s3DeliveryConfiguration = builder.s3DeliveryConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasRecordFields() {
        return this.recordFields != null && !(this.recordFields instanceof SdkAutoConstructList);
    }

    public final List<String> recordFields() {
        return this.recordFields;
    }

    public final String fieldDelimiter() {
        return this.fieldDelimiter;
    }

    public final S3DeliveryConfiguration s3DeliveryConfiguration() {
        return this.s3DeliveryConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordFields() ? this.recordFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3DeliveryConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeliveryConfigurationRequest)) {
            return false;
        }
        UpdateDeliveryConfigurationRequest other = (UpdateDeliveryConfigurationRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && this.hasRecordFields() == other.hasRecordFields() && Objects.equals(this.recordFields(), other.recordFields()) && Objects.equals(this.fieldDelimiter(), other.fieldDelimiter()) && Objects.equals(this.s3DeliveryConfiguration(), other.s3DeliveryConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeliveryConfigurationRequest").add("Id", (Object)this.id()).add("RecordFields", this.hasRecordFields() ? this.recordFields() : null).add("FieldDelimiter", (Object)this.fieldDelimiter()).add("S3DeliveryConfiguration", (Object)this.s3DeliveryConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "recordFields": {
                return Optional.ofNullable(clazz.cast(this.recordFields()));
            }
            case "fieldDelimiter": {
                return Optional.ofNullable(clazz.cast(this.fieldDelimiter()));
            }
            case "s3DeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.s3DeliveryConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("recordFields", RECORD_FIELDS_FIELD);
        map.put("fieldDelimiter", FIELD_DELIMITER_FIELD);
        map.put("s3DeliveryConfiguration", S3_DELIVERY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeliveryConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateDeliveryConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String id;
        private List<String> recordFields = DefaultSdkAutoConstructList.getInstance();
        private String fieldDelimiter;
        private S3DeliveryConfiguration s3DeliveryConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeliveryConfigurationRequest model) {
            super(model);
            this.id(model.id);
            this.recordFields(model.recordFields);
            this.fieldDelimiter(model.fieldDelimiter);
            this.s3DeliveryConfiguration(model.s3DeliveryConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getRecordFields() {
            if (this.recordFields instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordFields;
        }

        public final void setRecordFields(Collection<String> recordFields) {
            this.recordFields = RecordFieldsCopier.copy(recordFields);
        }

        @Override
        public final Builder recordFields(Collection<String> recordFields) {
            this.recordFields = RecordFieldsCopier.copy(recordFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordFields(String ... recordFields) {
            this.recordFields(Arrays.asList(recordFields));
            return this;
        }

        public final String getFieldDelimiter() {
            return this.fieldDelimiter;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final S3DeliveryConfiguration.Builder getS3DeliveryConfiguration() {
            return this.s3DeliveryConfiguration != null ? this.s3DeliveryConfiguration.toBuilder() : null;
        }

        public final void setS3DeliveryConfiguration(S3DeliveryConfiguration.BuilderImpl s3DeliveryConfiguration) {
            this.s3DeliveryConfiguration = s3DeliveryConfiguration != null ? s3DeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder s3DeliveryConfiguration(S3DeliveryConfiguration s3DeliveryConfiguration) {
            this.s3DeliveryConfiguration = s3DeliveryConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeliveryConfigurationRequest build() {
            return new UpdateDeliveryConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeliveryConfigurationRequest> {
        public Builder id(String var1);

        public Builder recordFields(Collection<String> var1);

        public Builder recordFields(String ... var1);

        public Builder fieldDelimiter(String var1);

        public Builder s3DeliveryConfiguration(S3DeliveryConfiguration var1);

        default public Builder s3DeliveryConfiguration(Consumer<S3DeliveryConfiguration.Builder> s3DeliveryConfiguration) {
            return this.s3DeliveryConfiguration((S3DeliveryConfiguration)((S3DeliveryConfiguration.Builder)S3DeliveryConfiguration.builder().applyMutation(s3DeliveryConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

