/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LiveTailSessionLogEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LiveTailSessionLogEvent> {
    private static final SdkField<String> LOG_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logStreamName").getter(LiveTailSessionLogEvent.getter(LiveTailSessionLogEvent::logStreamName)).setter(LiveTailSessionLogEvent.setter(Builder::logStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logStreamName").build()}).build();
    private static final SdkField<String> LOG_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupIdentifier").getter(LiveTailSessionLogEvent.getter(LiveTailSessionLogEvent::logGroupIdentifier)).setter(LiveTailSessionLogEvent.setter(Builder::logGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupIdentifier").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(LiveTailSessionLogEvent.getter(LiveTailSessionLogEvent::message)).setter(LiveTailSessionLogEvent.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<Long> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("timestamp").getter(LiveTailSessionLogEvent.getter(LiveTailSessionLogEvent::timestamp)).setter(LiveTailSessionLogEvent.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<Long> INGESTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ingestionTime").getter(LiveTailSessionLogEvent.getter(LiveTailSessionLogEvent::ingestionTime)).setter(LiveTailSessionLogEvent.setter(Builder::ingestionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_STREAM_NAME_FIELD, LOG_GROUP_IDENTIFIER_FIELD, MESSAGE_FIELD, TIMESTAMP_FIELD, INGESTION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LiveTailSessionLogEvent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logStreamName;
    private final String logGroupIdentifier;
    private final String message;
    private final Long timestamp;
    private final Long ingestionTime;

    private LiveTailSessionLogEvent(BuilderImpl builder) {
        this.logStreamName = builder.logStreamName;
        this.logGroupIdentifier = builder.logGroupIdentifier;
        this.message = builder.message;
        this.timestamp = builder.timestamp;
        this.ingestionTime = builder.ingestionTime;
    }

    public final String logStreamName() {
        return this.logStreamName;
    }

    public final String logGroupIdentifier() {
        return this.logGroupIdentifier;
    }

    public final String message() {
        return this.message;
    }

    public final Long timestamp() {
        return this.timestamp;
    }

    public final Long ingestionTime() {
        return this.ingestionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LiveTailSessionLogEvent)) {
            return false;
        }
        LiveTailSessionLogEvent other = (LiveTailSessionLogEvent)obj;
        return Objects.equals(this.logStreamName(), other.logStreamName()) && Objects.equals(this.logGroupIdentifier(), other.logGroupIdentifier()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.ingestionTime(), other.ingestionTime());
    }

    public final String toString() {
        return ToString.builder((String)"LiveTailSessionLogEvent").add("LogStreamName", (Object)this.logStreamName()).add("LogGroupIdentifier", (Object)this.logGroupIdentifier()).add("Message", (Object)this.message()).add("Timestamp", (Object)this.timestamp()).add("IngestionTime", (Object)this.ingestionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logStreamName": {
                return Optional.ofNullable(clazz.cast(this.logStreamName()));
            }
            case "logGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.logGroupIdentifier()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ingestionTime": {
                return Optional.ofNullable(clazz.cast(this.ingestionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("logStreamName", LOG_STREAM_NAME_FIELD);
        map.put("logGroupIdentifier", LOG_GROUP_IDENTIFIER_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("ingestionTime", INGESTION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LiveTailSessionLogEvent, T> g) {
        return obj -> g.apply((LiveTailSessionLogEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logStreamName;
        private String logGroupIdentifier;
        private String message;
        private Long timestamp;
        private Long ingestionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LiveTailSessionLogEvent model) {
            this.logStreamName(model.logStreamName);
            this.logGroupIdentifier(model.logGroupIdentifier);
            this.message(model.message);
            this.timestamp(model.timestamp);
            this.ingestionTime(model.ingestionTime);
        }

        public final String getLogStreamName() {
            return this.logStreamName;
        }

        public final void setLogStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
        }

        @Override
        public final Builder logStreamName(String logStreamName) {
            this.logStreamName = logStreamName;
            return this;
        }

        public final String getLogGroupIdentifier() {
            return this.logGroupIdentifier;
        }

        public final void setLogGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
        }

        @Override
        public final Builder logGroupIdentifier(String logGroupIdentifier) {
            this.logGroupIdentifier = logGroupIdentifier;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Long getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Long getIngestionTime() {
            return this.ingestionTime;
        }

        public final void setIngestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
        }

        @Override
        public final Builder ingestionTime(Long ingestionTime) {
            this.ingestionTime = ingestionTime;
            return this;
        }

        public LiveTailSessionLogEvent build() {
            return new LiveTailSessionLogEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LiveTailSessionLogEvent> {
        public Builder logStreamName(String var1);

        public Builder logGroupIdentifier(String var1);

        public Builder message(String var1);

        public Builder timestamp(Long var1);

        public Builder ingestionTime(Long var1);
    }
}

