/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.OpenSearchResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchApplication> {
    private static final SdkField<String> APPLICATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationEndpoint").getter(OpenSearchApplication.getter(OpenSearchApplication::applicationEndpoint)).setter(OpenSearchApplication.setter(Builder::applicationEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationEndpoint").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(OpenSearchApplication.getter(OpenSearchApplication::applicationArn)).setter(OpenSearchApplication.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(OpenSearchApplication.getter(OpenSearchApplication::applicationId)).setter(OpenSearchApplication.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<OpenSearchResourceStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(OpenSearchApplication.getter(OpenSearchApplication::status)).setter(OpenSearchApplication.setter(Builder::status)).constructor(OpenSearchResourceStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ENDPOINT_FIELD, APPLICATION_ARN_FIELD, APPLICATION_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationEndpoint", APPLICATION_ENDPOINT_FIELD);
            this.put("applicationArn", APPLICATION_ARN_FIELD);
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationEndpoint;
    private final String applicationArn;
    private final String applicationId;
    private final OpenSearchResourceStatus status;

    private OpenSearchApplication(BuilderImpl builder) {
        this.applicationEndpoint = builder.applicationEndpoint;
        this.applicationArn = builder.applicationArn;
        this.applicationId = builder.applicationId;
        this.status = builder.status;
    }

    public final String applicationEndpoint() {
        return this.applicationEndpoint;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final OpenSearchResourceStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchApplication)) {
            return false;
        }
        OpenSearchApplication other = (OpenSearchApplication)obj;
        return Objects.equals(this.applicationEndpoint(), other.applicationEndpoint()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchApplication").add("ApplicationEndpoint", (Object)this.applicationEndpoint()).add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationId", (Object)this.applicationId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.applicationEndpoint()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchApplication, T> g) {
        return obj -> g.apply((OpenSearchApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationEndpoint;
        private String applicationArn;
        private String applicationId;
        private OpenSearchResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchApplication model) {
            this.applicationEndpoint(model.applicationEndpoint);
            this.applicationArn(model.applicationArn);
            this.applicationId(model.applicationId);
            this.status(model.status);
        }

        public final String getApplicationEndpoint() {
            return this.applicationEndpoint;
        }

        public final void setApplicationEndpoint(String applicationEndpoint) {
            this.applicationEndpoint = applicationEndpoint;
        }

        @Override
        public final Builder applicationEndpoint(String applicationEndpoint) {
            this.applicationEndpoint = applicationEndpoint;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final OpenSearchResourceStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(OpenSearchResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(OpenSearchResourceStatus status) {
            this.status = status;
            return this;
        }

        public OpenSearchApplication build() {
            return new OpenSearchApplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchApplication> {
        public Builder applicationEndpoint(String var1);

        public Builder applicationArn(String var1);

        public Builder applicationId(String var1);

        public Builder status(OpenSearchResourceStatus var1);

        default public Builder status(Consumer<OpenSearchResourceStatus.Builder> status) {
            return this.status((OpenSearchResourceStatus)((OpenSearchResourceStatus.Builder)OpenSearchResourceStatus.builder().applyMutation(status)).build());
        }
    }
}

