/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.RejectedEntityInfo;
import software.amazon.awssdk.services.cloudwatchlogs.model.RejectedLogEventsInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLogEventsResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, PutLogEventsResponse> {
    private static final SdkField<String> NEXT_SEQUENCE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextSequenceToken").getter(PutLogEventsResponse.getter(PutLogEventsResponse::nextSequenceToken)).setter(PutLogEventsResponse.setter(Builder::nextSequenceToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSequenceToken").build()}).build();
    private static final SdkField<RejectedLogEventsInfo> REJECTED_LOG_EVENTS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rejectedLogEventsInfo").getter(PutLogEventsResponse.getter(PutLogEventsResponse::rejectedLogEventsInfo)).setter(PutLogEventsResponse.setter(Builder::rejectedLogEventsInfo)).constructor(RejectedLogEventsInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectedLogEventsInfo").build()}).build();
    private static final SdkField<RejectedEntityInfo> REJECTED_ENTITY_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rejectedEntityInfo").getter(PutLogEventsResponse.getter(PutLogEventsResponse::rejectedEntityInfo)).setter(PutLogEventsResponse.setter(Builder::rejectedEntityInfo)).constructor(RejectedEntityInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectedEntityInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_SEQUENCE_TOKEN_FIELD, REJECTED_LOG_EVENTS_INFO_FIELD, REJECTED_ENTITY_INFO_FIELD));
    private final String nextSequenceToken;
    private final RejectedLogEventsInfo rejectedLogEventsInfo;
    private final RejectedEntityInfo rejectedEntityInfo;

    private PutLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.nextSequenceToken = builder.nextSequenceToken;
        this.rejectedLogEventsInfo = builder.rejectedLogEventsInfo;
        this.rejectedEntityInfo = builder.rejectedEntityInfo;
    }

    public final String nextSequenceToken() {
        return this.nextSequenceToken;
    }

    public final RejectedLogEventsInfo rejectedLogEventsInfo() {
        return this.rejectedLogEventsInfo;
    }

    public final RejectedEntityInfo rejectedEntityInfo() {
        return this.rejectedEntityInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSequenceToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedLogEventsInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectedEntityInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsResponse)) {
            return false;
        }
        PutLogEventsResponse other = (PutLogEventsResponse)((Object)obj);
        return Objects.equals(this.nextSequenceToken(), other.nextSequenceToken()) && Objects.equals(this.rejectedLogEventsInfo(), other.rejectedLogEventsInfo()) && Objects.equals(this.rejectedEntityInfo(), other.rejectedEntityInfo());
    }

    public final String toString() {
        return ToString.builder((String)"PutLogEventsResponse").add("NextSequenceToken", (Object)this.nextSequenceToken()).add("RejectedLogEventsInfo", (Object)this.rejectedLogEventsInfo()).add("RejectedEntityInfo", (Object)this.rejectedEntityInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextSequenceToken": {
                return Optional.ofNullable(clazz.cast(this.nextSequenceToken()));
            }
            case "rejectedLogEventsInfo": {
                return Optional.ofNullable(clazz.cast(this.rejectedLogEventsInfo()));
            }
            case "rejectedEntityInfo": {
                return Optional.ofNullable(clazz.cast(this.rejectedEntityInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutLogEventsResponse, T> g) {
        return obj -> g.apply((PutLogEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String nextSequenceToken;
        private RejectedLogEventsInfo rejectedLogEventsInfo;
        private RejectedEntityInfo rejectedEntityInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLogEventsResponse model) {
            super(model);
            this.nextSequenceToken(model.nextSequenceToken);
            this.rejectedLogEventsInfo(model.rejectedLogEventsInfo);
            this.rejectedEntityInfo(model.rejectedEntityInfo);
        }

        public final String getNextSequenceToken() {
            return this.nextSequenceToken;
        }

        public final void setNextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
        }

        @Override
        public final Builder nextSequenceToken(String nextSequenceToken) {
            this.nextSequenceToken = nextSequenceToken;
            return this;
        }

        public final RejectedLogEventsInfo.Builder getRejectedLogEventsInfo() {
            return this.rejectedLogEventsInfo != null ? this.rejectedLogEventsInfo.toBuilder() : null;
        }

        public final void setRejectedLogEventsInfo(RejectedLogEventsInfo.BuilderImpl rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo != null ? rejectedLogEventsInfo.build() : null;
        }

        @Override
        public final Builder rejectedLogEventsInfo(RejectedLogEventsInfo rejectedLogEventsInfo) {
            this.rejectedLogEventsInfo = rejectedLogEventsInfo;
            return this;
        }

        public final RejectedEntityInfo.Builder getRejectedEntityInfo() {
            return this.rejectedEntityInfo != null ? this.rejectedEntityInfo.toBuilder() : null;
        }

        public final void setRejectedEntityInfo(RejectedEntityInfo.BuilderImpl rejectedEntityInfo) {
            this.rejectedEntityInfo = rejectedEntityInfo != null ? rejectedEntityInfo.build() : null;
        }

        @Override
        public final Builder rejectedEntityInfo(RejectedEntityInfo rejectedEntityInfo) {
            this.rejectedEntityInfo = rejectedEntityInfo;
            return this;
        }

        @Override
        public PutLogEventsResponse build() {
            return new PutLogEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutLogEventsResponse> {
        public Builder nextSequenceToken(String var1);

        public Builder rejectedLogEventsInfo(RejectedLogEventsInfo var1);

        default public Builder rejectedLogEventsInfo(Consumer<RejectedLogEventsInfo.Builder> rejectedLogEventsInfo) {
            return this.rejectedLogEventsInfo((RejectedLogEventsInfo)((RejectedLogEventsInfo.Builder)RejectedLogEventsInfo.builder().applyMutation(rejectedLogEventsInfo)).build());
        }

        public Builder rejectedEntityInfo(RejectedEntityInfo var1);

        default public Builder rejectedEntityInfo(Consumer<RejectedEntityInfo.Builder> rejectedEntityInfo) {
            return this.rejectedEntityInfo((RejectedEntityInfo)((RejectedEntityInfo.Builder)RejectedEntityInfo.builder().applyMutation(rejectedEntityInfo)).build());
        }
    }
}

