/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OutputFormat {
    JSON("json"),
    PLAIN("plain"),
    W3_C("w3c"),
    RAW("raw"),
    PARQUET("parquet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OutputFormat> VALUE_MAP;
    private final String value;

    private OutputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OutputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OutputFormat> knownValues() {
        EnumSet<OutputFormat> knownValues = EnumSet.allOf(OutputFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OutputFormat.class, OutputFormat::toString);
    }
}

