/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLogAnomalyDetectorRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, DeleteLogAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorArn").getter(DeleteLogAnomalyDetectorRequest.getter(DeleteLogAnomalyDetectorRequest::anomalyDetectorArn)).setter(DeleteLogAnomalyDetectorRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD));
    private final String anomalyDetectorArn;

    private DeleteLogAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLogAnomalyDetectorRequest)) {
            return false;
        }
        DeleteLogAnomalyDetectorRequest other = (DeleteLogAnomalyDetectorRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteLogAnomalyDetectorRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteLogAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((DeleteLogAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLogAnomalyDetectorRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteLogAnomalyDetectorRequest build() {
            return new DeleteLogAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteLogAnomalyDetectorRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

