/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutDeliveryDestinationPolicyRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, PutDeliveryDestinationPolicyRequest> {
    private static final SdkField<String> DELIVERY_DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationName").getter(PutDeliveryDestinationPolicyRequest.getter(PutDeliveryDestinationPolicyRequest::deliveryDestinationName)).setter(PutDeliveryDestinationPolicyRequest.setter(Builder::deliveryDestinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationName").build()}).build();
    private static final SdkField<String> DELIVERY_DESTINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryDestinationPolicy").getter(PutDeliveryDestinationPolicyRequest.getter(PutDeliveryDestinationPolicyRequest::deliveryDestinationPolicy)).setter(PutDeliveryDestinationPolicyRequest.setter(Builder::deliveryDestinationPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryDestinationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_DESTINATION_NAME_FIELD, DELIVERY_DESTINATION_POLICY_FIELD));
    private final String deliveryDestinationName;
    private final String deliveryDestinationPolicy;

    private PutDeliveryDestinationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.deliveryDestinationName = builder.deliveryDestinationName;
        this.deliveryDestinationPolicy = builder.deliveryDestinationPolicy;
    }

    public final String deliveryDestinationName() {
        return this.deliveryDestinationName;
    }

    public final String deliveryDestinationPolicy() {
        return this.deliveryDestinationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryDestinationPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDeliveryDestinationPolicyRequest)) {
            return false;
        }
        PutDeliveryDestinationPolicyRequest other = (PutDeliveryDestinationPolicyRequest)((Object)obj);
        return Objects.equals(this.deliveryDestinationName(), other.deliveryDestinationName()) && Objects.equals(this.deliveryDestinationPolicy(), other.deliveryDestinationPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutDeliveryDestinationPolicyRequest").add("DeliveryDestinationName", (Object)this.deliveryDestinationName()).add("DeliveryDestinationPolicy", (Object)this.deliveryDestinationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveryDestinationName": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationName()));
            }
            case "deliveryDestinationPolicy": {
                return Optional.ofNullable(clazz.cast(this.deliveryDestinationPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutDeliveryDestinationPolicyRequest, T> g) {
        return obj -> g.apply((PutDeliveryDestinationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String deliveryDestinationName;
        private String deliveryDestinationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDeliveryDestinationPolicyRequest model) {
            super(model);
            this.deliveryDestinationName(model.deliveryDestinationName);
            this.deliveryDestinationPolicy(model.deliveryDestinationPolicy);
        }

        public final String getDeliveryDestinationName() {
            return this.deliveryDestinationName;
        }

        public final void setDeliveryDestinationName(String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
        }

        @Override
        public final Builder deliveryDestinationName(String deliveryDestinationName) {
            this.deliveryDestinationName = deliveryDestinationName;
            return this;
        }

        public final String getDeliveryDestinationPolicy() {
            return this.deliveryDestinationPolicy;
        }

        public final void setDeliveryDestinationPolicy(String deliveryDestinationPolicy) {
            this.deliveryDestinationPolicy = deliveryDestinationPolicy;
        }

        @Override
        public final Builder deliveryDestinationPolicy(String deliveryDestinationPolicy) {
            this.deliveryDestinationPolicy = deliveryDestinationPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDeliveryDestinationPolicyRequest build() {
            return new PutDeliveryDestinationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutDeliveryDestinationPolicyRequest> {
        public Builder deliveryDestinationName(String var1);

        public Builder deliveryDestinationPolicy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

