/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DeliveriesCopier;
import software.amazon.awssdk.services.cloudwatchlogs.model.Delivery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDeliveriesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, DescribeDeliveriesResponse> {
    private static final SdkField<List<Delivery>> DELIVERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deliveries").getter(DescribeDeliveriesResponse.getter(DescribeDeliveriesResponse::deliveries)).setter(DescribeDeliveriesResponse.setter(Builder::deliveries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Delivery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDeliveriesResponse.getter(DescribeDeliveriesResponse::nextToken)).setter(DescribeDeliveriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<Delivery> deliveries;
    private final String nextToken;

    private DescribeDeliveriesResponse(BuilderImpl builder) {
        super(builder);
        this.deliveries = builder.deliveries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDeliveries() {
        return this.deliveries != null && !(this.deliveries instanceof SdkAutoConstructList);
    }

    public final List<Delivery> deliveries() {
        return this.deliveries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeliveries() ? this.deliveries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeliveriesResponse)) {
            return false;
        }
        DescribeDeliveriesResponse other = (DescribeDeliveriesResponse)((Object)obj);
        return this.hasDeliveries() == other.hasDeliveries() && Objects.equals(this.deliveries(), other.deliveries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDeliveriesResponse").add("Deliveries", this.hasDeliveries() ? this.deliveries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deliveries": {
                return Optional.ofNullable(clazz.cast(this.deliveries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeliveriesResponse, T> g) {
        return obj -> g.apply((DescribeDeliveriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private List<Delivery> deliveries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeliveriesResponse model) {
            super(model);
            this.deliveries(model.deliveries);
            this.nextToken(model.nextToken);
        }

        public final List<Delivery.Builder> getDeliveries() {
            List<Delivery.Builder> result = DeliveriesCopier.copyToBuilder(this.deliveries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeliveries(Collection<Delivery.BuilderImpl> deliveries) {
            this.deliveries = DeliveriesCopier.copyFromBuilder(deliveries);
        }

        @Override
        public final Builder deliveries(Collection<Delivery> deliveries) {
            this.deliveries = DeliveriesCopier.copy(deliveries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveries(Delivery ... deliveries) {
            this.deliveries(Arrays.asList(deliveries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deliveries(Consumer<Delivery.Builder> ... deliveries) {
            this.deliveries(Stream.of(deliveries).map(c -> (Delivery)((Delivery.Builder)Delivery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDeliveriesResponse build() {
            return new DescribeDeliveriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDeliveriesResponse> {
        public Builder deliveries(Collection<Delivery> var1);

        public Builder deliveries(Delivery ... var1);

        public Builder deliveries(Consumer<Delivery.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

